/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URLConnection;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.util.ImageTransform;
import org.visallo.core.util.ImageTransformExtractor;

public class ImageUtils {
    public static byte[] resize(byte[] imageData, int maxWidth, int maxHeight, int jpegQuality) {
        ByteArrayOutputStream out;
        block15: {
            out = new ByteArrayOutputStream();
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
                Preconditions.checkNotNull((Object)image, (Object)"Could not load image");
                int type = ImageUtils.thumbnailType(image);
                ImageTransform imageTransform = ImageTransformExtractor.getImageTransform(imageData);
                image = ImageUtils.reorientImage(image, imageTransform.isYAxisFlipNeeded(), imageTransform.getCWRotationNeeded());
                int[] newImageDims = ImageUtils.getScaledDimension(image.getWidth(), image.getHeight(), maxWidth, maxHeight);
                BufferedImage resizedImage = new BufferedImage(newImageDims[0], newImageDims[1], type);
                Graphics2D g = resizedImage.createGraphics();
                if (image.getColorModel().getNumComponents() > 3) {
                    g.drawImage(image, 0, 0, resizedImage.getWidth(), resizedImage.getHeight(), null);
                    g.dispose();
                    ImageIO.write((RenderedImage)resizedImage, "png", out);
                    break block15;
                }
                g.drawImage(image, 0, 0, resizedImage.getWidth(), resizedImage.getHeight(), Color.BLACK, null);
                g.dispose();
                try (MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(out);){
                    JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                    jpegParams.setCompressionMode(2);
                    jpegParams.setCompressionQuality((float)jpegQuality / 100.0f);
                    ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                    jpgWriter.setOutput(imageOutputStream);
                    IIOImage outputImage = new IIOImage(resizedImage, null, null);
                    jpgWriter.write(null, outputImage, jpegParams);
                    jpgWriter.dispose();
                }
            }
            catch (IOException e) {
                throw new VisalloResourceNotFoundException("Could not resize image", e);
            }
        }
        return out.toByteArray();
    }

    public static BufferedImage reorientImage(BufferedImage image, boolean yAxisFlipNeeded, int cwRotationNeeded) {
        BufferedImage orientedImage = image;
        if (!yAxisFlipNeeded && (cwRotationNeeded %= 360) == 0) {
            return image;
        }
        if (yAxisFlipNeeded && cwRotationNeeded == 0) {
            orientedImage = ImageUtils.flipImageHorizontally(image);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 180) {
            orientedImage = ImageUtils.rotateImage(image, 180);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 180) {
            orientedImage = ImageUtils.flipImageVertically(image);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 270) {
            orientedImage = ImageUtils.flipImageVertically(image);
            orientedImage = ImageUtils.rotateImage(orientedImage, 90);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 90) {
            orientedImage = ImageUtils.rotateImage(image, 90);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 90) {
            orientedImage = ImageUtils.flipImageVertically(image);
            orientedImage = ImageUtils.rotateImage(orientedImage, 270);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 270) {
            orientedImage = ImageUtils.rotateImage(image, 270);
        } else {
            return image;
        }
        return orientedImage;
    }

    public static BufferedImage flipImageHorizontally(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int type = ImageUtils.thumbnailType(image);
        BufferedImage result = new BufferedImage(width, height, type);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, width, 0, 0, height, 0, 0, width, height, null);
        g.dispose();
        return result;
    }

    public static BufferedImage flipImageVertically(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int type = ImageUtils.thumbnailType(image);
        BufferedImage result = new BufferedImage(width, height, type);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, height, width, 0, 0, 0, width, height, null);
        g.dispose();
        return result;
    }

    public static BufferedImage rotateImage(BufferedImage image, int cwRotationNeeded) {
        double angle = Math.toRadians(cwRotationNeeded);
        int type = ImageUtils.thumbnailType(image);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = (int)Math.floor((double)width * cos + (double)height * sin);
        int newHeight = (int)Math.floor((double)height * cos + (double)width * sin);
        BufferedImage result = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g = result.createGraphics();
        g.translate((newWidth - width) / 2, (newHeight - height) / 2);
        g.rotate(angle, width / 2, height / 2);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static int[] getScaledDimension(int originalWidth, int originalHeight, int boundWidth, int boundHeight) {
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return new int[]{newWidth, newHeight};
    }

    public static int thumbnailType(BufferedImage image) {
        if (image.getColorModel().getNumComponents() > 3) {
            return 6;
        }
        if (image.getColorModel().getNumColorComponents() == 3) {
            return 5;
        }
        return 1;
    }

    public static ImageFormat getImageFormat(InputStream in) throws IOException {
        int pushBackLimit = 100;
        PushbackInputStream pushBackIn = new PushbackInputStream(in, pushBackLimit);
        byte[] firstBytes = new byte[pushBackLimit];
        if (pushBackIn.read(firstBytes) <= 0) {
            throw new IOException("Could not read image");
        }
        pushBackIn.unread(firstBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(firstBytes);
        String mimeType = URLConnection.guessContentTypeFromStream(bais);
        if (!mimeType.startsWith("image/")) {
            mimeType = "image/" + mimeType;
        }
        return new ImageFormat(pushBackIn, mimeType);
    }

    public static class ImageFormat {
        private final PushbackInputStream pushBackIn;
        private final String imageMimeType;

        public ImageFormat(PushbackInputStream pushBackIn, String imageMimeType) {
            this.pushBackIn = pushBackIn;
            this.imageMimeType = imageMimeType;
        }

        public PushbackInputStream getPushBackIn() {
            return this.pushBackIn;
        }

        public String getImageMimeType() {
            return this.imageMimeType;
        }
    }
}

