/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.config;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.visallo.core.config.Configuration;
import org.visallo.core.config.ConfigurationLoader;
import org.visallo.core.config.FileConfigurationLoader;
import org.visallo.core.exception.VisalloException;

public class HashMapConfigurationLoader
extends ConfigurationLoader {
    public HashMapConfigurationLoader(String propertiesString) {
        this(HashMapConfigurationLoader.parseStringToProperties(propertiesString));
    }

    public HashMapConfigurationLoader(Map initParameters) {
        super(initParameters);
    }

    @Override
    public Configuration createConfiguration() {
        return new Configuration(this, this.getInitParameters());
    }

    @Override
    public File resolveFileName(String fileName) {
        return FileConfigurationLoader.resolveLocalFileName(fileName);
    }

    private static Properties parseStringToProperties(String propertiesString) {
        Properties properties = new Properties();
        StringReader reader = new StringReader(propertiesString);
        try {
            properties.load(reader);
        }
        catch (IOException ex) {
            throw new VisalloException("Could not load properties string", ex);
        }
        return properties;
    }
}

