/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class VisalloResourceBundle
extends ResourceBundle {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VisalloResourceBundle.class);
    private static final Pattern ALIAS_KEY_PATTERN = Pattern.compile("@\\{([\\w\\.]+)\\}");
    private Properties properties;
    private ResourceBundle rootResourceBundle;
    private Properties aliasedProperties = new Properties();

    public VisalloResourceBundle(Properties properties, ResourceBundle rootResourceBundle) {
        this.properties = properties;
        this.rootResourceBundle = rootResourceBundle;
        this.aliasedProperties = this.getAliasProperties();
    }

    @Override
    protected Object handleGetObject(String key) {
        String value = this.aliasedProperties.getProperty(key);
        if (value != null) {
            return value;
        }
        value = this.properties.getProperty(key);
        if (value != null) {
            return value;
        }
        return this.rootResourceBundle.getString(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.aliasedProperties.keySet());
        keys.addAll(this.properties.keySet());
        keys.addAll(this.rootResourceBundle.keySet());
        return Collections.enumeration(keys);
    }

    protected Properties getAliasProperties() {
        Properties properties = new Properties();
        Enumeration<String> keys = this.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = this.handleGetObject(key).toString();
            Matcher m = ALIAS_KEY_PATTERN.matcher(value);
            while (m.find(0)) {
                String aliasKey = m.group(1);
                try {
                    aliasKey = (String)this.handleGetObject(aliasKey);
                }
                catch (MissingResourceException ex) {
                    LOGGER.debug("No key for alias: %s", aliasKey);
                }
                catch (Exception ex) {
                    throw ex;
                }
                String aliasedValue = m.replaceFirst(aliasKey);
                properties.setProperty(key, aliasedValue);
                m = ALIAS_KEY_PATTERN.matcher(aliasedValue);
            }
        }
        return properties;
    }
}

