/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.model.Description;
import org.visallo.core.model.Name;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.web.clientapi.model.VisibilityJson;

@Name(value="Metadata Processor")
@Description(value="Adds properties to a vertex from a metadata JSON document")
public class MetadataGraphPropertyWorker
extends GraphPropertyWorker {
    @Override
    public void execute(InputStream in, GraphPropertyWorkData data) throws Exception {
        JSONObject propertyJson;
        int i;
        JSONObject metadataJson = this.getMetadataJson(data);
        JSONArray propertiesJson = metadataJson.optJSONArray("properties");
        if (propertiesJson == null) {
            return;
        }
        for (i = 0; i < propertiesJson.length(); ++i) {
            propertyJson = propertiesJson.getJSONObject(i);
            this.setProperty(propertyJson, data);
        }
        this.getGraph().flush();
        for (i = 0; i < propertiesJson.length(); ++i) {
            propertyJson = propertiesJson.getJSONObject(i);
            this.queueProperty(propertyJson, data);
        }
    }

    public void queueProperty(JSONObject propertyJson, GraphPropertyWorkData data) {
        String propertyKey = propertyJson.optString("key");
        if (propertyKey == null) {
            propertyKey = "";
        }
        String propertyName = propertyJson.optString("name");
        this.getWorkQueueRepository().pushGraphPropertyQueue(data.getElement(), propertyKey, propertyName, data.getPriority());
    }

    private void setProperty(JSONObject propertyJson, GraphPropertyWorkData data) {
        String propertyKey = propertyJson.optString("key", null);
        if (propertyKey == null) {
            propertyKey = "";
        }
        String propertyName = propertyJson.optString("name", null);
        Preconditions.checkNotNull((Object)propertyName, (Object)("name is required: " + propertyJson.toString()));
        String propertyValue = propertyJson.optString("value", null);
        Preconditions.checkNotNull((Object)propertyValue, (Object)("value is required: " + propertyJson.toString()));
        String visibilitySource = propertyJson.optString("visibilitySource", null);
        Visibility visibility = visibilitySource == null ? data.getVisibility() : this.getVisibilityTranslator().toVisibility(visibilitySource).getVisibility();
        Metadata metadata = new Metadata();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, VisibilityJson.updateVisibilitySource(null, (String)visibilitySource), this.getVisibilityTranslator().getDefaultVisibility());
        data.getElement().addPropertyValue(propertyKey, propertyName, (Object)propertyValue, metadata, visibility, this.getAuthorizations());
    }

    public JSONObject getMetadataJson(GraphPropertyWorkData data) throws IOException {
        StreamingPropertyValue metadataJsonValue = (StreamingPropertyValue)VisalloProperties.METADATA_JSON.getPropertyValue(data.getElement());
        try (InputStream metadataJsonIn = metadataJsonValue.getInputStream();){
            String metadataJsonString = IOUtils.toString((InputStream)metadataJsonIn);
            JSONObject jSONObject = new JSONObject(metadataJsonString);
            return jSONObject;
        }
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property != null) {
            return false;
        }
        StreamingPropertyValue mappingJson = (StreamingPropertyValue)VisalloProperties.METADATA_JSON.getPropertyValue(element);
        return mappingJson != null;
    }
}

