/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.graph;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Visibility;
import org.vertexium.mutation.EdgeMutation;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.PropertyMetadata;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.VisibilityJson;

public class ElementUpdateContext<T extends Element> {
    private final VisibilityTranslator visibilityTranslator;
    private final ElementMutation<T> mutation;
    private final User user;
    private final List<VisalloPropertyUpdate> properties = new ArrayList<VisalloPropertyUpdate>();
    private final T element;

    public ElementUpdateContext(VisibilityTranslator visibilityTranslator, ElementMutation<T> mutation, User user) {
        this.visibilityTranslator = visibilityTranslator;
        this.mutation = mutation;
        this.user = user;
        this.element = mutation instanceof ExistingElementMutation ? ((ExistingElementMutation)mutation).getElement() : null;
    }

    public boolean isNewElement() {
        return this.getElement() == null;
    }

    public ElementMutation<T> getMutation() {
        return this.mutation;
    }

    public List<VisalloPropertyUpdate> getProperties() {
        return this.properties;
    }

    public T getElement() {
        return this.element;
    }

    public void updateBuiltInProperties(Date modifiedDate, VisibilityJson visibilityJson) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisalloProperties.MODIFIED_BY.updateProperty(this, this.user.getUserId(), defaultVisibility);
        VisalloProperties.MODIFIED_DATE.updateProperty(this, modifiedDate, defaultVisibility);
        VisalloProperties.VISIBILITY_JSON.updateProperty(this, visibilityJson, defaultVisibility);
    }

    public void updateBuiltInProperties(PropertyMetadata propertyMetadata) {
        this.updateBuiltInProperties(propertyMetadata.getModifiedDate(), propertyMetadata.getVisibilityJson());
    }

    public void setConceptType(String conceptType) {
        if (this.isEdgeMutation()) {
            throw new IllegalArgumentException("Cannot set concept type on edges");
        }
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisalloProperties.CONCEPT_TYPE.updateProperty(this, conceptType, defaultVisibility);
    }

    private boolean isEdgeMutation() {
        ExistingElementMutation m;
        if (this.getMutation() instanceof EdgeMutation) {
            return true;
        }
        return this.getMutation() instanceof ExistingElementMutation && (m = (ExistingElementMutation)this.getMutation()).getElement() instanceof Edge;
    }
}

