/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.simpleorm.SimpleOrmContext;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.model.notification.ExpirationAge;
import org.visallo.core.model.notification.NotificationRepository;
import org.visallo.core.model.notification.UserNotification;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.StreamUtil;

public class UserNotificationRepository
extends NotificationRepository {
    private static final String VISIBILITY_STRING = "";
    private final WorkQueueRepository workQueueRepository;
    private UserRepository userRepository;

    @Inject
    public UserNotificationRepository(SimpleOrmSession simpleOrmSession, WorkQueueRepository workQueueRepository) {
        super(simpleOrmSession);
        this.workQueueRepository = workQueueRepository;
    }

    @VisibleForTesting
    public UserNotificationRepository(SimpleOrmSession simpleOrmSession, WorkQueueRepository workQueueRepository, UserRepository userRepository) {
        this(simpleOrmSession, workQueueRepository);
        this.userRepository = userRepository;
    }

    public Stream<UserNotification> getActiveNotifications(User user) {
        Date now = new Date();
        return this.findAll(user).filter(notification -> user.getUserId().equals(notification.getUserId()) && notification.getSentDate().before(now) && notification.isActive());
    }

    private Stream<UserNotification> findAll(User user) {
        SimpleOrmContext ctx = this.getUserRepository().getSimpleOrmContext(user);
        return StreamUtil.stream(this.getSimpleOrmSession().findAll(UserNotification.class, ctx));
    }

    public Stream<UserNotification> getActiveNotificationsOlderThan(int duration, TimeUnit timeUnit, User user) {
        Date now = new Date();
        return this.findAll(user).filter(notification -> {
            if (!notification.isActive()) {
                return false;
            }
            Date t = new Date(notification.getSentDate().getTime() + timeUnit.toMillis(duration));
            return t.before(now);
        });
    }

    public UserNotification createNotification(String userId, String title, String message, String actionEvent, JSONObject actionPayload, ExpirationAge expirationAge, User authUser) {
        UserNotification notification = new UserNotification(userId, title, message, actionEvent, actionPayload, expirationAge);
        this.saveNotification(notification, authUser);
        return notification;
    }

    public UserNotification createNotification(String userId, String title, String message, String externalUrl, ExpirationAge expirationAge, User authUser) {
        UserNotification notification = new UserNotification(userId, title, message, null, null, expirationAge);
        notification.setExternalUrl(externalUrl);
        this.saveNotification(notification, authUser);
        return notification;
    }

    private void saveNotification(UserNotification notification, User authUser) {
        this.getSimpleOrmSession().save((Object)notification, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext(authUser));
        this.workQueueRepository.pushUserNotification(notification);
    }

    public UserNotification getNotification(String notificationId, User user) {
        return (UserNotification)this.getSimpleOrmSession().findById(UserNotification.class, notificationId, this.getUserRepository().getSimpleOrmContext(user));
    }

    public void markRead(String[] notificationIds, User user) {
        ArrayList<UserNotification> toSave = new ArrayList<UserNotification>();
        for (String notificationId : notificationIds) {
            UserNotification notification = this.getNotification(notificationId, user);
            Preconditions.checkNotNull((Object)notification, (Object)("Could not find notification with id " + notificationId));
            notification.setMarkedRead(true);
            toSave.add(notification);
        }
        this.getSimpleOrmSession().saveMany(toSave, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext(user));
    }

    public void markNotified(Iterable<String> notificationIds, User user) {
        ArrayList<UserNotification> toSave = new ArrayList<UserNotification>();
        for (String notificationId : notificationIds) {
            UserNotification notification = this.getNotification(notificationId, user);
            Preconditions.checkNotNull((Object)notification, (Object)("Could not find notification with id " + notificationId));
            notification.setNotified(true);
            toSave.add(notification);
        }
        this.getSimpleOrmSession().saveMany(toSave, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext(user));
    }

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }
}

