/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.util.StreamUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class WorkspaceEntity
implements Serializable {
    static long serialVersionUID = 1L;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceEntity.class);
    private final String entityVertexId;
    private transient Vertex vertex;

    public WorkspaceEntity(String entityVertexId, Vertex vertex) {
        this.entityVertexId = entityVertexId;
        this.vertex = vertex;
    }

    public String getEntityVertexId() {
        return this.entityVertexId;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public static Iterable<Vertex> toVertices(Iterable<WorkspaceEntity> workspaceEntities, Graph graph, Authorizations authorizations) {
        List vertexIdsToFetch = StreamUtil.stream(workspaceEntities).filter(we -> we.getVertex() == null).map(we -> we.getEntityVertexId()).collect(Collectors.toList());
        Map<String, Vertex> fetchedVerticesMap = StreamUtil.stream(graph.getVertices(vertexIdsToFetch, authorizations)).distinct().collect(Collectors.toMap(v -> v.getId(), v -> v));
        return StreamUtil.stream(workspaceEntities).map(workspaceEntity -> {
            if (workspaceEntity.getVertex() == null) {
                workspaceEntity.vertex = (Vertex)fetchedVerticesMap.get(workspaceEntity.getEntityVertexId());
                if (workspaceEntity.vertex == null) {
                    LOGGER.error("Could not find vertex for WorkspaceEntity: %s", workspaceEntity);
                    return null;
                }
            }
            return workspaceEntity.getVertex();
        }).collect(Collectors.toList());
    }

    public String toString() {
        return "WorkspaceEntity{entityVertexId='" + this.entityVertexId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceEntity that = (WorkspaceEntity)o;
        return this.entityVertexId.equals(that.entityVertexId);
    }

    public int hashCode() {
        return this.entityVertexId.hashCode();
    }
}

