/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import java.util.OptionalInt;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.workspace.LayoutHints;
import org.visallo.core.util.StreamUtil;
import org.visallo.web.clientapi.model.GraphPosition;

public class WorkspaceLayoutHelper {
    public static GraphPosition findOpening(Iterable<GraphPosition> existingPositions, GraphPosition graphPosition, LayoutHints layoutHints) {
        while (WorkspaceLayoutHelper.isOccupied(existingPositions, graphPosition, layoutHints)) {
            graphPosition = WorkspaceLayoutHelper.findNextPosition(graphPosition, layoutHints);
        }
        return graphPosition;
    }

    public static GraphPosition findNextPosition(GraphPosition graphPosition, LayoutHints layoutHints) {
        int x = graphPosition.getX();
        int y = graphPosition.getY();
        int minX = layoutHints.getMinX() == null ? 0 : layoutHints.getMinX();
        int maxX = layoutHints.getMaxX() == null ? 0 : layoutHints.getMaxX();
        int minY = layoutHints.getMinY() == null ? 0 : layoutHints.getMinY();
        int maxY = layoutHints.getMaxY() == null ? 0 : layoutHints.getMaxY();
        boolean overflow = false;
        switch (layoutHints.getDirection()) {
            case LEFT_TO_RIGHT: {
                if (layoutHints.getMaxX() == null || (x += layoutHints.getXSpacing()) <= layoutHints.getMaxX() - layoutHints.getXSpacing()) break;
                x = minX;
                overflow = true;
                break;
            }
            case RIGHT_TO_LEFT: {
                if (layoutHints.getMinX() == null || (x -= layoutHints.getXSpacing()) >= layoutHints.getMinX()) break;
                x = maxX;
                overflow = true;
                break;
            }
            case TOP_TO_BOTTOM: {
                if (layoutHints.getMaxY() == null || (y += layoutHints.getYSpacing()) <= layoutHints.getMaxY() - layoutHints.getYSpacing()) break;
                y = minY;
                overflow = true;
                break;
            }
            case BOTTOM_TO_TOP: {
                if (layoutHints.getMinY() == null || (y -= layoutHints.getYSpacing()) >= layoutHints.getMinY()) break;
                y = maxY;
                overflow = true;
                break;
            }
            default: {
                throw new VisalloException("unhandled direction: " + (Object)((Object)layoutHints.getDirection()));
            }
        }
        if (overflow) {
            switch (layoutHints.getOverflowDirection()) {
                case LEFT_TO_RIGHT: {
                    x += layoutHints.getXSpacing();
                    break;
                }
                case RIGHT_TO_LEFT: {
                    x -= layoutHints.getXSpacing();
                    break;
                }
                case TOP_TO_BOTTOM: {
                    y += layoutHints.getYSpacing();
                    break;
                }
                case BOTTOM_TO_TOP: {
                    y -= layoutHints.getYSpacing();
                    break;
                }
                default: {
                    throw new VisalloException("unhandled direction: " + (Object)((Object)layoutHints.getDirection()));
                }
            }
        }
        return new GraphPosition(x, y);
    }

    public static boolean isOccupied(Iterable<GraphPosition> existingPositions, GraphPosition graphPosition, LayoutHints layoutHints) {
        return StreamUtil.stream(existingPositions).anyMatch(gp -> gp.getX() > graphPosition.getX() - layoutHints.getXSpacing() && gp.getX() < graphPosition.getX() + layoutHints.getXSpacing() && gp.getY() > graphPosition.getY() - layoutHints.getYSpacing() && gp.getY() < graphPosition.getY() + layoutHints.getYSpacing());
    }

    public static GraphPosition findBottomLeftOpening(Iterable<GraphPosition> graphPositions) {
        int minX = WorkspaceLayoutHelper.findMinX(graphPositions).orElse(0);
        int maxY = WorkspaceLayoutHelper.findMaxY(graphPositions).orElse(0);
        LayoutHints layoutHints = new LayoutHints().setDirection(LayoutHints.Direction.TOP_TO_BOTTOM, LayoutHints.Direction.LEFT_TO_RIGHT);
        return WorkspaceLayoutHelper.findOpening(graphPositions, new GraphPosition(minX, maxY), layoutHints);
    }

    public static GraphPosition findTopLeftOpening(Iterable<GraphPosition> graphPositions) {
        int minX = WorkspaceLayoutHelper.findMinX(graphPositions).orElse(0);
        int maxY = WorkspaceLayoutHelper.findMinY(graphPositions).orElse(0);
        LayoutHints layoutHints = new LayoutHints().setDirection(LayoutHints.Direction.BOTTOM_TO_TOP, LayoutHints.Direction.LEFT_TO_RIGHT);
        return WorkspaceLayoutHelper.findOpening(graphPositions, new GraphPosition(minX, maxY), layoutHints);
    }

    public static OptionalInt findMinX(Iterable<GraphPosition> graphPositions) {
        return StreamUtil.stream(graphPositions).mapToInt(GraphPosition::getX).min();
    }

    public static OptionalInt findMaxX(Iterable<GraphPosition> graphPositions) {
        return StreamUtil.stream(graphPositions).mapToInt(GraphPosition::getX).max();
    }

    public static OptionalInt findMinY(Iterable<GraphPosition> graphPositions) {
        return StreamUtil.stream(graphPositions).mapToInt(GraphPosition::getY).min();
    }

    public static OptionalInt findMaxY(Iterable<GraphPosition> graphPositions) {
        return StreamUtil.stream(graphPositions).mapToInt(GraphPosition::getY).max();
    }
}

