/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace.product;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.RelatedEdge;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.visallo.core.model.graph.ElementUpdateContext;
import org.visallo.core.model.graph.GraphUpdateContext;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.workspace.product.WorkProduct;
import org.visallo.core.model.workspace.product.WorkProductHasElements;
import org.visallo.core.user.User;
import org.visallo.core.util.JSONUtil;
import org.visallo.core.util.StreamUtil;

public abstract class WorkProductElements
implements WorkProduct,
WorkProductHasElements {
    public static final String WORKSPACE_PRODUCT_TO_ENTITY_RELATIONSHIP_IRI = "http://visallo.org/workspace/product#toEntity";
    private final OntologyRepository ontologyRepository;
    private final AuthorizationRepository authorizationRepository;

    protected WorkProductElements(OntologyRepository ontologyRepository, AuthorizationRepository authorizationRepository) {
        this.ontologyRepository = ontologyRepository;
        this.authorizationRepository = authorizationRepository;
        this.addProductToEntityRelationshipToOntology(ontologyRepository);
    }

    private void addProductToEntityRelationshipToOntology(OntologyRepository ontologyRepository) {
        Concept productConcept = ontologyRepository.getConceptByIRI("http://visallo.org/workspace#product");
        Preconditions.checkNotNull((Object)productConcept, (Object)"Could not find http://visallo.org/workspace#product");
        Concept thingConcept = ontologyRepository.getConceptByIRI("http://www.w3.org/2002/07/owl#Thing");
        Preconditions.checkNotNull((Object)thingConcept, (Object)"Could not find http://www.w3.org/2002/07/owl#Thing");
        ArrayList<Concept> domainConcepts = new ArrayList<Concept>();
        domainConcepts.add(productConcept);
        ArrayList<Concept> rangeConcepts = new ArrayList<Concept>();
        rangeConcepts.add(thingConcept);
        ontologyRepository.getOrCreateRelationshipType(null, domainConcepts, rangeConcepts, WORKSPACE_PRODUCT_TO_ENTITY_RELATIONSHIP_IRI);
        ontologyRepository.clearCache();
    }

    @Override
    public void update(GraphUpdateContext ctx, Vertex workspaceVertex, Vertex productVertex, JSONObject params, User user, Visibility visibility, Authorizations authorizations) {
        JSONArray removeVertices;
        if (params == null) {
            return;
        }
        JSONObject updateVertices = params.optJSONObject("updateVertices");
        if (updateVertices != null) {
            ArrayList vertexIds = Lists.newArrayList((Iterator)updateVertices.keys());
            for (String id2 : vertexIds) {
                JSONObject updateData = updateVertices.getJSONObject(id2);
                String edgeId = this.getEdgeId(productVertex.getId(), id2);
                EdgeBuilderByVertexId edgeBuilder = ctx.getGraph().prepareEdge(edgeId, productVertex.getId(), id2, WORKSPACE_PRODUCT_TO_ENTITY_RELATIONSHIP_IRI, visibility);
                ctx.update(edgeBuilder, elemCtx -> this.updateProductEdge(elemCtx, updateData, visibility));
            }
        }
        if ((removeVertices = params.optJSONArray("removeVertices")) != null) {
            JSONUtil.toList(removeVertices).forEach(id -> ctx.getGraph().softDeleteEdge(this.getEdgeId(productVertex.getId(), (String)id), authorizations));
        }
    }

    @Override
    public JSONObject getExtendedData(Graph graph, Vertex workspaceVertex, Vertex productVertex, JSONObject params, User user, Authorizations authorizations) {
        JSONObject extendedData = new JSONObject();
        String id = productVertex.getId();
        if (params.optBoolean("includeVertices")) {
            JSONArray vertices = new JSONArray();
            ArrayList productVertexEdges = Lists.newArrayList((Iterable)productVertex.getEdges(Direction.OUT, WORKSPACE_PRODUCT_TO_ENTITY_RELATIONSHIP_IRI, authorizations));
            List ids = productVertexEdges.stream().map(edge -> edge.getOtherVertexId(id)).collect(Collectors.toList());
            Map othersById = StreamUtil.stream(graph.getVertices(ids, FetchHint.NONE, authorizations)).collect(Collectors.toMap(Element::getId, Function.identity()));
            for (Edge propertyVertexEdge : productVertexEdges) {
                String otherId = propertyVertexEdge.getOtherVertexId(id);
                JSONObject vertex = new JSONObject();
                vertex.put("id", (Object)otherId);
                if (!othersById.containsKey(otherId)) {
                    vertex.put("unauthorized", true);
                }
                this.setEdgeJson(propertyVertexEdge, vertex);
                vertices.put((Object)vertex);
            }
            extendedData.put("vertices", (Object)vertices);
        }
        if (params.optBoolean("includeEdges")) {
            JSONArray edges = new JSONArray();
            Authorizations systemAuthorizations = this.authorizationRepository.getGraphAuthorizations(user, "visallo");
            ArrayList productVertices = Lists.newArrayList((Iterable)productVertex.getVertices(Direction.OUT, WORKSPACE_PRODUCT_TO_ENTITY_RELATIONSHIP_IRI, systemAuthorizations));
            Iterable relatedEdges = graph.findRelatedEdgeSummaryForVertices((Iterable)productVertices, authorizations);
            for (RelatedEdge relatedEdge : relatedEdges) {
                JSONObject edge2 = new JSONObject();
                edge2.put("edgeId", (Object)relatedEdge.getEdgeId());
                edge2.put("label", (Object)relatedEdge.getLabel());
                edge2.put("outVertexId", (Object)relatedEdge.getOutVertexId());
                edge2.put("inVertexId", (Object)relatedEdge.getInVertexId());
                edges.put((Object)edge2);
            }
            extendedData.put("edges", (Object)edges);
        }
        return extendedData;
    }

    protected abstract void setEdgeJson(Edge var1, JSONObject var2);

    protected abstract void updateProductEdge(ElementUpdateContext<Edge> var1, JSONObject var2, Visibility var3);

    private String getEdgeId(String productId, String vertexId) {
        return productId + "_hasVertex_" + vertexId;
    }
}

