/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.action;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Collection;
import org.json.JSONObject;
import org.visallo.core.action.Action;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;

public class ActionRepository {
    private Collection<Action> actions;
    private final Configuration configuration;

    @Inject
    public ActionRepository(Configuration configuration) {
        this.configuration = configuration;
    }

    public Action getActionFromActionData(JSONObject json) {
        String type = json.getString("type");
        for (Action action : this.getActions()) {
            if (!action.getClass().getName().equals(type)) continue;
            return action;
        }
        return null;
    }

    protected Collection<Action> getActions() {
        if (this.actions == null) {
            this.actions = InjectHelper.getInjectedServices(Action.class, this.configuration);
        }
        return this.actions;
    }

    public void checkActionData(JSONObject actionData) {
        Preconditions.checkNotNull((Object)actionData, (Object)"actionData cannot by null");
        Action action = this.getActionFromActionData(actionData);
        Preconditions.checkNotNull((Object)action, (Object)("Could not find action for data: " + actionData.toString()));
        action.validateData(actionData);
    }
}

