/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.action;

import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.visallo.core.action.Action;
import org.visallo.core.action.ActionExecuteParameters;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class SetPropertyActionBase
extends Action {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SetPropertyActionBase.class);
    public static final String PROPERTY_PROPERTY_KEY = "propertyKey";
    public static final String PROPERTY_PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VISIBILITY = "visibility";
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;

    protected SetPropertyActionBase(Graph graph, WorkQueueRepository workQueueRepository) {
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
    }

    @Override
    public void validateData(JSONObject actionData) {
        super.validateData(actionData);
        this.validateDataHas(actionData, PROPERTY_PROPERTY_KEY);
        this.validateDataHas(actionData, PROPERTY_PROPERTY_NAME);
        this.validateDataHas(actionData, PROPERTY_VISIBILITY);
    }

    @Override
    public void execute(ActionExecuteParameters parameters, User user, Authorizations authorizations) {
        String propertyKey = parameters.getData().getString(PROPERTY_PROPERTY_KEY);
        String propertyName = parameters.getData().getString(PROPERTY_PROPERTY_NAME);
        String visibility = parameters.getData().getString(PROPERTY_VISIBILITY);
        Object newValue = this.getNewValue(parameters);
        Visibility vis = new Visibility(visibility);
        LOGGER.debug("setting property %s:%s[%s] = %s", propertyName, propertyKey, vis, newValue);
        parameters.getElement().addPropertyValue(propertyKey, propertyName, newValue, vis, authorizations);
        this.graph.flush();
        Property property = parameters.getElement().getProperty(propertyKey, propertyName);
        this.workQueueRepository.pushGraphPropertyQueue(parameters.getElement(), property, Priority.NORMAL);
    }

    protected abstract Object getNewValue(ActionExecuteParameters var1);

    protected static JSONObject createActionData(Class clazz, String propertyKey, String propertyName, String visibility) {
        JSONObject json = Action.createActionData(clazz);
        json.put(PROPERTY_PROPERTY_KEY, (Object)propertyKey);
        json.put(PROPERTY_PROPERTY_NAME, (Object)propertyName);
        json.put(PROPERTY_VISIBILITY, (Object)visibility);
        return json;
    }
}

