/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.model.workQueue.Priority;

public class GraphPropertyMessage {
    private static final ObjectMapper mapper = new ObjectMapper();
    private String workspaceId;
    private String visibilitySource;
    private Priority priority;
    private boolean traceEnabled;
    private Property[] properties;
    private String[] graphVertexId;
    private String[] graphEdgeId;
    private String propertyKey;
    private String propertyName;
    private ElementOrPropertyStatus status;
    private Long beforeActionTimestamp;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public GraphPropertyMessage setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public String getVisibilitySource() {
        return this.visibilitySource;
    }

    public GraphPropertyMessage setVisibilitySource(String visibilitySource) {
        this.visibilitySource = visibilitySource;
        return this;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public GraphPropertyMessage setPriority(Priority priority) {
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        this.priority = priority;
        return this;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public GraphPropertyMessage setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public GraphPropertyMessage setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public String[] getGraphEdgeId() {
        return this.graphEdgeId;
    }

    public GraphPropertyMessage setGraphEdgeId(String[] graphEdgeId) {
        this.graphEdgeId = graphEdgeId;
        return this;
    }

    public String[] getGraphVertexId() {
        return this.graphVertexId;
    }

    public GraphPropertyMessage setGraphVertexId(String[] graphVertexId) {
        this.graphVertexId = graphVertexId;
        return this;
    }

    public ElementOrPropertyStatus getStatus() {
        return this.status;
    }

    public GraphPropertyMessage setStatus(ElementOrPropertyStatus status) {
        this.status = status;
        return this;
    }

    public Long getBeforeActionTimestamp() {
        return this.beforeActionTimestamp;
    }

    @JsonIgnore
    public long getBeforeActionTimestampOrDefault() {
        return this.getBeforeActionTimestamp() == null ? -1L : this.getBeforeActionTimestamp();
    }

    public GraphPropertyMessage setBeforeActionTimestamp(Long beforeActionTimestamp) {
        this.beforeActionTimestamp = beforeActionTimestamp;
        return this;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public GraphPropertyMessage setProperties(Property[] properties) {
        this.properties = properties;
        return this;
    }

    public static GraphPropertyMessage create(byte[] data) {
        try {
            GraphPropertyMessage message = (GraphPropertyMessage)mapper.readValue(data, GraphPropertyMessage.class);
            Preconditions.checkNotNull((Object)((Object)message.getPriority()), (Object)"priority cannot be null");
            return message;
        }
        catch (IOException e) {
            throw new VisalloException("Could not create " + GraphPropertyMessage.class.getName() + " from " + new String(data), e);
        }
    }

    public String toJsonString() {
        try {
            Preconditions.checkNotNull((Object)((Object)this.getPriority()), (Object)"priority cannot be null");
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new VisalloException("Could not write " + this.getClass().getName(), e);
        }
    }

    public byte[] toBytes() {
        try {
            Preconditions.checkNotNull((Object)((Object)this.getPriority()), (Object)"priority cannot be null");
            return mapper.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new VisalloException("Could not write " + this.getClass().getName(), e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, true);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    public static class Property {
        private String propertyKey;
        private String propertyName;
        private ElementOrPropertyStatus status;
        private Long beforeActionTimestamp;

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public Property setPropertyKey(String propertyKey) {
            this.propertyKey = propertyKey;
            return this;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Property setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public ElementOrPropertyStatus getStatus() {
            return this.status;
        }

        public Property setStatus(ElementOrPropertyStatus status) {
            this.status = status;
            return this;
        }

        public Long getBeforeActionTimestamp() {
            return this.beforeActionTimestamp;
        }

        @JsonIgnore
        public long getBeforeActionTimestampOrDefault() {
            return this.getBeforeActionTimestamp() == null ? -1L : this.getBeforeActionTimestamp();
        }

        public Property setBeforeActionTimestamp(Long beforeActionTimestamp) {
            this.beforeActionTimestamp = beforeActionTimestamp;
            return this;
        }
    }
}

