/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.artifactThumbnails;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage reOrientImage(BufferedImage image, boolean yAxisFlipNeeded, int cwRotationNeeded) {
        BufferedImage orientedImage = image;
        if (!yAxisFlipNeeded && (cwRotationNeeded %= 360) == 0) {
            return image;
        }
        if (yAxisFlipNeeded && cwRotationNeeded == 0) {
            orientedImage = ImageUtils.flipImageHorizontally(image);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 180) {
            orientedImage = ImageUtils.rotateImage(image, 180);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 180) {
            orientedImage = ImageUtils.flipImageVertically(image);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 270) {
            orientedImage = ImageUtils.flipImageVertically(image);
            orientedImage = ImageUtils.rotateImage(orientedImage, 90);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 90) {
            orientedImage = ImageUtils.rotateImage(image, 90);
        } else if (yAxisFlipNeeded && cwRotationNeeded == 90) {
            orientedImage = ImageUtils.flipImageVertically(image);
            orientedImage = ImageUtils.rotateImage(orientedImage, 270);
        } else if (!yAxisFlipNeeded && cwRotationNeeded == 270) {
            orientedImage = ImageUtils.rotateImage(image, 270);
        } else {
            return image;
        }
        return orientedImage;
    }

    public static BufferedImage flipImageHorizontally(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int type = ImageUtils.thumbnailType(image);
        BufferedImage result = new BufferedImage(width, height, type);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, width, 0, 0, height, 0, 0, width, height, null);
        g.dispose();
        return result;
    }

    public static BufferedImage flipImageVertically(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int type = ImageUtils.thumbnailType(image);
        BufferedImage result = new BufferedImage(width, height, type);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, height, width, 0, 0, 0, width, height, null);
        g.dispose();
        return result;
    }

    public static BufferedImage rotateImage(BufferedImage image, int cwRotationNeeded) {
        double angle = Math.toRadians(cwRotationNeeded);
        int type = ImageUtils.thumbnailType(image);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = (int)Math.floor((double)width * cos + (double)height * sin);
        int newHeight = (int)Math.floor((double)height * cos + (double)width * sin);
        BufferedImage result = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g = result.createGraphics();
        g.translate((newWidth - width) / 2, (newHeight - height) / 2);
        g.rotate(angle, width / 2, height / 2);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static int thumbnailType(BufferedImage image) {
        if (image.getColorModel().getNumComponents() > 3 || ImageUtils.isGrayScale(image)) {
            return 6;
        }
        if (image.getColorModel().getNumColorComponents() == 3) {
            return 5;
        }
        return 1;
    }

    public static String thumbnailFormat(BufferedImage image) {
        if (image.getColorModel().getNumComponents() > 3 || ImageUtils.isGrayScale(image)) {
            return "png";
        }
        return "jpg";
    }

    private static boolean isGrayScale(BufferedImage image) {
        return image.getColorModel().getColorSpace().getType() == 6;
    }
}

