/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.visallo.core.exception.VisalloException;

public class SearchOptions {
    private final Map<String, Object> parameters;
    private final String workspaceId;

    public SearchOptions(Map<String, Object> parameters, String workspaceId) {
        this.parameters = parameters;
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public <T> T getOptionalParameter(String parameterName, Class<T> resultType) {
        Object obj = this.parameters.get(parameterName);
        if (obj == null) {
            return null;
        }
        try {
            if (resultType.isArray() && obj instanceof Collection) {
                Collection collection = (Collection)obj;
                Class<?> type = resultType.getComponentType();
                return (T)collection.toArray((Object[])Array.newInstance(type, collection.size()));
            }
            if (resultType.isArray() && !obj.getClass().isArray()) {
                Object[] array = (Object[])Array.newInstance(resultType.getComponentType(), 1);
                array[0] = this.objectToType(obj, resultType.getComponentType());
                return this.objectToType(array, resultType);
            }
            return this.objectToType(obj, resultType);
        }
        catch (Exception ex) {
            throw new VisalloException("Could not cast object \"" + obj + "\" to type \"" + resultType.getName() + "\"", ex);
        }
    }

    private <T> T objectToType(Object obj, Class<T> resultType) {
        if (obj != null && resultType == obj.getClass()) {
            return (T)obj;
        }
        if (resultType == Integer.class && obj instanceof String) {
            return resultType.cast(Integer.parseInt((String)obj));
        }
        if (resultType == Double.class && obj instanceof String) {
            return resultType.cast(Double.parseDouble((String)obj));
        }
        if (resultType == Float.class && obj instanceof String) {
            return resultType.cast(Float.valueOf(Float.parseFloat((String)obj)));
        }
        if (resultType == JSONArray.class && obj instanceof String) {
            return resultType.cast(new JSONArray((String)obj));
        }
        if (resultType == JSONArray.class && obj instanceof String[]) {
            return resultType.cast(new JSONArray(obj));
        }
        if (resultType == Boolean.class && obj instanceof String) {
            return resultType.cast(Boolean.parseBoolean((String)obj));
        }
        return resultType.cast(obj);
    }

    public <T> T getOptionalParameter(String parameterName, T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue cannot be null");
        Class<?> obj = this.getOptionalParameter(parameterName, (T)defaultValue.getClass());
        if (obj == null) {
            return defaultValue;
        }
        return (T)obj;
    }

    public <T> T getRequiredParameter(String parameterName, Class<T> resultType) {
        Class<T> obj = this.getOptionalParameter(parameterName, (T)resultType);
        if (obj == null) {
            throw new VisalloException("Missing parameter: " + parameterName);
        }
        return (T)obj;
    }
}

