/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import java.util.Collection;
import org.json.JSONObject;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.search.SearchRunner;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiSearch;
import org.visallo.web.clientapi.model.ClientApiSearchListResponse;

public abstract class SearchRepository {
    private final Collection<SearchRunner> searchRunners;

    protected SearchRepository(Configuration configuration) {
        this.searchRunners = InjectHelper.getInjectedServices(SearchRunner.class, configuration);
    }

    public abstract String saveSearch(String var1, String var2, String var3, JSONObject var4, User var5);

    public abstract String saveGlobalSearch(String var1, String var2, String var3, JSONObject var4, User var5);

    public abstract ClientApiSearchListResponse getSavedSearches(User var1);

    public abstract ClientApiSearch getSavedSearch(String var1, User var2);

    public abstract ClientApiSearch getSavedSearchOnWorkspace(String var1, User var2, String var3);

    public abstract void deleteSearch(String var1, User var2);

    public SearchRunner findSearchRunnerByUri(String searchUri) {
        for (SearchRunner searchRunner : this.searchRunners) {
            if (!searchRunner.getUri().equals(searchUri)) continue;
            return searchRunner;
        }
        return null;
    }
}

