/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.termMention;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.util.Date;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.VisibilityJson;

public class TermMentionBuilder {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(TermMentionBuilder.class);
    private static final String TERM_MENTION_VERTEX_ID_PREFIX = "TM_";
    private Vertex outVertex;
    private String propertyKey;
    private String propertyName;
    private long start = -1L;
    private long end = -1L;
    private String title;
    private String conceptIri;
    private VisibilityJson visibilityJson;
    private String process;
    private String resolvedToVertexId;
    private String resolvedEdgeId;
    private String snippet;

    public TermMentionBuilder() {
    }

    public TermMentionBuilder(Vertex existingTermMention, Vertex outVertex) {
        this.outVertex = outVertex;
        this.propertyKey = (String)VisalloProperties.TERM_MENTION_PROPERTY_KEY.getPropertyValue((Element)existingTermMention);
        this.propertyName = (String)VisalloProperties.TERM_MENTION_PROPERTY_NAME.getPropertyValue((Element)existingTermMention);
        this.start = VisalloProperties.TERM_MENTION_START_OFFSET.getPropertyValue((Element)existingTermMention, 0L);
        this.end = VisalloProperties.TERM_MENTION_END_OFFSET.getPropertyValue((Element)existingTermMention, 0L);
        this.title = VisalloProperties.TERM_MENTION_TITLE.getPropertyValue((Element)existingTermMention, "");
        this.snippet = (String)VisalloProperties.TERM_MENTION_SNIPPET.getPropertyValue((Element)existingTermMention);
        this.conceptIri = VisalloProperties.TERM_MENTION_CONCEPT_TYPE.getPropertyValue((Element)existingTermMention, "");
        this.visibilityJson = VisalloProperties.TERM_MENTION_VISIBILITY_JSON.getPropertyValue((Element)existingTermMention, new VisibilityJson());
    }

    public TermMentionBuilder start(long start) {
        this.start = start;
        return this;
    }

    public TermMentionBuilder end(long end) {
        this.end = end;
        return this;
    }

    public TermMentionBuilder propertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
    }

    public TermMentionBuilder propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public TermMentionBuilder visibilityJson(String visibilityJsonString) {
        return this.visibilityJson(TermMentionBuilder.visibilityJsonStringToJson(visibilityJsonString));
    }

    public TermMentionBuilder visibilityJson(VisibilityJson visibilitySource) {
        this.visibilityJson = visibilitySource;
        return this;
    }

    private static VisibilityJson visibilityJsonStringToJson(String visibilityJsonString) {
        if (visibilityJsonString == null) {
            return new VisibilityJson();
        }
        if (visibilityJsonString.length() == 0) {
            return new VisibilityJson();
        }
        return (VisibilityJson)ClientApiConverter.toClientApi((String)visibilityJsonString, VisibilityJson.class);
    }

    public TermMentionBuilder resolvedTo(Vertex resolvedToVertex, Edge resolvedEdge) {
        return this.resolvedTo(resolvedToVertex.getId(), resolvedEdge.getId());
    }

    public TermMentionBuilder resolvedTo(String resolvedToVertexId, String resolvedEdgeId) {
        this.resolvedToVertexId = resolvedToVertexId;
        this.resolvedEdgeId = resolvedEdgeId;
        return this;
    }

    public TermMentionBuilder process(String process) {
        this.process = process;
        return this;
    }

    public TermMentionBuilder outVertex(Vertex outVertex) {
        this.outVertex = outVertex;
        return this;
    }

    public TermMentionBuilder title(String title) {
        this.title = title;
        return this;
    }

    public TermMentionBuilder snippet(String snippet) {
        this.snippet = snippet;
        return this;
    }

    public TermMentionBuilder conceptIri(String conceptIri) {
        this.conceptIri = conceptIri;
        return this;
    }

    public Vertex save(Graph graph, VisibilityTranslator visibilityTranslator, User user, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)this.outVertex, (Object)"outVertex cannot be null");
        Preconditions.checkNotNull((Object)this.propertyKey, (Object)"propertyKey cannot be null");
        Preconditions.checkNotNull((Object)this.title, (Object)"title cannot be null");
        Preconditions.checkArgument((this.title.length() > 0 ? 1 : 0) != 0, (Object)"title cannot be an empty string");
        Preconditions.checkNotNull((Object)this.conceptIri, (Object)"conceptIri cannot be null");
        Preconditions.checkArgument((this.conceptIri.length() > 0 ? 1 : 0) != 0, (Object)"conceptIri cannot be an empty string");
        Preconditions.checkNotNull((Object)this.visibilityJson, (Object)"visibilityJson cannot be null");
        Preconditions.checkNotNull((Object)this.process, (Object)"process cannot be null");
        Preconditions.checkArgument((this.process.length() > 0 ? 1 : 0) != 0, (Object)"process cannot be an empty string");
        Preconditions.checkArgument((this.start >= 0L ? 1 : 0) != 0, (Object)"start must be greater than or equal to 0");
        Preconditions.checkArgument((this.end >= 0L ? 1 : 0) != 0, (Object)"start must be greater than or equal to 0");
        if (this.propertyName == null) {
            LOGGER.warn("Not setting a propertyName when building a term mention is deprecated", new Object[0]);
        }
        Date now = new Date();
        String vertexId = this.createVertexId();
        Visibility defaultVisibility = visibilityTranslator.getDefaultVisibility();
        Visibility visibility = VisalloVisibility.and(visibilityTranslator.toVisibility(this.visibilityJson).getVisibility(), "termMention");
        VertexBuilder vertexBuilder = graph.prepareVertex(vertexId, visibility);
        VisalloProperties.TERM_MENTION_VISIBILITY_JSON.setProperty((ElementMutation<?>)vertexBuilder, this.visibilityJson, visibility);
        VisalloProperties.TERM_MENTION_CONCEPT_TYPE.setProperty((ElementMutation<?>)vertexBuilder, this.conceptIri, visibility);
        VisalloProperties.TERM_MENTION_TITLE.setProperty((ElementMutation<?>)vertexBuilder, this.title, visibility);
        VisalloProperties.TERM_MENTION_START_OFFSET.setProperty((ElementMutation<?>)vertexBuilder, this.start, visibility);
        VisalloProperties.TERM_MENTION_END_OFFSET.setProperty((ElementMutation<?>)vertexBuilder, this.end, visibility);
        VisalloProperties.TERM_MENTION_PROCESS.setProperty((ElementMutation<?>)vertexBuilder, this.process, visibility);
        VisalloProperties.TERM_MENTION_PROPERTY_KEY.setProperty((ElementMutation<?>)vertexBuilder, this.propertyKey, visibility);
        if (this.propertyName != null) {
            VisalloProperties.TERM_MENTION_PROPERTY_NAME.setProperty((ElementMutation<?>)vertexBuilder, this.propertyName, visibility);
        }
        if (this.resolvedEdgeId != null) {
            VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.setProperty((ElementMutation<?>)vertexBuilder, this.resolvedEdgeId, visibility);
        }
        if (this.snippet != null) {
            VisalloProperties.TERM_MENTION_SNIPPET.setProperty((ElementMutation<?>)vertexBuilder, this.snippet, visibility);
        }
        if (this.resolvedToVertexId != null) {
            VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.setProperty((ElementMutation<?>)vertexBuilder, this.resolvedToVertexId, visibility);
            VisalloProperties.TERM_MENTION_FOR_TYPE.setProperty((ElementMutation<?>)vertexBuilder, TermMentionFor.VERTEX, visibility);
        }
        Authorizations termMentionAuthorizations = graph.createAuthorizations(authorizations, new String[]{"termMention"});
        Vertex termMentionVertex = vertexBuilder.save(termMentionAuthorizations);
        String hasTermMentionId = vertexId + "_hasTermMention";
        EdgeBuilder termMentionEdgeBuilder = graph.prepareEdge(hasTermMentionId, this.outVertex, termMentionVertex, "http://visallo.org/termMention#hasTermMention", visibility);
        VisalloProperties.TERM_MENTION_VISIBILITY_JSON.setProperty((ElementMutation<?>)termMentionEdgeBuilder, this.visibilityJson, visibility);
        VisalloProperties.MODIFIED_BY.setProperty((ElementMutation<?>)termMentionEdgeBuilder, user.getUserId(), defaultVisibility);
        VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation<?>)termMentionEdgeBuilder, now, defaultVisibility);
        termMentionEdgeBuilder.save(authorizations);
        if (this.resolvedToVertexId != null) {
            String resolvedToId = vertexId + "_resolvedTo";
            EdgeBuilderByVertexId resolvedToEdgeBuilder = graph.prepareEdge(resolvedToId, termMentionVertex.getId(), this.resolvedToVertexId, "http://visallo.org/termMention#resolvedTo", visibility);
            VisalloProperties.TERM_MENTION_VISIBILITY_JSON.setProperty((ElementMutation<?>)resolvedToEdgeBuilder, this.visibilityJson, visibility);
            VisalloProperties.MODIFIED_BY.setProperty((ElementMutation<?>)resolvedToEdgeBuilder, user.getUserId(), defaultVisibility);
            VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation<?>)resolvedToEdgeBuilder, now, defaultVisibility);
            resolvedToEdgeBuilder.save(authorizations);
        }
        return termMentionVertex;
    }

    private String createVertexId() {
        String id = TERM_MENTION_VERTEX_ID_PREFIX + this.outVertex.getId();
        if (this.visibilityJson == null) {
            LOGGER.warn("Visibility Json should not be null", new Object[0]);
        } else if (this.visibilityJson.getSource() != null && this.visibilityJson.getSource().length() > 0) {
            String hash = Hashing.sha1().hashString((CharSequence)this.visibilityJson.getSource(), Charsets.UTF_8).toString();
            id = id + "-" + hash;
        }
        if (this.propertyName != null) {
            id = id + "-" + this.propertyName;
        }
        return id + "-" + this.propertyKey + "-" + this.start + "-" + this.end + "-" + this.process;
    }
}

