/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.util.IterableUtils;
import org.visallo.core.formula.FormulaEvaluator;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceEntity;
import org.visallo.core.trace.Traced;
import org.visallo.core.user.User;
import org.visallo.core.util.JSONUtil;
import org.visallo.core.util.JsonSerializer;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.web.clientapi.model.ClientApiWorkspaceDiff;
import org.visallo.web.clientapi.model.SandboxStatus;

public class WorkspaceDiffHelper {
    private final Graph graph;
    private final UserRepository userRepository;
    private final AuthorizationRepository authorizationRepository;
    private final FormulaEvaluator formulaEvaluator;

    @Inject
    public WorkspaceDiffHelper(Graph graph, UserRepository userRepository, AuthorizationRepository authorizationRepository, FormulaEvaluator formulaEvaluator) {
        this.graph = graph;
        this.userRepository = userRepository;
        this.authorizationRepository = authorizationRepository;
        this.formulaEvaluator = formulaEvaluator;
    }

    @Traced
    public ClientApiWorkspaceDiff diff(Workspace workspace, Iterable<WorkspaceEntity> workspaceEntities, Iterable<Edge> workspaceEdges, FormulaEvaluator.UserContext userContext, User user) {
        List<ClientApiWorkspaceDiff.Item> entityDiffs;
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(user, "workspace", workspace.getWorkspaceId());
        ClientApiWorkspaceDiff result = new ClientApiWorkspaceDiff();
        for (WorkspaceEntity workspaceEntity : workspaceEntities) {
            entityDiffs = this.diffWorkspaceEntity(workspace, workspaceEntity, userContext, authorizations);
            if (entityDiffs == null) continue;
            result.addAll(entityDiffs);
        }
        for (Edge workspaceEdge : workspaceEdges) {
            entityDiffs = this.diffEdge(workspace, workspaceEdge, authorizations);
            if (entityDiffs == null) continue;
            result.addAll(entityDiffs);
        }
        return result;
    }

    @Traced
    protected List<ClientApiWorkspaceDiff.Item> diffEdge(Workspace workspace, Edge edge, Authorizations hiddenAuthorizations) {
        ArrayList<ClientApiWorkspaceDiff.Item> result = new ArrayList<ClientApiWorkspaceDiff.Item>();
        SandboxStatus sandboxStatus = SandboxStatusUtil.getSandboxStatus((Element)edge, workspace.getWorkspaceId());
        boolean isPrivateChange = sandboxStatus != SandboxStatus.PUBLIC;
        boolean isPublicDelete = WorkspaceDiffHelper.isPublicDelete(edge, hiddenAuthorizations);
        if (isPrivateChange || isPublicDelete) {
            result.add((ClientApiWorkspaceDiff.Item)this.createWorkspaceDiffEdgeItem(edge, sandboxStatus, isPublicDelete));
        }
        if (!isPublicDelete) {
            this.diffProperties(workspace, (Element)edge, result, hiddenAuthorizations);
        }
        return result;
    }

    public static boolean isPublicDelete(Edge edge, Authorizations authorizations) {
        return edge.isHidden(authorizations);
    }

    public static boolean isPublicDelete(Vertex vertex, Authorizations authorizations) {
        return vertex.isHidden(authorizations);
    }

    public static boolean isPublicDelete(Property property, Authorizations authorizations) {
        return property.isHidden(authorizations);
    }

    private ClientApiWorkspaceDiff.EdgeItem createWorkspaceDiffEdgeItem(Edge edge, SandboxStatus sandboxStatus, boolean deleted) {
        Property visibilityJsonProperty = VisalloProperties.VISIBILITY_JSON.getProperty((Element)edge);
        JsonNode visibilityJson = visibilityJsonProperty == null ? null : JSONUtil.toJsonNode(JsonSerializer.toJsonProperty(visibilityJsonProperty));
        return new ClientApiWorkspaceDiff.EdgeItem(edge.getId(), edge.getLabel(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), visibilityJson, sandboxStatus, deleted);
    }

    @Traced
    public List<ClientApiWorkspaceDiff.Item> diffWorkspaceEntity(Workspace workspace, WorkspaceEntity workspaceEntity, FormulaEvaluator.UserContext userContext, Authorizations authorizations) {
        ArrayList<ClientApiWorkspaceDiff.Item> result = new ArrayList<ClientApiWorkspaceDiff.Item>();
        Vertex entityVertex = this.graph.getVertex(workspaceEntity.getEntityVertexId(), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        if (entityVertex == null) {
            return null;
        }
        SandboxStatus sandboxStatus = SandboxStatusUtil.getSandboxStatus((Element)entityVertex, workspace.getWorkspaceId());
        boolean isPrivateChange = sandboxStatus != SandboxStatus.PUBLIC;
        boolean isPublicDelete = WorkspaceDiffHelper.isPublicDelete(entityVertex, authorizations);
        if (isPrivateChange || isPublicDelete) {
            result.add((ClientApiWorkspaceDiff.Item)this.createWorkspaceDiffVertexItem(entityVertex, sandboxStatus, userContext, isPublicDelete));
        }
        if (!isPublicDelete) {
            this.diffProperties(workspace, (Element)entityVertex, result, authorizations);
        }
        return result;
    }

    private ClientApiWorkspaceDiff.VertexItem createWorkspaceDiffVertexItem(Vertex vertex, SandboxStatus sandboxStatus, FormulaEvaluator.UserContext userContext, boolean deleted) {
        String vertexId = vertex.getId();
        String title = this.formulaEvaluator.evaluateTitleFormula((Element)vertex, userContext, null);
        String conceptType = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)vertex);
        Property visibilityJsonProperty = VisalloProperties.VISIBILITY_JSON.getProperty((Element)vertex);
        JsonNode visibilityJson = visibilityJsonProperty == null ? null : JSONUtil.toJsonNode(JsonSerializer.toJsonProperty(visibilityJsonProperty));
        return new ClientApiWorkspaceDiff.VertexItem(vertexId, title, conceptType, visibilityJson, sandboxStatus, deleted);
    }

    @Traced
    protected void diffProperties(Workspace workspace, Element element, List<ClientApiWorkspaceDiff.Item> result, Authorizations hiddenAuthorizations) {
        List properties = IterableUtils.toList((Iterable)element.getProperties());
        SandboxStatus[] propertyStatuses = SandboxStatusUtil.getPropertySandboxStatuses(properties, workspace.getWorkspaceId());
        for (int i = 0; i < properties.size(); ++i) {
            Property property = (Property)properties.get(i);
            boolean isPrivateChange = propertyStatuses[i] != SandboxStatus.PUBLIC;
            boolean isPublicDelete = WorkspaceDiffHelper.isPublicDelete(property, hiddenAuthorizations);
            if (!isPrivateChange && !isPublicDelete) continue;
            Property existingProperty = null;
            if (isPublicDelete && WorkspaceDiffHelper.isPublicPropertyEdited(properties, propertyStatuses, property)) continue;
            if (isPrivateChange) {
                existingProperty = this.findExistingProperty(properties, propertyStatuses, property);
            }
            result.add((ClientApiWorkspaceDiff.Item)this.createWorkspaceDiffPropertyItem(element, property, existingProperty, propertyStatuses[i], isPublicDelete));
        }
    }

    private ClientApiWorkspaceDiff.PropertyItem createWorkspaceDiffPropertyItem(Element element, Property workspaceProperty, Property existingProperty, SandboxStatus sandboxStatus, boolean deleted) {
        JsonNode oldData = null;
        if (existingProperty != null) {
            oldData = JSONUtil.toJsonNode(JsonSerializer.toJsonProperty(existingProperty));
        }
        JsonNode newData = JSONUtil.toJsonNode(JsonSerializer.toJsonProperty(workspaceProperty));
        return new ClientApiWorkspaceDiff.PropertyItem(ElementType.getTypeFromElement((Element)element).name().toLowerCase(), element.getId(), (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue(element), workspaceProperty.getName(), workspaceProperty.getKey(), oldData, newData, sandboxStatus, deleted, workspaceProperty.getVisibility().getVisibilityString());
    }

    private Property findExistingProperty(List<Property> properties, SandboxStatus[] propertyStatuses, Property workspaceProperty) {
        for (int i = 0; i < properties.size(); ++i) {
            Property property = properties.get(i);
            if (!property.getName().equals(workspaceProperty.getName()) || !property.getKey().equals(workspaceProperty.getKey()) || propertyStatuses[i] != SandboxStatus.PUBLIC) continue;
            return property;
        }
        return null;
    }

    public static boolean isPublicPropertyEdited(List<Property> properties, SandboxStatus[] propertyStatuses, Property workspaceProperty) {
        for (int i = 0; i < properties.size(); ++i) {
            Property property = properties.get(i);
            if (!property.getName().equals(workspaceProperty.getName()) || !property.getKey().equals(workspaceProperty.getKey()) || propertyStatuses[i] != SandboxStatus.PUBLIC_CHANGED) continue;
            return true;
        }
        return false;
    }
}

