/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace.product;

import java.io.Serializable;
import java.util.Map;
import org.json.JSONObject;
import org.visallo.core.util.JSONUtil;

public abstract class Product
implements Serializable {
    static long serialVersionUID = 1L;
    private final String id;
    private final String workspaceId;
    private final String title;
    private final String kind;
    private final Map<String, Object> data;
    private final Map<String, Object> extendedData;
    private final String previewImageMD5;

    public Product(String id, String workspaceId, String kind, String title, JSONObject data, JSONObject extendedData, String md5) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.kind = kind;
        this.data = data == null ? null : JSONUtil.toMap(data);
        this.extendedData = extendedData == null ? null : JSONUtil.toMap(extendedData);
        this.title = title;
        this.previewImageMD5 = md5;
    }

    public String getId() {
        return this.id;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getKind() {
        return this.kind;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Map<String, Object> getExtendedData() {
        return this.extendedData;
    }

    public String getPreviewImageMD5() {
        return this.previewImageMD5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return this.id.equals(product.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Product{title='" + this.getTitle() + '\'' + ", id='" + this.id + '\'' + ", workspaceId='" + this.workspaceId + '\'' + '}';
    }
}

