/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ping;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.visallo.core.model.properties.types.DateSingleValueVisalloProperty;
import org.visallo.core.model.properties.types.LongSingleValueVisalloProperty;
import org.visallo.core.model.properties.types.StringSingleValueVisalloProperty;

public class PingOntology {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String HOST_NAME = PingOntology.getHostName();
    public static final String BASE_IRI = "http://visallo.org/ping";
    public static final String IRI_CONCEPT_PING = "http://visallo.org/ping#ping";
    public static final DateSingleValueVisalloProperty CREATE_DATE = new DateSingleValueVisalloProperty("http://visallo.org/ping#createDate");
    public static final StringSingleValueVisalloProperty CREATE_REMOTE_ADDR = new StringSingleValueVisalloProperty("http://visallo.org/ping#createRemoteAddr");
    public static final LongSingleValueVisalloProperty SEARCH_TIME_MS = new LongSingleValueVisalloProperty("http://visallo.org/ping#searchTimeMs");
    public static final LongSingleValueVisalloProperty RETRIEVAL_TIME_MS = new LongSingleValueVisalloProperty("http://visallo.org/ping#retrievalTimeMs");
    public static final DateSingleValueVisalloProperty GRAPH_PROPERTY_WORKER_DATE = new DateSingleValueVisalloProperty("http://visallo.org/ping#gpwDate");
    public static final StringSingleValueVisalloProperty GRAPH_PROPERTY_WORKER_HOSTNAME = new StringSingleValueVisalloProperty("http://visallo.org/ping#gpwHostname");
    public static final StringSingleValueVisalloProperty GRAPH_PROPERTY_WORKER_HOST_ADDRESS = new StringSingleValueVisalloProperty("http://visallo.org/ping#gpwHostAddress");
    public static final LongSingleValueVisalloProperty GRAPH_PROPERTY_WORKER_WAIT_TIME_MS = new LongSingleValueVisalloProperty("http://visallo.org/ping#gpwWaitTimeMs");
    public static final DateSingleValueVisalloProperty LONG_RUNNING_PROCESS_DATE = new DateSingleValueVisalloProperty("http://visallo.org/ping#lrpDate");
    public static final StringSingleValueVisalloProperty LONG_RUNNING_PROCESS_HOSTNAME = new StringSingleValueVisalloProperty("http://visallo.org/ping#lrpHostname");
    public static final StringSingleValueVisalloProperty LONG_RUNNING_PROCESS_HOST_ADDRESS = new StringSingleValueVisalloProperty("http://visallo.org/ping#lrpHostAddress");
    public static final LongSingleValueVisalloProperty LONG_RUNNING_PROCESS_WAIT_TIME_MS = new LongSingleValueVisalloProperty("http://visallo.org/ping#lrpWaitTimeMs");

    public static String getVertexId(Date date) {
        return "PING_" + new SimpleDateFormat(DATE_TIME_FORMAT).format(date) + "_" + HOST_NAME;
    }

    private static String getHostName() {
        String host = System.getenv("COMPUTERNAME");
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        host = System.getenv("HOSTNAME");
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "Unknown";
        }
    }
}

