/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.security;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.HasOntologyProperties;
import org.visallo.core.model.ontology.OntologyElement;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeSearchResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeWithVertexData;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiElementAcl;
import org.visallo.web.clientapi.model.ClientApiElementFindRelatedResponse;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiProperty;
import org.visallo.web.clientapi.model.ClientApiPropertyAcl;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.ClientApiVertexEdges;
import org.visallo.web.clientapi.model.ClientApiVertexMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiWorkspaceVertices;

public abstract class ACLProvider {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ACLProvider.class);
    protected final Graph graph;
    protected final UserRepository userRepository;
    protected final OntologyRepository ontologyRepository;
    private final PrivilegeRepository privilegeRepository;

    @Inject
    protected ACLProvider(Graph graph, UserRepository userRepository, OntologyRepository ontologyRepository, PrivilegeRepository privilegeRepository) {
        this.graph = graph;
        this.userRepository = userRepository;
        this.ontologyRepository = ontologyRepository;
        this.privilegeRepository = privilegeRepository;
    }

    public boolean canDeleteElement(Element element, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(element);
        return this.canDeleteElement(element, ontologyElement, user);
    }

    protected abstract boolean canDeleteElement(Element var1, OntologyElement var2, User var3);

    public boolean canDeleteElement(ClientApiElement clientApiElement, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.canDeleteElement(clientApiElement, ontologyElement, user);
    }

    protected abstract boolean canDeleteElement(ClientApiElement var1, OntologyElement var2, User var3);

    public boolean canDeleteProperty(Element element, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(element);
        return this.canDeleteProperty(element, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canDeleteProperty(Element var1, OntologyElement var2, String var3, String var4, User var5);

    public boolean canDeleteProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.canDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canDeleteProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, User var5);

    public boolean canUpdateElement(Element element, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(element);
        return this.canUpdateElement(element, ontologyElement, user);
    }

    protected abstract boolean canUpdateElement(Element var1, OntologyElement var2, User var3);

    public boolean canUpdateElement(ClientApiElement clientApiElement, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.canUpdateElement(clientApiElement, ontologyElement, user);
    }

    protected abstract boolean canUpdateElement(ClientApiElement var1, OntologyElement var2, User var3);

    public boolean canUpdateProperty(Element element, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(element);
        return this.canUpdateProperty(element, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canUpdateProperty(Element var1, OntologyElement var2, String var3, String var4, User var5);

    public boolean canUpdateProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.canUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canUpdateProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, User var5);

    public boolean canAddProperty(Element element, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(element);
        return this.canAddProperty(element, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canAddProperty(Element var1, OntologyElement var2, String var3, String var4, User var5);

    public boolean canAddProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.canAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
    }

    protected abstract boolean canAddProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, User var5);

    public final void checkCanAddOrUpdateProperty(Element element, String propertyKey, String propertyName, User user) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(element);
        this.checkCanAddOrUpdateProperty(element, ontologyElement, propertyKey, propertyName, privileges, user);
    }

    private void checkCanAddOrUpdateProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) throws VisalloAccessDeniedException {
        boolean canAddOrUpdate;
        boolean isUpdate = element.getProperty(propertyKey, propertyName) != null;
        boolean bl = canAddOrUpdate = isUpdate ? this.internalCanUpdateProperty(element, ontologyElement, propertyKey, propertyName, privileges, user) : this.internalCanAddProperty(element, ontologyElement, propertyKey, propertyName, privileges, user);
        if (!canAddOrUpdate) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be added or updated due to ACL restriction", user, element.getId());
        }
    }

    public final void checkCanAddOrUpdateProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        this.checkCanAddOrUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
    }

    public final void checkCanAddOrUpdateProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, User user) throws VisalloAccessDeniedException {
        boolean canAddOrUpdate;
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        boolean isUpdate = clientApiElement.getProperty(propertyKey, propertyName) != null;
        boolean bl = canAddOrUpdate = isUpdate ? this.internalCanUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, privileges, user) : this.internalCanAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, privileges, user);
        if (!canAddOrUpdate) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be added or updated due to ACL restriction", user, clientApiElement.getId());
        }
    }

    public final void checkCanDeleteProperty(Element element, String propertyKey, String propertyName, User user) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(element);
        this.checkCanDeleteProperty(element, ontologyElement, propertyKey, propertyName, privileges, user);
    }

    private void checkCanDeleteProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) throws VisalloAccessDeniedException {
        boolean canDelete = this.internalCanDeleteProperty(element, ontologyElement, propertyKey, propertyName, privileges, user);
        if (!canDelete) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be deleted due to ACL restriction", user, element.getId());
        }
    }

    public final void checkCanDeleteProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        this.checkCanDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, privileges, user);
    }

    private void checkCanDeleteProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) throws VisalloAccessDeniedException {
        boolean canDelete = this.internalCanDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, privileges, user);
        if (!canDelete) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be deleted due to ACL restriction", user, clientApiElement.getId());
        }
    }

    public final ClientApiElementAcl elementACL(ClientApiElement clientApiElement, User user) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        return this.elementACL(clientApiElement, ontologyElement, privileges, user);
    }

    private ClientApiElementAcl elementACL(ClientApiElement clientApiElement, OntologyElement ontologyElement, Set<String> privileges, User user) {
        Preconditions.checkNotNull((Object)clientApiElement, (Object)"clientApiElement is required");
        ClientApiElementAcl elementAcl = new ClientApiElementAcl();
        elementAcl.setAddable(true);
        elementAcl.setUpdateable(this.internalCanUpdateElement(clientApiElement, ontologyElement, privileges, user));
        elementAcl.setDeleteable(this.internalCanDeleteElement(clientApiElement, ontologyElement, privileges, user));
        List propertyAcls = elementAcl.getPropertyAcls();
        if (clientApiElement instanceof ClientApiVertex) {
            String iri = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue(clientApiElement);
            while (iri != null) {
                Concept concept = this.ontologyRepository.getConceptByIRI(iri);
                if (concept == null) {
                    LOGGER.warn("Could not find concept: %s", iri);
                    break;
                }
                this.populatePropertyAcls(concept, clientApiElement, ontologyElement, privileges, user, propertyAcls);
                iri = concept.getParentConceptIRI();
            }
        } else if (clientApiElement instanceof ClientApiEdge) {
            String iri = ((ClientApiEdge)clientApiElement).getLabel();
            while (iri != null) {
                Relationship relationship = this.ontologyRepository.getRelationshipByIRI(iri);
                if (relationship == null) {
                    LOGGER.warn("Could not find relationship: %s", iri);
                    break;
                }
                this.populatePropertyAcls(relationship, clientApiElement, ontologyElement, privileges, user, propertyAcls);
                iri = relationship.getParentIRI();
            }
        } else {
            throw new VisalloException("unsupported ClientApiElement class " + clientApiElement.getClass().getName());
        }
        return elementAcl;
    }

    public final ClientApiObject appendACL(ClientApiObject clientApiObject, User user) {
        if (user == null) {
            return clientApiObject;
        }
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        return this.appendACL(clientApiObject, privileges, user);
    }

    private ClientApiObject appendACL(ClientApiObject clientApiObject, Set<String> privileges, User user) {
        if (clientApiObject instanceof ClientApiElement) {
            this.appendACL((ClientApiElement)clientApiObject, privileges, user);
        } else if (clientApiObject instanceof ClientApiWorkspaceVertices) {
            this.appendACL(((ClientApiWorkspaceVertices)clientApiObject).getVertices(), user);
        } else if (clientApiObject instanceof ClientApiVertexMultipleResponse) {
            this.appendACL(((ClientApiVertexMultipleResponse)clientApiObject).getVertices(), user);
        } else if (clientApiObject instanceof ClientApiEdgeMultipleResponse) {
            this.appendACL(((ClientApiEdgeMultipleResponse)clientApiObject).getEdges(), user);
        } else if (clientApiObject instanceof ClientApiElementSearchResponse) {
            this.appendACL(((ClientApiElementSearchResponse)clientApiObject).getElements(), user);
        } else if (clientApiObject instanceof ClientApiEdgeSearchResponse) {
            this.appendACL(((ClientApiEdgeSearchResponse)clientApiObject).getResults(), user);
        } else if (clientApiObject instanceof ClientApiVertexEdges) {
            ClientApiVertexEdges vertexEdges = (ClientApiVertexEdges)clientApiObject;
            this.appendACL(vertexEdges, privileges, user);
        } else if (clientApiObject instanceof ClientApiElementFindRelatedResponse) {
            this.appendACL(((ClientApiElementFindRelatedResponse)clientApiObject).getElements(), user);
        }
        return clientApiObject;
    }

    protected final boolean isComment(String propertyName) {
        return VisalloProperties.COMMENT.isSameName(propertyName);
    }

    protected final boolean isAuthor(Element element, String propertyKey, String propertyName, User user) {
        if (element == null) {
            return false;
        }
        Property property = element.getProperty(propertyKey, propertyName);
        if (property != null) {
            String authorUserId = (String)VisalloProperties.MODIFIED_BY_METADATA.getMetadataValue(property.getMetadata());
            return user.getUserId().equals(authorUserId);
        }
        return false;
    }

    protected final boolean isAuthor(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user) {
        if (clientApiElement == null) {
            return false;
        }
        ClientApiProperty property = clientApiElement.getProperty(propertyKey, propertyName);
        if (property != null) {
            String authorUserId = (String)VisalloProperties.MODIFIED_BY_METADATA.getMetadataValue(property.getMetadata());
            return user.getUserId().equals(authorUserId);
        }
        return false;
    }

    private void appendACL(Collection<? extends ClientApiObject> clientApiObject, User user) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        for (ClientApiObject clientApiObject2 : clientApiObject) {
            this.appendACL(clientApiObject2, privileges, user);
        }
    }

    private void appendACL(ClientApiElement clientApiElement, Set<String> privileges, User user) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement);
        this.appendACL(clientApiElement, ontologyElement, privileges, user);
    }

    private void appendACL(ClientApiElement clientApiElement, OntologyElement ontologyElement, Set<String> privileges, User user) {
        for (ClientApiProperty apiProperty : clientApiElement.getProperties()) {
            String key = apiProperty.getKey();
            String name = apiProperty.getName();
            apiProperty.setUpdateable(this.internalCanUpdateProperty(clientApiElement, ontologyElement, key, name, privileges, user));
            apiProperty.setDeleteable(this.internalCanDeleteProperty(clientApiElement, ontologyElement, key, name, privileges, user));
            apiProperty.setAddable(this.internalCanAddProperty(clientApiElement, ontologyElement, key, name, privileges, user));
        }
        clientApiElement.setUpdateable(Boolean.valueOf(this.internalCanUpdateElement(clientApiElement, ontologyElement, privileges, user)));
        clientApiElement.setDeleteable(Boolean.valueOf(this.internalCanDeleteElement(clientApiElement, ontologyElement, privileges, user)));
        clientApiElement.setAcl(this.elementACL(clientApiElement, ontologyElement, privileges, user));
        if (clientApiElement instanceof ClientApiEdgeWithVertexData) {
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)clientApiElement).getSource(), privileges, user);
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)clientApiElement).getTarget(), privileges, user);
        }
    }

    private void appendACL(ClientApiVertexEdges edges, Set<String> privileges, User user) {
        for (ClientApiVertexEdges.Edge vertexEdge : edges.getRelationships()) {
            this.appendACL((ClientApiElement)vertexEdge.getRelationship(), privileges, user);
            this.appendACL((ClientApiElement)vertexEdge.getVertex(), privileges, user);
        }
    }

    private void populatePropertyAcls(HasOntologyProperties hasOntologyProperties, ClientApiElement clientApiElement, OntologyElement ontologyElement, Set<String> privileges, User user, List<ClientApiPropertyAcl> propertyAcls) {
        Collection<OntologyProperty> ontologyProperties = hasOntologyProperties.getProperties();
        HashSet<String> addedPropertyNames = new HashSet<String>();
        for (OntologyProperty ontologyProperty2 : ontologyProperties) {
            String propertyName = ontologyProperty2.getTitle();
            for (ClientApiProperty property : clientApiElement.getProperties(propertyName)) {
                ClientApiPropertyAcl defaultAcl;
                ClientApiPropertyAcl acl2 = this.newClientApiPropertyAcl(clientApiElement, ontologyElement, property.getKey(), propertyName, privileges, user);
                if (!acl2.equals((Object)(defaultAcl = this.newClientApiPropertyAcl(null, ontologyElement, property.getKey(), propertyName, privileges, user)))) {
                    propertyAcls.add(acl2);
                }
                addedPropertyNames.add(propertyName);
            }
        }
        propertyAcls.addAll(ontologyProperties.stream().filter(ontologyProperty -> !addedPropertyNames.contains(ontologyProperty.getTitle())).map(ontologyProperty -> {
            ClientApiPropertyAcl defaultAcl;
            String propertyName = ontologyProperty.getTitle();
            ClientApiPropertyAcl acl = this.newClientApiPropertyAcl(clientApiElement, ontologyElement, null, propertyName, privileges, user);
            return acl.equals((Object)(defaultAcl = this.newClientApiPropertyAcl(null, ontologyElement, null, propertyName, privileges, user))) ? null : acl;
        }).filter(acl -> acl != null).collect(Collectors.toList()));
    }

    private ClientApiPropertyAcl newClientApiPropertyAcl(ClientApiElement clientApiElement, OntologyElement ontologyElement, String key, String name, Set<String> privileges, User user) {
        ClientApiPropertyAcl propertyAcl = new ClientApiPropertyAcl();
        propertyAcl.setKey(key);
        propertyAcl.setName(name);
        propertyAcl.setAddable(this.internalCanAddProperty(clientApiElement, ontologyElement, key, name, privileges, user));
        propertyAcl.setUpdateable(this.internalCanUpdateProperty(clientApiElement, ontologyElement, key, name, privileges, user));
        propertyAcl.setDeleteable(this.internalCanDeleteProperty(clientApiElement, ontologyElement, key, name, privileges, user));
        return propertyAcl;
    }

    private boolean internalCanDeleteElement(ClientApiElement clientApiElement, OntologyElement ontologyElement, Set<String> privileges, User user) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") && this.canDeleteElement(clientApiElement, ontologyElement, user);
    }

    private boolean internalCanUpdateElement(ClientApiElement clientApiElement, OntologyElement ontologyElement, Set<String> privileges, User user) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") && this.canUpdateElement(clientApiElement, ontologyElement, user);
    }

    private boolean internalCanDeleteProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canDelete;
        boolean bl = canDelete = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canDeleteProperty(element, ontologyElement, propertyKey, propertyName, user);
        if (canDelete && this.isComment(propertyName)) {
            canDelete = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_DELETE_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user);
        }
        return canDelete;
    }

    private boolean internalCanDeleteProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canDelete;
        boolean bl = canDelete = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
        if (canDelete && this.isComment(propertyName)) {
            canDelete = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_DELETE_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(clientApiElement, propertyKey, propertyName, user);
        }
        return canDelete;
    }

    private boolean internalCanUpdateProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canUpdate;
        boolean bl = canUpdate = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canUpdateProperty(element, ontologyElement, propertyKey, propertyName, user);
        if (canUpdate && this.isComment(propertyName)) {
            canUpdate = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_EDIT_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user);
        }
        return canUpdate;
    }

    private boolean internalCanUpdateProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canUpdate;
        boolean bl = canUpdate = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
        if (canUpdate && this.isComment(propertyName)) {
            canUpdate = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_EDIT_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(clientApiElement, propertyKey, propertyName, user);
        }
        return canUpdate;
    }

    private boolean internalCanAddProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canAdd;
        boolean bl = canAdd = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canAddProperty(element, ontologyElement, propertyKey, propertyName, user);
        if (canAdd && this.isComment(propertyName)) {
            canAdd = PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
        }
        return canAdd;
    }

    private boolean internalCanAddProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Set<String> privileges, User user) {
        boolean canAdd;
        boolean bl = canAdd = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, user);
        if (canAdd && this.isComment(propertyName)) {
            canAdd = PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
        }
        return canAdd;
    }

    private boolean hasEditOrCommentPrivilege(Set<String> privileges, String propertyName) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") || this.isComment(propertyName) && PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
    }

    protected OntologyElement getOntologyElement(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Edge) {
            return this.getOntologyRelationshipFromElement((Edge)element);
        }
        if (element instanceof Vertex) {
            return this.getOntologyConceptFromElement((Vertex)element);
        }
        throw new VisalloException("Unexpected " + Element.class.getName() + " found " + element.getClass().getName());
    }

    protected OntologyElement getOntologyElement(ClientApiElement clientApiElement) {
        if (clientApiElement == null) {
            return null;
        }
        if (clientApiElement instanceof ClientApiEdge) {
            return this.getOntologyRelationshipFromElement((ClientApiEdge)clientApiElement);
        }
        if (clientApiElement instanceof ClientApiVertex) {
            return this.getOntologyConceptFromElement((ClientApiVertex)clientApiElement);
        }
        throw new VisalloException("Unexpected " + ClientApiVertex.class.getName() + " found " + clientApiElement.getClass().getName());
    }

    private Relationship getOntologyRelationshipFromElement(Edge e) {
        String label = e.getLabel();
        return this.getOntologyRelationshipFromElement(label);
    }

    private Relationship getOntologyRelationshipFromElement(ClientApiEdge e) {
        String label = e.getLabel();
        return this.getOntologyRelationshipFromElement(label);
    }

    private Relationship getOntologyRelationshipFromElement(String edgeLabel) {
        Preconditions.checkNotNull((Object)edgeLabel, (Object)"Edge label cannot be null");
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI(edgeLabel);
        Preconditions.checkNotNull((Object)relationship, (Object)(edgeLabel + " does not exist in ontology"));
        return relationship;
    }

    private Concept getOntologyConceptFromElement(Vertex vertex) {
        String iri = VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)vertex, "http://www.w3.org/2002/07/owl#Thing");
        return this.getOntologyConcept(iri);
    }

    private Concept getOntologyConceptFromElement(ClientApiVertex vertex) {
        String iri = VisalloProperties.CONCEPT_TYPE.getPropertyValue((ClientApiElement)vertex, "http://www.w3.org/2002/07/owl#Thing");
        return this.getOntologyConcept(iri);
    }

    private Concept getOntologyConcept(String conceptType) {
        if (conceptType == null) {
            return null;
        }
        return this.ontologyRepository.getConceptByIRI(conceptType);
    }
}

