/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertexium.Visibility;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.web.clientapi.model.VisibilityJson;

public class DirectVisibilityTranslator
extends VisibilityTranslator {
    @Override
    public void init(Map configuration) {
    }

    @Override
    public VisalloVisibility toVisibility(VisibilityJson visibilityJson) {
        return new VisalloVisibility(this.toVisibilityNoSuperUser(visibilityJson));
    }

    @Override
    public VisalloVisibility toVisibility(String visibilitySource) {
        return this.toVisibility(this.visibilitySourceToVisibilityJson(visibilitySource));
    }

    protected VisibilityJson visibilitySourceToVisibilityJson(String visibilitySource) {
        return new VisibilityJson(visibilitySource);
    }

    @Override
    public Visibility toVisibilityNoSuperUser(VisibilityJson visibilityJson) {
        StringBuilder visibilityString = new StringBuilder();
        ArrayList<String> required = new ArrayList<String>();
        String source = visibilityJson.getSource();
        this.addSourceToRequiredVisibilities(required, source);
        Set workspaces = visibilityJson.getWorkspaces();
        if (workspaces != null) {
            required.addAll(workspaces);
        }
        for (String v : required) {
            if (visibilityString.length() > 0) {
                visibilityString.append("&");
            }
            visibilityString.append("(").append(v).append(")");
        }
        return new Visibility(visibilityString.toString());
    }

    protected void addSourceToRequiredVisibilities(List<String> required, String source) {
        if (source != null && source.trim().length() > 0) {
            required.add(source.trim());
        }
    }

    @Override
    public Visibility getDefaultVisibility() {
        return new Visibility("");
    }
}

