/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.ClassUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ServiceLoaderUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ServiceLoaderUtil.class);
    private static final String PREFIX = "META-INF/services/";
    public static final String CONFIG_DISABLE_PREFIX = "disable.";

    public static <T> Iterable<T> load(Class<T> clazz, Configuration configuration) {
        Iterable<Class<T>> classes = ServiceLoaderUtil.loadClasses(clazz, configuration);
        return Iterables.transform(classes, (Function)new Function<Class<? extends T>, T>(){

            @Nullable
            public T apply(Class<? extends T> serviceClass) {
                try {
                    return InjectHelper.getInstance(serviceClass);
                }
                catch (Exception ex) {
                    String errorMessage = String.format("Failed to load %s", serviceClass.getName());
                    LOGGER.error("%s", errorMessage, ex);
                    throw new VisalloException(errorMessage, ex);
                }
            }
        });
    }

    public static <T> Iterable<T> loadWithoutInjecting(Class<T> clazz, Configuration configuration) {
        Iterable<Class<T>> classes = ServiceLoaderUtil.loadClasses(clazz, configuration);
        return Iterables.transform(classes, (Function)new Function<Class<? extends T>, T>(){

            @Nullable
            public T apply(Class<? extends T> serviceClass) {
                try {
                    Constructor constructor = serviceClass.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    String errorMessage = String.format("Failed to load %s", serviceClass.getName());
                    LOGGER.error("%s", errorMessage, ex);
                    throw new VisalloException(errorMessage, ex);
                }
            }
        });
    }

    public static <T> Iterable<Class<? extends T>> loadClasses(Class<T> clazz, Configuration configuration) {
        HashSet<Class<T>> services = new HashSet<Class<T>>();
        String fullName = PREFIX + clazz.getName();
        LOGGER.debug("loading services for class %s", fullName);
        try {
            Enumeration<URL> serviceFiles = Thread.currentThread().getContextClassLoader().getResources(fullName);
            if (!serviceFiles.hasMoreElements()) {
                LOGGER.debug("Could not find any services for %s", fullName);
            } else {
                HashSet<URL> serviceFilesSet = new HashSet<URL>();
                while (serviceFiles.hasMoreElements()) {
                    URL serviceFile = serviceFiles.nextElement();
                    serviceFilesSet.add(serviceFile);
                }
                HashMap<String, URL> loadedClassNames = new HashMap<String, URL>();
                for (URL serviceFile : serviceFilesSet) {
                    List<String> fileClassNames = ServiceLoaderUtil.loadFile(serviceFile);
                    for (String className : fileClassNames) {
                        if (configuration.getBoolean(CONFIG_DISABLE_PREFIX + className, false)) {
                            LOGGER.info("ignoring class %s because it is disabled in configuration", className);
                            continue;
                        }
                        if (loadedClassNames.containsKey(className)) {
                            LOGGER.warn("ignoring class '%s' because it is already loaded from '%s'", className, loadedClassNames.get(className));
                            continue;
                        }
                        services.add(ServiceLoaderUtil.loadClass(serviceFile, className));
                        loadedClassNames.put(className, serviceFile);
                    }
                }
            }
            return services;
        }
        catch (IOException e) {
            throw new VisalloException("Could not load services for class: " + clazz.getName(), e);
        }
    }

    private static List<String> loadFile(URL serviceFile) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        LOGGER.debug("loadFile(%s)", serviceFile);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(serviceFile.openStream()));){
            String className;
            while ((className = reader.readLine()) != null) {
                if ((className = className.trim()).length() == 0) continue;
                results.add(className);
            }
        }
        return results;
    }

    private static <T> Class<? extends T> loadClass(URL config, String className) {
        try {
            LOGGER.info("Loading %s from %s", className, config.toString());
            return ClassUtil.forName(className);
        }
        catch (Throwable t) {
            String errorMessage = String.format("Failed to load %s from %s", className, config.toString());
            LOGGER.error("%s", errorMessage, t);
            throw new VisalloException(errorMessage, t);
        }
    }
}

