/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.visallo.core.config.ConfigurationLoader;
import org.visallo.core.util.ProcessUtil;
import org.visallo.core.util.VisalloLogger;

public class VisalloLoggerFactory {
    private static final Map<String, VisalloLogger> logMap = new HashMap<String, VisalloLogger>();
    private static boolean initialized = false;
    private static boolean initializing = false;

    public static VisalloLogger getLogger(Class clazz, String processType) {
        if (processType != null) {
            VisalloLoggerFactory.setProcessType(processType);
        } else {
            VisalloLoggerFactory.setProcessType(clazz.getSimpleName());
        }
        VisalloLoggerFactory.ensureInitialized();
        return VisalloLoggerFactory.getLogger(clazz.getName());
    }

    public static VisalloLogger getLogger(Class clazz) {
        return VisalloLoggerFactory.getLogger(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() {
        Map<String, VisalloLogger> map = logMap;
        synchronized (map) {
            if (!initialized && !initializing) {
                initializing = true;
                if (System.getProperty("logFileSuffix") == null) {
                    String hostname = null;
                    try {
                        hostname = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        System.err.println("Could not get host name: " + e.getMessage());
                    }
                    String logFileSuffix = "-" + Joiner.on((String)"-").skipNulls().join((Object)VisalloLoggerFactory.getProcessType(), (Object)hostname, new Object[]{ProcessUtil.getPid()});
                    System.setProperty("logFileSuffix", logFileSuffix);
                }
                ConfigurationLoader.configureLog4j();
                initialized = true;
                initializing = false;
                VisalloLoggerFactory.logSystem();
            }
        }
    }

    private static void logSystem() {
        VisalloLogger logger = VisalloLoggerFactory.getLogger(VisalloLoggerFactory.class);
        VisalloLoggerFactory.logEnv(logger);
        VisalloLoggerFactory.logSystemProperties(logger);
        VisalloLoggerFactory.logJvmInputArguments(logger);
    }

    private static void logJvmInputArguments(VisalloLogger logger) {
        logger.info("jvm input arguments:", new Object[0]);
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String arg : arguments) {
            logger.info("  %s", arg);
        }
    }

    private static void logSystemProperties(VisalloLogger logger) {
        logger.info("system properties:", new Object[0]);
        ArrayList properties = Lists.newArrayList(System.getProperties().entrySet());
        Collections.sort(properties, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        });
        for (Map.Entry entry : properties) {
            logger.info("  %s: %s", entry.getKey(), entry.getValue());
        }
    }

    private static void logEnv(VisalloLogger logger) {
        logger.info("environment:", new Object[0]);
        ArrayList entries = Lists.newArrayList(System.getenv().entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : entries) {
            logger.info("  %s: %s", entry.getKey(), entry.getValue());
        }
    }

    public static void setProcessType(String processType) {
        if (VisalloLoggerFactory.getProcessType() == null) {
            if (initializing) {
                System.err.println("setProcessType called too late");
            } else if (initialized) {
                VisalloLoggerFactory.getLogger(VisalloLoggerFactory.class).warn("setProcessType called too late", new Object[0]);
            }
            System.setProperty("visallo.processType", processType);
        }
    }

    private static String getProcessType() {
        return System.getProperty("visallo.processType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisalloLogger getLogger(String name) {
        VisalloLoggerFactory.ensureInitialized();
        Map<String, VisalloLogger> map = logMap;
        synchronized (map) {
            VisalloLogger visalloLogger = logMap.get(name);
            if (visalloLogger != null) {
                return visalloLogger;
            }
            visalloLogger = new VisalloLogger(LoggerFactory.getLogger((String)name));
            logMap.put(name, visalloLogger);
            return visalloLogger;
        }
    }
}

