var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

define(['reselect'], function (reselect) {
    var createSelector = reselect.createSelector;


    var THING = 'http://www.w3.org/2002/07/owl#Thing';
    var ROOT = 'http://visallo.org#root';
    var EDGE_THING = 'http://www.w3.org/2002/07/owl#topObjectProperty';

    var _visible = function _visible(item) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _options$rootItemsHid = options.rootItemsHidden,
            rootItemsHidden = _options$rootItemsHid === undefined ? true : _options$rootItemsHid;

        return item && item.userVisible !== false && (!rootItemsHidden || item.id !== EDGE_THING && item.id !== THING && item.id !== ROOT) && item.displayName;
    };
    var _collectParents = function _collectParents(concepts) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
            parentKey = _ref.parentKey,
            _ref$extraKeys = _ref.extraKeys,
            extraKeys = _ref$extraKeys === undefined ? [] : _ref$extraKeys,
            _ref$defaults = _ref.defaults,
            defaults = _ref$defaults === undefined ? {} : _ref$defaults;

        return function (concept) {
            var collecting = _extends({
                path: [],
                fullPath: [],
                properties: []
            }, _.object(extraKeys.map(function (k) {
                return [k, null];
            })));
            _collect(concept);

            var path = collecting.path,
                fullPath = collecting.fullPath,
                properties = collecting.properties,
                override = _objectWithoutProperties(collecting, ['path', 'fullPath', 'properties']);

            _.each(override, function (v, k) {
                if (!v && defaults[k]) {
                    override[k] = defaults[k];
                }
            });
            var newConcept = _extends({}, concept, {
                path: '/' + path.reverse().join('/'),
                fullPath: '/' + fullPath.reverse().join('/'),
                properties: _.uniq(properties),
                depth: path.length - 1,
                fullDepth: fullPath.length - 1
            }, override);
            return newConcept;

            function _collect(concept) {
                extraKeys.forEach(function (k) {
                    collecting[k] = collecting[k] || concept[k];
                });
                if (_visible(concept, { rootItemsHidden: false })) {
                    collecting.fullPath.push(concept.displayName);
                }
                if (_visible(concept)) {
                    collecting.path.push(concept.displayName);
                }
                collecting.properties = collecting.properties.concat(concept.properties);

                if (concept[parentKey]) {
                    var parent = concepts[concept[parentKey]];
                    _collect(parent);
                }
            }
        };
    };

    var _propertiesWithHeaders = function _propertiesWithHeaders(properties) {
        var lastGroup = void 0;
        return properties.reduce(function (properties, property) {
            var propertyGroup = property.propertyGroup;

            if (propertyGroup && lastGroup !== propertyGroup) {
                lastGroup = propertyGroup;
                return [].concat(_toConsumableArray(properties), [{
                    displayName: propertyGroup,
                    header: true
                }, property]);
            }
            return [].concat(_toConsumableArray(properties), [property]);
        }, []);
    };

    var getWorkspace = function getWorkspace(state) {
        return state.workspace.currentId;
    };

    var getOntologyRoot = function getOntologyRoot(state) {
        return state.ontology;
    };

    var getConcepts = createSelector([getWorkspace, getOntologyRoot], function (workspaceId, ontology) {
        var concepts = ontology[workspaceId].concepts;
        var fn = _collectParents(concepts, {
            parentKey: 'parentConcept',
            extraKeys: ['color', 'displayType', 'glyphIconHref', 'glyphIconSelectedHref', 'titleFormula', 'subtitleFormula', 'timeFormula', 'validationFormula'],
            defaults: { glyphIconHref: 'img/glyphicons/glyphicons_194_circle_question_mark@2x.png' }
        });
        return _.mapObject(concepts, function (c) {
            return _extends({}, fn(c), { displayNameSub: '' });
        });
    });

    var getProperties = createSelector([getWorkspace, getOntologyRoot], function (workspaceId, ontology) {
        return ontology[workspaceId].properties;
    });

    var getRelationships = createSelector([getWorkspace, getOntologyRoot, getConcepts], function (workspaceId, ontology, concepts) {
        var relationships = ontology[workspaceId].relationships;
        var getSortedConcepts = function getSortedConcepts(iris) {
            return _.chain(iris).map(function (iri) {
                return concepts[iri];
            }).sortBy('displayName').sortBy('depth').value();
        };
        var fn = _collectParents(relationships, { parentKey: 'parentIri' });
        return _.omit(_.mapObject(relationships, function (r) {
            var newR = fn(r);
            var domains = getSortedConcepts(newR.domainConceptIris);
            var ranges = getSortedConcepts(newR.rangeConceptIris);
            if (domains.length === 0 && ranges.length === 0) return null;
            var domainGlyphIconHref = domains[0].glyphIconHref;
            var rangeGlyphIconHref = ranges[0].glyphIconHref;
            var displayNameSub = domains.length === 1 ? ranges.map(function (r) {
                return domains[0].displayName + '→' + r.displayName;
            }).join('\n') : ranges.length === 1 ? domains.map(function (d) {
                return d.displayName + '→' + ranges[0].displayName;
            }).join('\n') : '(' + domains.map(function (d) {
                return d.displayName;
            }).join(', ') + ') \u2192 (' + ranges.map(function (r) {
                return r.displayName;
            }).join(', ') + ')';
            return _extends({}, newR, { domainGlyphIconHref: domainGlyphIconHref, rangeGlyphIconHref: rangeGlyphIconHref, displayNameSub: displayNameSub });
        }), function (v) {
            return v === null;
        });
    });

    var getVisibleRelationships = createSelector([getRelationships, getConcepts], function (relationships, concepts) {
        var anyIrisVisible = function anyIrisVisible(iris) {
            return _.isArray(iris) && _.any(iris, function (iri) {
                return _visible(concepts[iri], { rootItemsHidden: false });
            });
        };
        var relationshipConceptsVisible = function relationshipConceptsVisible(r) {
            return anyIrisVisible(r.rangeConceptIris) && anyIrisVisible(r.domainConceptIris);
        };
        return _.chain(relationships).map().filter(function (r) {
            return _visible(r) && relationshipConceptsVisible(r);
        }).sortBy('path').value();
    });

    var getVisibleRelationshipsByConcept = createSelector([getVisibleRelationships], function (relationships) {
        var result = {};
        relationships.forEach(function (r) {
            ['domainConceptIris', 'rangeConceptIris'].forEach(function (key) {
                r[key].forEach(function (iri) {
                    if (!result[iri]) result[iri] = [];
                    if (!result[iri].includes(r.title)) {
                        result[iri].push(r.title);
                    }
                });
            });
        });
        return result;
    });

    var getOtherConcepts = createSelector([getVisibleRelationships], function (relationships) {
        var result = {};
        relationships.forEach(function (r) {
            r.domainConceptIris.forEach(function (d) {
                var _result$d;

                if (!result[d]) result[d] = [];
                (_result$d = result[d]).push.apply(_result$d, _toConsumableArray(r.rangeConceptIris));
            });
            r.rangeConceptIris.forEach(function (d) {
                var _result$d2;

                if (!result[d]) result[d] = [];
                (_result$d2 = result[d]).push.apply(_result$d2, _toConsumableArray(r.domainConceptIris));
            });
        });
        return result;
    });

    var getRelationshipAncestors = createSelector([getRelationships], function (relationships) {
        var byParent = _.groupBy(relationships, 'parentIri');
        var collectAncestors = function collectAncestors(list, r, skipFirst) {
            if (r) {
                if (!skipFirst) list.push(r.title);
                if (r.parentIri) {
                    collectAncestors(list, relationships[r.parentIri]);
                }
            }
            return _.uniq(list);
        };
        return _.mapObject(relationships, function (c) {
            return collectAncestors([], c, true);
        });
    });

    var getRelationshipKeyIris = function getRelationshipKeyIris(state) {
        return state.ontology.iris && state.ontology.iris.relationship;
    };

    var getConceptAncestors = createSelector([getConcepts], function (concepts) {
        var byParent = _.groupBy(concepts, 'parentConcept');
        var collectAncestors = function collectAncestors(list, c, skipFirst) {
            if (c) {
                if (!skipFirst) list.push(c.title);
                if (c.parentConcept) {
                    collectAncestors(list, concepts[c.parentConcept]);
                }
            }
            return _.uniq(list);
        };
        return _.mapObject(concepts, function (c) {
            return collectAncestors([], c, true);
        });
    });

    var getConceptDescendents = createSelector([getConcepts], function (concepts) {
        var byParent = _.groupBy(concepts, 'parentConcept');
        var collectDescendents = function collectDescendents(list, c, skipFirst) {
            if (!skipFirst) list.push(c.title);
            if (byParent[c.title]) {
                byParent[c.title].forEach(function (inner) {
                    return collectDescendents(list, inner);
                });
            }
            return _.uniq(list);
        };
        return _.mapObject(concepts, function (c) {
            return collectDescendents([], c, true);
        });
    });

    var getConceptsList = createSelector([getConcepts], function (concepts) {
        return _.chain(concepts).sortBy('fullPath').value();
    });

    var getVisibleConceptsList = createSelector([getConcepts], function (concepts) {
        return _.chain(concepts).filter(function (c) {
            return _visible(c);
        }).sortBy('path').value();
    });

    var getConceptsByRelatedConcept = createSelector([getVisibleConceptsList, getConceptAncestors, getOtherConcepts], function (concepts, ancestors, otherConcepts) {
        return _.chain(concepts).map(function (topConcept) {
            var concepts = [];
            [topConcept.id].concat(_toConsumableArray(ancestors[topConcept.id])).forEach(function (iri) {
                var other = otherConcepts[iri];
                if (other) {
                    concepts.push.apply(concepts, _toConsumableArray(_.uniq(other)));
                }
            });
            return [topConcept.id, concepts];
        }).object().value();
    });

    var getConceptKeyIris = function getConceptKeyIris(state) {
        return state.ontology.iris && state.ontology.iris.concept;
    };

    var getOntology = createSelector([getOntologyRoot, getWorkspace], function (ontology, workspaceId) {
        return ontology[workspaceId];
    });

    var getPropertiesByConcept = createSelector([getConcepts, getProperties], function (concepts, properties) {
        return _.mapObject(concepts, function (r) {
            return _.pick(properties, r.properties);
        });
    });

    var getConceptProperties = createSelector([getPropertiesByConcept], function (propertiesByConcept) {
        var conceptProperties = {};

        return Object.keys(propertiesByConcept).reduce(function (properties, concept) {
            return _extends({}, properties, propertiesByConcept[concept]);
        }, conceptProperties);
    });

    var getPropertiesByRelationship = createSelector([getRelationships, getProperties], function (relationships, properties) {
        return _.mapObject(relationships, function (r) {
            return _.pick(properties, r.properties);
        });
    });

    var getRelationshipProperties = createSelector([getPropertiesByRelationship], function (propertiesByRelationship) {
        var relationshipProperties = {};

        return Object.keys(propertiesByRelationship).reduce(function (properties, relationship) {
            return _extends({}, properties, propertiesByRelationship[relationship]);
        }, relationshipProperties);
    });

    var getPropertiesByDependentToCompound = createSelector([getProperties], function (properties) {
        var dependentToCompounds = {};
        Object.keys(properties).forEach(function (iri) {
            var dependentPropertyIris = properties[iri].dependentPropertyIris;

            if (dependentPropertyIris) {
                dependentPropertyIris.forEach(function (dIri) {
                    var list = dependentToCompounds[dIri] || (dependentToCompounds[dIri] = []);
                    if (!list.includes(iri)) {
                        list.push(iri);
                    }
                });
            }
        });

        return dependentToCompounds;
    });

    var getPropertiesList = createSelector([getProperties], function (properties) {
        var compareNameAndGroup = function compareNameAndGroup(_ref2) {
            var displayName = _ref2.displayName,
                propertyGroup = _ref2.propertyGroup;

            var displayNameLC = displayName.toLowerCase();
            return propertyGroup ? '1' + propertyGroup + displayNameLC : '0' + displayNameLC;
        };

        return _.chain(properties).sortBy(compareNameAndGroup).value();
    });

    var getVisiblePropertiesList = createSelector([getPropertiesList], function (properties) {
        return _.filter(properties, _visible);
    });

    var getPropertyKeyIris = function getPropertyKeyIris(state) {
        return state.ontology.iris && state.ontology.iris.property;
    };

    var getPropertiesWithHeaders = createSelector([getPropertiesList], function (properties) {
        return _propertiesWithHeaders(properties);
    });

    var getVisiblePropertiesWithHeaders = createSelector([getVisiblePropertiesList], function (properties) {
        return _propertiesWithHeaders(properties);
    });

    return {
        getOntology: getOntology,

        getConcepts: getConcepts,
        getConceptKeyIris: getConceptKeyIris,
        getConceptDescendents: getConceptDescendents,
        getConceptAncestors: getConceptAncestors,
        getConceptsList: getConceptsList,
        getConceptsByRelatedConcept: getConceptsByRelatedConcept,
        getVisibleConceptsList: getVisibleConceptsList,

        getProperties: getProperties,
        getPropertyKeyIris: getPropertyKeyIris,
        getPropertiesByConcept: getPropertiesByConcept,
        getConceptProperties: getConceptProperties,
        getPropertiesByRelationship: getPropertiesByRelationship,
        getRelationshipProperties: getRelationshipProperties,
        getPropertiesByDependentToCompound: getPropertiesByDependentToCompound,
        getPropertiesList: getPropertiesList,
        getVisiblePropertiesList: getVisiblePropertiesList,
        getPropertiesWithHeaders: getPropertiesWithHeaders,
        getVisiblePropertiesWithHeaders: getVisiblePropertiesWithHeaders,

        getRelationships: getRelationships,
        getRelationshipAncestors: getRelationshipAncestors,
        getRelationshipKeyIris: getRelationshipKeyIris,
        getVisibleRelationships: getVisibleRelationships,
        getVisibleRelationshipsByConcept: getVisibleRelationshipsByConcept
    };
});