define([], function () {
    'use strict';

    var FULL_NUMERIC_REGEX = /^[\-\+]?\d+\.?\d*$/,
        NUMERIC_WITH_UNITS_REGEX = /^[\-\+]?\d+\.?\d*[a-z]+$/,
        prepare = function prepare(str) {
        return str.replace(/,/g, '');
    },
        PARSERS = {

        number: {
            isValid: function isValid(s) {
                return _.isString(s) && FULL_NUMERIC_REGEX.test(s);
            },

            isValidWithUnits: function isValidWithUnits(s) {
                return _.isString(s) && NUMERIC_WITH_UNITS_REGEX.test(s);
            },

            parseFloat: function (_parseFloat) {
                function parseFloat(_x) {
                    return _parseFloat.apply(this, arguments);
                }

                parseFloat.toString = function () {
                    return _parseFloat.toString();
                };

                return parseFloat;
            }(function (s) {
                return PARSERS.number.isValid(s) ? parseFloat(prepare(s), 10) : NaN;
            }),

            parseInt: function (_parseInt) {
                function parseInt(_x2) {
                    return _parseInt.apply(this, arguments);
                }

                parseInt.toString = function () {
                    return _parseInt.toString();
                };

                return parseInt;
            }(function (s) {
                return PARSERS.number.isValid(s) ? parseInt(prepare(s), 10) : NaN;
            }),

            parseFloatWithUnits: function parseFloatWithUnits(s) {
                return PARSERS.number.isValidWithUnits(s) ? parseFloat(prepare(s), 10) : NaN;
            },

            parseIntWithUnits: function parseIntWithUnits(s) {
                return PARSERS.number.isValidWithUnits(s) ? parseInt(prepare(s), 10) : NaN;
            }
        },

        bool: {
            parse: function parse(s, defaultValue) {
                if (typeof s === 'boolean') {
                    return s;
                } else if (typeof s === 'string') {
                    if (s.toLocaleLowerCase() === 'true') {
                        return true;
                    } else if (s.toLocaleLowerCase() === 'false') {
                        return false;
                    }
                } else if ((_.isUndefined(s) || _.isNull(s)) && typeof defaultValue === 'boolean') {
                    return defaultValue;
                }
                throw new Error('Could not parse boolean "' + s + '"');
            }
        }
    };

    return PARSERS;
});