/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.video.VideoFrameInfo;
import org.visallo.core.ingest.video.VideoPropertyHelper;
import org.visallo.core.ingest.video.VideoTranscript;
import org.visallo.core.model.textHighlighting.OffsetItem;
import org.visallo.core.model.textHighlighting.VertexOffsetItem;
import org.visallo.web.clientapi.model.SandboxStatus;

public class EntityHighlighter {
    private static final int KB = 1024;
    public static final int BUFFER_SIZE = 512000;
    public static final EnumSet<Options> DefaultOptions = EnumSet.of(Options.IncludeStyle);

    public void transformHighlightedText(InputStream text, OutputStream output, Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        this.transformHighlightedText(text, output, termMentions, -1L, workspaceId, authorizations);
    }

    public void transformHighlightedText(InputStream text, OutputStream output, Iterable<Vertex> termMentions, long maxTextLength, String workspaceId, Authorizations authorizations) {
        List<OffsetItem> offsetItems = this.convertTermMentionsToOffsetItems(termMentions, workspaceId, authorizations);
        EntityHighlighter.transformToHighlightedText(text, output, offsetItems, maxTextLength);
    }

    public static String getHighlightedText(String text, List<OffsetItem> offsetItems) {
        return EntityHighlighter.getHighlightedText(text, offsetItems, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHighlightedText(String text, List<OffsetItem> offsetItems, EnumSet<Options> options) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            EntityHighlighter.transformToHighlightedText(IOUtils.toInputStream((String)text, (String)StandardCharsets.UTF_8.name()), out, offsetItems, -1L, options);
            String string = out.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new VisalloException("Unable to transform to highlighted text", e);
        }
    }

    public static void transformToHighlightedText(InputStream text, OutputStream output, List<OffsetItem> offsetItems) {
        EntityHighlighter.transformToHighlightedText(text, output, offsetItems, -1L, DefaultOptions);
    }

    public static void transformToHighlightedText(InputStream text, OutputStream output, List<OffsetItem> offsetItems, long maxTextLength) {
        EntityHighlighter.transformToHighlightedText(text, output, offsetItems, maxTextLength, DefaultOptions);
    }

    public static void transformToHighlightedText(InputStream text, OutputStream output, List<OffsetItem> offsetItems, long maxTextLength, EnumSet<Options> options) {
        try (InputStreamReader in = new InputStreamReader(text);
             NonBreakingSpaceFilteredOutputStream filteredSpaces = new NonBreakingSpaceFilteredOutputStream(output);
             OutputStreamWriter out = new OutputStreamWriter(filteredSpaces);){
            int len;
            if (offsetItems == null) {
                offsetItems = new ArrayList<OffsetItem>();
            }
            ArrayList<OffsetItem> started = new ArrayList<OffsetItem>();
            List<OffsetItem> items = offsetItems.stream().filter(offsetItem -> offsetItem.shouldHighlight()).sorted((o1, o2) -> {
                long c = o1.getStart() - o2.getStart();
                if (c == 0L) {
                    c = o2.getEnd() - o1.getEnd();
                }
                return c > 0L ? 1 : (c < 0L ? -1 : 0);
            }).collect(Collectors.toList());
            if (options == null) {
                options = DefaultOptions;
            }
            char[] buffer = new char[512000];
            int offset = 0;
            int maxDepth = 0;
            boolean closeWhenAvailable = false;
            while ((len = in.read(buffer, 0, 512000)) != -1) {
                int innerOffset = 0;
                Iterator itemsIterator = items.iterator();
                ArrayList<OffsetItem> toRemove = new ArrayList<OffsetItem>();
                while (itemsIterator.hasNext()) {
                    OffsetItem item = (OffsetItem)itemsIterator.next();
                    long start = item.getStart();
                    if (!EntityHighlighter.indexInsideCurrentBuffer(start, offset, innerOffset, len)) continue;
                    started.sort((o1, o2) -> {
                        long c = o1.getEnd() - o2.getEnd();
                        return c > 0L ? 1 : (c < 0L ? -1 : 0);
                    });
                    Iterator<OffsetItem> others = started.iterator();
                    while (others.hasNext()) {
                        long end;
                        OffsetItem otherItem = (OffsetItem)others.next();
                        if (otherItem == item || (end = otherItem.getEnd()) >= start) continue;
                        innerOffset = EntityHighlighter.getInnerOffset(out, started, items, toRemove, buffer, offset, innerOffset, others, otherItem, (int)end);
                    }
                    innerOffset = EntityHighlighter.writePrefixToIndex(started, items, out, (int)start, offset, innerOffset, buffer);
                    EntityHighlighter.addOffsetItemSpan(out, started, items, item, true);
                    started.add(item);
                    maxDepth = Math.max(maxDepth, started.size());
                }
                items.removeAll(toRemove);
                started.sort((o1, o2) -> {
                    long c = o1.getEnd() - o2.getEnd();
                    if (c == 0L) {
                        c = o2.getStart() - o1.getStart();
                    }
                    return c > 0L ? 1 : (c < 0L ? -1 : 0);
                });
                Iterator<OffsetItem> openedIterator = started.iterator();
                while (openedIterator.hasNext()) {
                    OffsetItem opened = (OffsetItem)openedIterator.next();
                    long end = opened.getEnd();
                    if (!EntityHighlighter.indexInsideCurrentBuffer(end, offset, innerOffset, len)) continue;
                    innerOffset = EntityHighlighter.getInnerOffset(out, started, items, items, buffer, offset, innerOffset, openedIterator, opened, (int)end);
                }
                if (closeWhenAvailable && started.size() == 0) break;
                if (innerOffset < len) {
                    EntityHighlighter.writeBuffer(started, items, out, buffer, innerOffset, len - innerOffset);
                }
                if (maxTextLength == -1L || (long)(offset += len) <= maxTextLength) continue;
                closeWhenAvailable = true;
            }
            if (options.contains((Object)Options.IncludeStyle)) {
                EntityHighlighter.writeStyle(out, maxDepth);
            }
            if (closeWhenAvailable) {
                EntityHighlighter.writeTruncated(out);
            }
        }
        catch (IOException e) {
            throw new VisalloException("Unable to transform to highlighted text", e);
        }
    }

    private static void writeTruncated(OutputStreamWriter out) throws IOException {
        out.write("<div class=\"truncated\">This text has exceeded the configured maximum length, and has been truncated.</div>");
    }

    private static void writeStyle(OutputStreamWriter out, int maxDepth) throws IOException {
        out.write("<style>");
        StringBuilder selector = new StringBuilder(".text");
        int outset = 0;
        int lineHeight = 18;
        for (int depth = 1; depth <= maxDepth; ++depth) {
            selector.append(" .res");
            out.write(selector.toString());
            out.write("{");
            out.write("border-image-outset: 0 0 " + outset + "px 0;");
            if (depth == 1) {
                out.write("border-bottom: 1px solid black;");
                out.write("border-image-source: linear-gradient(to right, black, black);");
                out.write("border-image-slice: 0 0 1 0;");
                out.write("border-image-width: 0 0 1px 0;");
                out.write("border-image-repeat: repeat;");
            }
            if (depth > 1) {
                double lineHeightDec = (double)lineHeight / 10.0;
                out.write("line-height: " + lineHeightDec + ";");
            }
            out.write("}");
            if (depth == 1) {
                out.write(selector.toString() + ".resolvable");
                out.write("{");
                out.write("border-image-source: repeating-linear-gradient(to right, transparent, transparent 1px, rgb(0,0,0) 1px, rgb(0,0,0) 3px);");
                out.write("}");
            }
            if (depth >= 2) {
                ++lineHeight;
            }
            outset += 2;
        }
        out.write("</style>");
    }

    private static int getInnerOffset(OutputStreamWriter out, List<OffsetItem> started, List<OffsetItem> all, List<OffsetItem> toRemove, char[] buffer, int offset, int innerOffset, Iterator<OffsetItem> removeIterator, OffsetItem opened, int end) throws IOException {
        innerOffset = EntityHighlighter.writePrefixToIndex(started, all, out, end, offset, innerOffset, buffer);
        removeIterator.remove();
        toRemove.remove(opened);
        List<OffsetItem> toClose = started.stream().filter(offsetItem -> offsetItem.getStart() > opened.getStart() || offsetItem.getEnd() < opened.getStart()).collect(Collectors.toList());
        EntityHighlighter.addClosingOffsetItems(out, toClose);
        EntityHighlighter.addClosingOffsetItemSpan(out, opened);
        EntityHighlighter.addOffsetItems(out, started, all, toClose);
        return innerOffset;
    }

    private static int writePrefixToIndex(List<OffsetItem> opened, List<OffsetItem> all, OutputStreamWriter out, int index, int offset, int innerOffset, char[] buffer) throws IOException {
        int preLength = index - innerOffset - offset;
        if (preLength > 0) {
            EntityHighlighter.writeBuffer(opened, all, out, buffer, innerOffset, preLength);
            innerOffset += preLength;
        }
        return innerOffset;
    }

    private static void writeBuffer(List<OffsetItem> started, List<OffsetItem> all, OutputStreamWriter out, char[] buffer, int offset, int len) throws IOException {
        String strBuffer = new String(buffer, offset, len);
        out.write(StringEscapeUtils.escapeXml11((String)strBuffer));
    }

    private static boolean indexInsideCurrentBuffer(long index, int offset, int innerOffset, int len) {
        return index >= (long)offset && index - (long)offset < 512000L;
    }

    private static void addOffsetItems(OutputStreamWriter out, List<OffsetItem> opened, List<OffsetItem> all, Collection<OffsetItem> items) throws IOException {
        for (OffsetItem otherOpened : items) {
            EntityHighlighter.addOffsetItemSpan(out, opened, all, otherOpened);
        }
    }

    private static void addClosingOffsetItems(OutputStreamWriter out, Collection<OffsetItem> items) throws IOException {
        for (OffsetItem otherOpened : items) {
            EntityHighlighter.addClosingOffsetItemSpan(out, otherOpened);
        }
    }

    private static void addOffsetItemSpan(OutputStreamWriter out, List<OffsetItem> opened, List<OffsetItem> all, OffsetItem item) throws IOException {
        EntityHighlighter.addOffsetItemSpan(out, opened, all, item, false, false);
    }

    private static void addOffsetItemSpan(OutputStreamWriter out, List<OffsetItem> opened, List<OffsetItem> all, OffsetItem item, boolean fullInfo) throws IOException {
        EntityHighlighter.addOffsetItemSpan(out, opened, all, item, fullInfo, false);
    }

    private static void addClosingOffsetItemSpan(OutputStreamWriter out, OffsetItem item) throws IOException {
        EntityHighlighter.addOffsetItemSpan(out, null, null, item, false, true);
    }

    private static void addOffsetItemSpan(OutputStreamWriter out, List<OffsetItem> opened, List<OffsetItem> all, OffsetItem item, boolean fullInfo, boolean closing) throws IOException {
        if (!closing) {
            JSONObject infoJson = item.getInfoJson();
            out.write("<span");
            out.write(" class=\"");
            out.write(StringUtils.join(item.getCssClasses(), (String)" "));
            out.write("\"");
            if (item.getTitle() != null) {
                out.write(" title=\"");
                out.write(StringEscapeUtils.escapeXml11((String)item.getTitle()));
                out.write("\"");
            }
            String classIdentifier = item.getClassIdentifier();
            if (fullInfo) {
                if (infoJson != null) {
                    out.write(" data-info=\"");
                    out.write(StringEscapeUtils.escapeXml11((String)infoJson.toString()));
                    out.write("\"");
                }
                if (classIdentifier != null) {
                    out.write(" data-ref-id=\"" + classIdentifier + "\"");
                }
            } else if (classIdentifier != null) {
                out.write(" data-ref=\"" + classIdentifier + "\"");
            }
            out.write(">");
        } else {
            out.write("</span>");
        }
    }

    public VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        List<OffsetItem> offsetItems = this.convertTermMentionsToOffsetItems(termMentions, workspaceId, authorizations);
        return this.getHighlightedVideoTranscript(videoTranscript, offsetItems);
    }

    private VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, List<OffsetItem> offsetItems) {
        Map<Integer, List<OffsetItem>> videoTranscriptOffsetItems = this.convertOffsetItemsToVideoTranscriptOffsetItems(videoTranscript, offsetItems);
        return this.getHighlightedVideoTranscript(videoTranscript, videoTranscriptOffsetItems);
    }

    private VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, Map<Integer, List<OffsetItem>> videoTranscriptOffsetItems) {
        VideoTranscript result = new VideoTranscript();
        int entryIndex = 0;
        for (VideoTranscript.TimedText videoTranscriptEntry : videoTranscript.getEntries()) {
            VideoTranscript.TimedText entry = videoTranscript.getEntries().get(entryIndex);
            List<OffsetItem> offsetItems = videoTranscriptOffsetItems.get(entryIndex);
            String highlightedText = EntityHighlighter.getHighlightedText(entry.getText(), offsetItems);
            result.add(videoTranscriptEntry.getTime(), highlightedText);
            ++entryIndex;
        }
        return result;
    }

    private Map<Integer, List<OffsetItem>> convertOffsetItemsToVideoTranscriptOffsetItems(VideoTranscript videoTranscript, List<OffsetItem> offsetItems) {
        HashMap<Integer, List<OffsetItem>> results = new HashMap<Integer, List<OffsetItem>>();
        for (OffsetItem offsetItem : offsetItems) {
            Integer videoTranscriptEntryIndex = EntityHighlighter.getVideoTranscriptEntryIndex(videoTranscript, offsetItem);
            offsetItem.setShouldBitShiftOffsetsForVideoTranscript(true);
            ArrayList<OffsetItem> currentList = (ArrayList<OffsetItem>)results.get(videoTranscriptEntryIndex);
            if (currentList == null) {
                currentList = new ArrayList<OffsetItem>();
                results.put(videoTranscriptEntryIndex, currentList);
            }
            currentList.add(offsetItem);
        }
        return results;
    }

    private static int getVideoTranscriptEntryIndex(VideoTranscript videoTranscript, OffsetItem offsetItem) {
        Integer videoTranscriptEntryIndex = null;
        VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfo(offsetItem.getId());
        if (videoFrameInfo != null) {
            videoTranscriptEntryIndex = videoTranscript.findEntryIndexFromStartTime(videoFrameInfo.getFrameStartTime());
        }
        if (videoTranscriptEntryIndex == null) {
            videoTranscriptEntryIndex = offsetItem.getVideoTranscriptEntryIndex();
        }
        return videoTranscriptEntryIndex;
    }

    public List<OffsetItem> convertTermMentionsToOffsetItems(Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        ArrayList<OffsetItem> termMetadataOffsetItems = new ArrayList<OffsetItem>();
        for (Vertex termMention : termMentions) {
            String visibility = termMention.getVisibility().getVisibilityString();
            SandboxStatus sandboxStatus = SandboxStatus.getFromVisibilityString((String)visibility, (String)workspaceId);
            termMetadataOffsetItems.add(new VertexOffsetItem(termMention, sandboxStatus, authorizations));
        }
        return termMetadataOffsetItems;
    }

    private static class NonBreakingSpaceFilteredOutputStream
    extends FilterOutputStream {
        private static Pattern NonBreakingSpacePattern = Pattern.compile("(&amp;nbsp;)", 2);
        private static String Replacement = " ";
        private static byte[] breakBytes = "\n<br>".getBytes(StandardCharsets.UTF_8);
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public NonBreakingSpaceFilteredOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            for (int i = offset; i < offset + length; ++i) {
                this.write(data[i]);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            this.replaceLine();
            this.out.flush();
            super.close();
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 10) {
                this.buffer.write(breakBytes);
                this.replaceLine();
            } else {
                this.buffer.write(b);
            }
        }

        private void replaceLine() throws IOException {
            String workingLine = this.buffer.toString();
            this.buffer.reset();
            Matcher matcher = NonBreakingSpacePattern.matcher(workingLine);
            boolean foundMatch = matcher.find();
            if (foundMatch) {
                StringBuffer stringBuffer = new StringBuffer();
                while (foundMatch) {
                    matcher.appendReplacement(stringBuffer, Replacement);
                    foundMatch = matcher.find();
                }
                matcher.appendTail(stringBuffer);
                this.out.write(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
            } else {
                this.out.write(workingLine.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static enum Options {
        IncludeStyle;

    }
}

