/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.visallo.core.cache.CacheOptions;
import org.visallo.core.cache.CacheService;

@Singleton
public class InMemoryCacheService
implements CacheService {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, Cache> caches = new HashMap<String, Cache>();

    @Override
    public <T> T put(String cacheName, String key, T t, CacheOptions cacheOptions) {
        return this.write(() -> {
            Cache cache = this.getOrCreateCache(cacheName, cacheOptions);
            cache.put((Object)key, t);
            return t;
        });
    }

    @Override
    public <T> T getIfPresent(String cacheName, String key) {
        return this.read(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            return cache.getIfPresent((Object)key);
        });
    }

    @Override
    public void invalidate(String cacheName) {
        this.write(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            cache.invalidateAll();
            return null;
        });
    }

    @Override
    public void invalidate(String cacheName, String key) {
        this.write(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            cache.invalidate((Object)key);
            return null;
        });
    }

    private <T> Cache<String, T> getCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    private <T> Cache<String, T> getOrCreateCache(String cacheName, CacheOptions cacheOptions) {
        Cache cache = this.getCache(cacheName);
        if (cache != null) {
            return cache;
        }
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (cacheOptions.getMaximumSize() != null) {
            builder.maximumSize(cacheOptions.getMaximumSize().longValue());
        }
        cache = builder.build();
        this.caches.put(cacheName, cache);
        return cache;
    }

    private <T> T write(Provider<T> provider) {
        this.readWriteLock.writeLock().lock();
        try {
            Object object = provider.get();
            return (T)object;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private <T> T read(Provider<T> provider) {
        this.readWriteLock.readLock().lock();
        try {
            Object object = provider.get();
            return (T)object;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

