/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.config;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.config.Configurator;
import org.json.JSONObject;
import org.visallo.core.config.Configuration;
import org.visallo.core.config.FileConfigurationLoader;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class ConfigurationLoader {
    public static final String ENV_CONFIGURATION_LOADER = "VISALLO_CONFIGURATION_LOADER";
    private static Configuration configuration;
    private final Map initParameters;
    private JSONObject configurationInfo = new JSONObject();

    protected ConfigurationLoader(Map initParameters) {
        this.initParameters = initParameters;
    }

    public static void configureLog4j() {
        ConfigurationLoader configurationLoader = ConfigurationLoader.createConfigurationLoader();
        configurationLoader.doConfigureLog4j();
    }

    public static Configuration load() {
        return ConfigurationLoader.load(new HashMap());
    }

    public static Configuration load(Map p) {
        return ConfigurationLoader.load(ConfigurationLoader.getConfigurationLoaderClass(), p);
    }

    public static Class getConfigurationLoaderClass() {
        String configLoaderName = System.getenv(ENV_CONFIGURATION_LOADER);
        if (configLoaderName == null) {
            configLoaderName = System.getProperty(ENV_CONFIGURATION_LOADER);
        }
        if (configLoaderName != null) {
            return ConfigurationLoader.getConfigurationLoaderByName(configLoaderName);
        }
        return FileConfigurationLoader.class;
    }

    public static Configuration load(String configLoaderName, Map<String, String> initParameters) {
        Class configLoader = configLoaderName == null ? ConfigurationLoader.getConfigurationLoaderClass() : ConfigurationLoader.getConfigurationLoaderByName(configLoaderName);
        return ConfigurationLoader.load(configLoader, initParameters);
    }

    public static Class getConfigurationLoaderByName(String configLoaderName) {
        Class<?> configLoader;
        try {
            configLoader = Class.forName(configLoaderName);
        }
        catch (ClassNotFoundException e) {
            throw new VisalloException("Could not load class " + configLoaderName, e);
        }
        return configLoader;
    }

    public static Configuration load(Class configLoader, Map initParameters) {
        ConfigurationLoader configurationLoader = ConfigurationLoader.createConfigurationLoader(configLoader, initParameters);
        if (configuration == null) {
            configuration = configurationLoader.createConfiguration();
        }
        ConfigurationLoader.setSystemProperties(configuration);
        return configuration;
    }

    private static void setSystemProperties(Configuration configuration) {
        Map<String, String> systemProperties = configuration.getSubset("systemProperty");
        for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
            System.setProperty(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    private static ConfigurationLoader createConfigurationLoader() {
        return ConfigurationLoader.createConfigurationLoader(null, null);
    }

    private static ConfigurationLoader createConfigurationLoader(Class configLoaderClass, Map initParameters) {
        if (configLoaderClass == null) {
            configLoaderClass = ConfigurationLoader.getConfigurationLoaderClass();
        }
        if (initParameters == null) {
            initParameters = new HashMap();
        }
        try {
            Constructor constructor = configLoaderClass.getConstructor(Map.class);
            return (ConfigurationLoader)constructor.newInstance(initParameters);
        }
        catch (Exception e) {
            throw new VisalloException("Could not load configuration class: " + configLoaderClass.getName(), e);
        }
    }

    public abstract Configuration createConfiguration();

    protected void doConfigureLog4j() {
        String fileName = System.getProperty("logQuiet") == null ? "log4j2.xml" : "log4j2-quiet.xml";
        File log4jFile = null;
        String log4jLocation = null;
        try {
            log4jFile = this.resolveFileName(fileName);
        }
        catch (VisalloResourceNotFoundException visalloResourceNotFoundException) {
            // empty catch block
        }
        if (log4jFile == null || !log4jFile.exists()) {
            URL log4jResource = this.getClass().getResource(fileName);
            System.err.println("Could not resolve log4j2.xml, using the fallback: " + log4jResource);
            try {
                if (log4jResource == null) {
                    throw new VisalloResourceNotFoundException("Could not find log4j2.xml on the classpath");
                }
                Configurator.initialize((String)null, null, (URI)log4jResource.toURI());
                log4jLocation = log4jResource.toExternalForm();
            }
            catch (URISyntaxException e) {
                throw new VisalloException("Unable to load default log42.xml", e);
            }
        } else {
            log4jLocation = log4jFile.getAbsolutePath();
            Configurator.initialize((String)null, null, (URI)log4jFile.toURI());
        }
        VisalloLogger logger = VisalloLoggerFactory.getLogger(VisalloLoggerFactory.class);
        logger.info("Using ConfigurationLoader: %s", this.getClass().getName());
        logger.info("Using log4j2.xml: %s", log4jLocation);
    }

    public abstract File resolveFileName(String var1);

    protected Map getInitParameters() {
        return this.initParameters;
    }

    protected void setConfigurationInfo(String key, Object object) {
        this.configurationInfo.put(key, object);
    }

    public JSONObject getConfigurationInfo() {
        return this.configurationInfo;
    }
}

