/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.email;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.visallo.core.config.Configuration;
import org.visallo.core.email.EmailRepository;
import org.visallo.core.email.SmtpEmailConfiguration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Singleton
public class SmtpEmailRepository
implements EmailRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SmtpEmailRepository.class);
    private static final String CHARSET = "UTF-8";
    private SmtpEmailConfiguration smtpEmailConfiguration = new SmtpEmailConfiguration();

    @Inject
    public SmtpEmailRepository(Configuration configuration) {
        configuration.setConfigurables(this.smtpEmailConfiguration, "repository.email.smtp");
    }

    @Override
    public void send(String fromAddress, String toAddress, String subject, String body) {
        this.send(fromAddress, new String[]{toAddress}, subject, body);
    }

    @Override
    public void send(String fromAddress, String[] toAddresses, String subject, String body) {
        String joinedToAddresses = Joiner.on((String)",").join((Object[])toAddresses);
        LOGGER.info("sending SMTP email from: \"%s\", to: \"%s\", subject: \"%s\"", fromAddress, joinedToAddresses, subject);
        LOGGER.debug("sending SMTP email body:%n%s", body);
        try {
            MimeMessage mimeMessage = new MimeMessage(this.getSession());
            mimeMessage.setFrom((Address)InternetAddress.parse((String)fromAddress)[0]);
            mimeMessage.setSubject(subject, CHARSET);
            if (body.startsWith("<html>")) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart html = new MimeBodyPart();
                String contentType = "text/html; charset=UTF-8";
                html.setHeader("Content-Type", contentType);
                html.setContent((Object)body, contentType);
                multipart.addBodyPart((BodyPart)html);
                mimeMessage.setContent((Multipart)multipart);
            } else {
                mimeMessage.setText(body, CHARSET);
            }
            mimeMessage.setSentDate(new Date());
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)joinedToAddresses));
            Transport.send((Message)mimeMessage);
        }
        catch (SendFailedException me) {
            throw new VisalloException("Error sending emails to: " + Joiner.on((String)",").join((Object)me.getValidUnsentAddresses(), (Object)me.getInvalidAddresses(), new Object[0]), me);
        }
        catch (MessagingException me) {
            throw new VisalloException("exception while sending email", me);
        }
    }

    private Session getSession() {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.smtpEmailConfiguration.getServerHostname());
        properties.put("mail.smtp.port", (Object)this.smtpEmailConfiguration.getServerPort());
        Authenticator authenticator = null;
        switch (this.smtpEmailConfiguration.getServerAuthentication()) {
            case NONE: {
                break;
            }
            case TLS: {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.starttls.enable", "true");
                authenticator = this.getAuthenticator();
                break;
            }
            case SSL: {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.socketFactory.port", (Object)this.smtpEmailConfiguration.getServerPort());
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                authenticator = this.getAuthenticator();
                break;
            }
            default: {
                throw new VisalloException("unexpected MailServerAuthentication: " + this.smtpEmailConfiguration.getServerAuthentication().toString());
            }
        }
        Session session = Session.getDefaultInstance((Properties)properties, authenticator);
        if (LOGGER.isTraceEnabled()) {
            session.setDebugOut((PrintStream)new LoggerPrintStream(LOGGER));
            session.setDebug(true);
        }
        return session;
    }

    private Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SmtpEmailRepository.this.smtpEmailConfiguration.getServerUsername(), SmtpEmailRepository.this.smtpEmailConfiguration.getServerPassword());
            }
        };
    }

    private class LoggerPrintStream
    extends PrintStream {
        public LoggerPrintStream(final VisalloLogger logger) {
            super(new OutputStream(){
                private final int NEWLINE = "\n".getBytes()[0];
                private final StringWriter buffer = new StringWriter();

                @Override
                public void write(int c) throws IOException {
                    if (c == this.NEWLINE) {
                        logger.trace(this.buffer.toString(), new Object[0]);
                        this.buffer.getBuffer().setLength(0);
                    } else {
                        this.buffer.write(c);
                    }
                }
            });
        }
    }
}

