/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.externalResource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.externalResource.ExternalResourceWorker;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ExternalResourceRunner {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ExternalResourceRunner.class);
    private final Configuration config;
    private final User user;
    private List<RunningWorker> runningWorkers = new ArrayList<RunningWorker>();

    public ExternalResourceRunner(Configuration config, User user) {
        this.config = config;
        this.user = user;
    }

    public void startAllAndWait() {
        Collection<RunningWorker> runningWorkers = this.startAll();
        while (runningWorkers.size() > 0) {
            for (RunningWorker runningWorker : runningWorkers) {
                if (!runningWorker.getThread().isAlive()) {
                    LOGGER.error("found a dead thread: " + runningWorker.getThread().getName(), new Object[0]);
                    return;
                }
                try {
                    runningWorker.getThread().join(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("join interrupted", e);
                    return;
                }
            }
        }
    }

    public Collection<RunningWorker> startAll() {
        this.runningWorkers = new ArrayList<RunningWorker>();
        Collection<ExternalResourceWorker> workers = InjectHelper.getInjectedServices(ExternalResourceWorker.class, this.config);
        for (ExternalResourceWorker worker : workers) {
            this.runningWorkers.add(this.start(worker, this.user));
        }
        return this.runningWorkers;
    }

    private RunningWorker start(ExternalResourceWorker worker, User user) {
        worker.prepare(user);
        Thread t = new Thread(() -> {
            try {
                worker.run();
            }
            catch (Throwable ex) {
                LOGGER.error("Failed running external resource worker: " + worker.getClass().getName(), ex);
            }
        });
        t.setName("external-resource-worker-" + worker.getClass().getSimpleName() + "-" + t.getId());
        t.setDaemon(true);
        LOGGER.debug("starting external resource worker thread: %s", t.getName());
        t.start();
        return new RunningWorker(worker, t);
    }

    public void shutdown() {
        LOGGER.debug("Stopping ExternalResourceRunner...", new Object[0]);
        for (RunningWorker worker : this.runningWorkers) {
            worker.shutdown();
        }
        LOGGER.debug("Stopped ExternalResourceRunner", new Object[0]);
    }

    public static class RunningWorker {
        private final ExternalResourceWorker worker;
        private final Thread thread;

        public RunningWorker(ExternalResourceWorker worker, Thread thread) {
            this.worker = worker;
            this.thread = thread;
        }

        public ExternalResourceWorker getWorker() {
            return this.worker;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void shutdown() {
            this.worker.stop();
        }
    }
}

