/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.formula;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.vertexium.Authorizations;
import org.vertexium.VertexiumObject;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.formula.RequireJsSupport;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.ClientApiVertexiumObject;
import org.visallo.web.clientapi.util.ObjectMapperFactory;

@Singleton
public class FormulaEvaluator {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FormulaEvaluator.class);
    private static final String CONFIGURATION_PARAMETER_MAX_THREADS = FormulaEvaluator.class.getName() + ".max.threads";
    private static final int CONFIGURATION_DEFAULT_MAX_THREADS = 1;
    private Configuration configuration;
    private OntologyRepository ontologyRepository;
    private ExecutorService executorService;
    private static final ThreadLocal<Map<String, Scriptable>> threadLocalScope = ThreadLocal.withInitial(HashMap::new);

    @Inject
    public FormulaEvaluator(Configuration configuration, OntologyRepository ontologyRepository) {
        this.configuration = configuration;
        this.ontologyRepository = ontologyRepository;
        this.executorService = Executors.newFixedThreadPool(configuration.getInt(CONFIGURATION_PARAMETER_MAX_THREADS, 1));
    }

    public void close() {
        this.executorService.shutdown();
    }

    public String evaluateTitleFormula(VertexiumObject vertexiumObject, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Title", vertexiumObject, null, null, userContext, authorizations);
    }

    public String evaluateTimeFormula(VertexiumObject vertexiumObject, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Time", vertexiumObject, null, null, userContext, authorizations);
    }

    public String evaluateSubtitleFormula(VertexiumObject vertexiumObject, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Subtitle", vertexiumObject, null, null, userContext, authorizations);
    }

    public String evaluatePropertyDisplayFormula(VertexiumObject vertexiumObject, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
        return this.evaluateFormula("Property", vertexiumObject, propertyKey, propertyName, userContext, authorizations);
    }

    private String evaluateFormula(String type, VertexiumObject vertexiumObject, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
        FormulaEvaluatorCallable evaluationCallable = new FormulaEvaluatorCallable(type, vertexiumObject, propertyKey, propertyName, userContext, authorizations);
        try {
            return this.executorService.submit(evaluationCallable).get();
        }
        catch (InterruptedException e) {
            LOGGER.error(type + " evaluation interrupted", e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Error encountered during " + type + " evaluation", e);
        }
        return "Unable to Evaluate " + type;
    }

    public Scriptable getScriptable(UserContext userContext) {
        String mapKey;
        Map<String, Scriptable> scopes = threadLocalScope.get();
        Scriptable scope = scopes.get(mapKey = userContext.locale.toString() + userContext.timeZone);
        if (scope == null) {
            scope = this.setupContext(this.getOntologyJson(userContext.getWorkspaceId()), this.getConfigurationJson(userContext.locale, userContext.getWorkspaceId()), userContext.timeZone);
            scopes.put(mapKey, scope);
        } else {
            scope.put("ONTOLOGY_JSON", scope, (Object)Context.toObject((Object)this.getOntologyJson(userContext.getWorkspaceId()), (Scriptable)scope));
        }
        return scope;
    }

    private Scriptable setupContext(String ontologyJson, String configurationJson, String timeZone) {
        Context context = Context.enter();
        context.setLanguageVersion(180);
        context.setOptimizationLevel(-1);
        RequireJsSupport browserSupport = new RequireJsSupport();
        ScriptableObject scope = context.initStandardObjects((ScriptableObject)browserSupport, true);
        try {
            scope.put("ONTOLOGY_JSON", (Scriptable)scope, (Object)Context.toObject((Object)ontologyJson, (Scriptable)scope));
            scope.put("CONFIG_JSON", (Scriptable)scope, (Object)Context.toObject((Object)configurationJson, (Scriptable)scope));
            scope.put("USERS_TIMEZONE", (Scriptable)scope, (Object)Context.toObject((Object)timeZone, (Scriptable)scope));
        }
        catch (Exception e) {
            throw new VisalloException("Json resource not available", e);
        }
        String[] names = new String[]{"print", "load", "consoleWarn", "consoleError", "readFully"};
        browserSupport.defineFunctionProperties(names, scope.getClass(), 2);
        Scriptable argsObj = context.newArray((Scriptable)scope, new Object[0]);
        scope.defineProperty("arguments", (Object)argsObj, 2);
        this.loadJavaScript(scope);
        return scope;
    }

    private void loadJavaScript(ScriptableObject scope) {
        this.evaluateFile(scope, "../libs/underscore.js");
        this.evaluateFile(scope, "../libs/r.js");
        this.evaluateFile(scope, "../libs/windowTimers.js");
        this.evaluateFile(scope, "loader.js");
    }

    protected String getOntologyJson(String workspaceId) {
        ClientApiOntology result = this.ontologyRepository.getClientApiObject(workspaceId);
        try {
            return ObjectMapperFactory.getInstance().writeValueAsString((Object)result);
        }
        catch (JsonProcessingException ex) {
            throw new VisalloException("Could not evaluate JSON: " + result, ex);
        }
    }

    protected String getConfigurationJson(Locale locale, String workspaceId) {
        return this.configuration.toJSON(locale, workspaceId).toString();
    }

    private void evaluateFile(ScriptableObject scope, String filename) {
        String transformed = RequireJsSupport.transformFilePath(filename);
        try (InputStream is = FormulaEvaluator.class.getResourceAsStream(transformed);){
            if (is == null) {
                throw new VisalloException("File not found " + transformed);
            }
            Context.getCurrentContext().evaluateString((Scriptable)scope, IOUtils.toString((InputStream)is), transformed, 0, null);
        }
        catch (JavaScriptException ex) {
            throw new VisalloException("JavaScript error in " + transformed, ex);
        }
        catch (IOException ex) {
            throw new VisalloException("Could not read file: " + transformed, ex);
        }
    }

    protected String toJson(VertexiumObject vertexiumObject, String workspaceId, Authorizations authorizations) {
        ClientApiVertexiumObject v = ClientApiConverter.toClientApi(vertexiumObject, workspaceId, authorizations);
        return v.toString();
    }

    private class FormulaEvaluatorCallable
    implements Callable<String> {
        private final String propertyKey;
        private final String propertyName;
        private UserContext userContext;
        private String fieldName;
        private VertexiumObject vertexiumObject;
        private Authorizations authorizations;

        public FormulaEvaluatorCallable(String fieldName, VertexiumObject vertexiumObject, String propertyKey, String propertyName, UserContext userContext, Authorizations authorizations) {
            this.fieldName = fieldName;
            this.vertexiumObject = vertexiumObject;
            this.propertyKey = propertyKey;
            this.propertyName = propertyName;
            this.userContext = userContext;
            this.authorizations = authorizations;
        }

        @Override
        public String call() throws Exception {
            Scriptable scope = FormulaEvaluator.this.getScriptable(this.userContext);
            Context context = Context.getCurrentContext();
            String json = FormulaEvaluator.this.toJson(this.vertexiumObject, this.userContext.getWorkspaceId(), this.authorizations);
            Object func = scope.get("evaluate" + this.fieldName + "FormulaJson", scope);
            if (func.equals(Scriptable.NOT_FOUND)) {
                throw new VisalloException("formula function not found");
            }
            if (func instanceof Function) {
                Function function = (Function)func;
                Object result = function.call(context, scope, scope, new Object[]{json, this.propertyKey, this.propertyName});
                return (String)Context.jsToJava((Object)result, String.class);
            }
            throw new VisalloException("Unknown result from formula");
        }
    }

    public static class UserContext {
        private final Locale locale;
        private final String timeZone;
        private final String workspaceId;
        private final ResourceBundle resourceBundle;

        public UserContext(Locale locale, ResourceBundle resourceBundle, String timeZone, String workspaceId) {
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.resourceBundle = resourceBundle;
            this.timeZone = timeZone;
            this.workspaceId = workspaceId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ResourceBundle getResourceBundle() {
            return this.resourceBundle;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getWorkspaceId() {
            return this.workspaceId;
        }
    }
}

