/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.cloud;

import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.FileImport;
import org.visallo.core.ingest.cloud.CloudImportLongRunningProcessQueueItem;
import org.visallo.core.ingest.cloud.CloudResourceSource;
import org.visallo.core.ingest.cloud.CloudResourceSourceItem;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.longRunningProcess.LongRunningProcessWorker;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.JSONUtil;
import org.visallo.web.clientapi.model.ClientApiImportProperty;

@Singleton
public class CloudImportLongRunningProcessWorker
extends LongRunningProcessWorker {
    private final Configuration configuration;
    private final FileImport fileImport;
    private final Graph graph;
    private final UserRepository userRepository;
    private final WorkspaceRepository workspaceRepository;
    private final LongRunningProcessRepository longRunningProcessRepository;

    @Inject
    public CloudImportLongRunningProcessWorker(Graph graph, Configuration configuration, FileImport fileImport, UserRepository userRepository, WorkspaceRepository workspaceRepository, LongRunningProcessRepository longRunningProcessRepository) {
        this.graph = graph;
        this.configuration = configuration;
        this.fileImport = fileImport;
        this.userRepository = userRepository;
        this.workspaceRepository = workspaceRepository;
        this.longRunningProcessRepository = longRunningProcessRepository;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return longRunningProcessQueueItem.getString("type").equals("org-visallo-ingest-cloud");
    }

    @Override
    protected void processInternal(JSONObject longRunningProcessQueueItem) {
        CloudImportLongRunningProcessQueueItem item = (CloudImportLongRunningProcessQueueItem)ClientApiConverter.toClientApi((JSONObject)longRunningProcessQueueItem, CloudImportLongRunningProcessQueueItem.class);
        CloudResourceSource destination = this.getDestination(item.getDestination());
        if (destination == null) {
            longRunningProcessQueueItem.put("error", (Object)("No cloud destination configured for :" + item.getDestination()));
        } else {
            try {
                this.download(destination, item, longRunningProcessQueueItem);
            }
            catch (Exception e) {
                throw new VisalloException("Unable to download from cloud destination", e);
            }
        }
    }

    private CloudResourceSource getDestination(String className) {
        Collection<CloudResourceSource> destinations = InjectHelper.getInjectedServices(CloudResourceSource.class, this.configuration);
        for (CloudResourceSource destination : destinations) {
            if (!destination.getClass().getName().equals(className)) continue;
            return destination;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(CloudResourceSource destination, CloudImportLongRunningProcessQueueItem item, JSONObject itemJson) throws Exception {
        String id = itemJson.getString("id");
        Authorizations authorizations = this.graph.createAuthorizations(item.getAuthorizations());
        String visibilitySource = "";
        User user = this.userRepository.findById(item.getUserId());
        String conceptId = null;
        Priority priority = Priority.NORMAL;
        Workspace workspace = this.workspaceRepository.findById(item.getWorkspaceId(), user);
        ClientApiImportProperty[] properties = null;
        boolean queueDefaults = false;
        boolean findExistingByFileHash = true;
        File tempDir = Files.createTempDir();
        try {
            Collection<CloudResourceSourceItem> items = destination.getItems(new JSONObject(item.getConfiguration()));
            Long allItemsSize = 0L;
            itemJson.put("itemsCount", items.size());
            for (CloudResourceSourceItem cloudResourceSourceItem : items) {
                Long size = cloudResourceSourceItem.getSize();
                if (size == null) continue;
                allItemsSize = allItemsSize + size;
            }
            long noSizeProgress = 0L;
            long cumulativeSize = 0L;
            for (CloudResourceSourceItem cloudResourceSourceItem : items) {
                String fileName = cloudResourceSourceItem.getName();
                if (fileName == null) {
                    throw new VisalloException("Cloud destination item name must not be null");
                }
                File file = new File(tempDir, cloudResourceSourceItem.getName());
                InputStream inputStream = cloudResourceSourceItem.getInputStream();
                Throwable throwable = null;
                try {
                    if (inputStream == null) {
                        throw new VisalloException("Cloud destination input stream must not be null");
                    }
                    noSizeProgress = (long)((double)noSizeProgress + 1.0 / (double)items.size());
                    if (this.downloadFile(id, inputStream, file, cumulativeSize, allItemsSize, noSizeProgress)) {
                        Vertex vertex = this.fileImport.importFile(file, file.getName(), queueDefaults, conceptId, properties, visibilitySource, workspace, findExistingByFileHash, priority, user, authorizations);
                        JSONArray vertexIds = JSONUtil.getOrCreateJSONArray(itemJson, "vertexIds");
                        vertexIds.put((Object)vertex.getId());
                    }
                    if (allItemsSize <= 0L) continue;
                    cumulativeSize += cloudResourceSourceItem.getSize().longValue();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        finally {
            this.longRunningProcessRepository.reportProgress(id, 1.0, "Finishing");
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFile(final String longRunningProcessId, InputStream inputStream, final File file, final Long cumulativeSize, final Long allItemSize, double noSizeProgress) throws Exception {
        final FileOutputStream out = new FileOutputStream(file);
        boolean success = false;
        try {
            ByteStreams.readBytes((InputStream)inputStream, (ByteProcessor)new ByteProcessor<Object>(){
                private long progress;
                private long flushProgress;
                {
                    this.progress = cumulativeSize;
                    this.flushProgress = 0L;
                }

                public boolean processBytes(byte[] buffer, int offset, int length) throws IOException {
                    out.write(buffer, offset, length);
                    if (allItemSize > 0L) {
                        this.progress += (long)length;
                        this.flushProgress += (long)length;
                        if ((double)this.flushProgress / (double)allItemSize.longValue() > 0.01) {
                            CloudImportLongRunningProcessWorker.this.longRunningProcessRepository.reportProgress(longRunningProcessId, (double)this.progress / (double)allItemSize.longValue(), String.format("Downloading %s", file.getName()));
                            this.flushProgress = 0L;
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
            success = true;
            if (allItemSize.equals(0)) {
                this.longRunningProcessRepository.reportProgress(longRunningProcessId, noSizeProgress, "Downloading");
            }
            Closeables.close((Closeable)out, (!success ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            if (allItemSize.equals(0)) {
                this.longRunningProcessRepository.reportProgress(longRunningProcessId, noSizeProgress, "Downloading");
            }
            Closeables.close((Closeable)out, (!success ? 1 : 0) != 0);
            throw throwable;
        }
        return success;
    }
}

