/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.ingest.graphProperty.GraphPropertyMessage;
import org.visallo.core.ingest.graphProperty.GraphPropertyThreadedWrapper;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerInitializer;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerItem;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerPrepareData;
import org.visallo.core.ingest.graphProperty.TermMentionFilter;
import org.visallo.core.ingest.graphProperty.TermMentionFilterPrepareData;
import org.visallo.core.ingest.graphProperty.VerifyResults;
import org.visallo.core.model.WorkQueueNames;
import org.visallo.core.model.WorkerBase;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.user.User;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.TeeInputStream;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class GraphPropertyRunner
extends WorkerBase<GraphPropertyWorkerItem> {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyRunner.class);
    private final AuthorizationRepository authorizationRepository;
    private Graph graph;
    private Authorizations authorizations;
    private List<GraphPropertyThreadedWrapper> workerWrappers = Lists.newArrayList();
    private User user;
    private UserRepository userRepository;
    private WorkQueueNames workQueueNames;
    private Configuration configuration;
    private VisibilityTranslator visibilityTranslator;
    private AtomicLong lastProcessedPropertyTime = new AtomicLong(0L);
    private List<GraphPropertyWorker> graphPropertyWorkers = Lists.newArrayList();
    private boolean prepareWorkersCalled;

    @Inject
    protected GraphPropertyRunner(WorkQueueRepository workQueueRepository, Configuration configuration, MetricsManager metricsManager, AuthorizationRepository authorizationRepository) {
        super(workQueueRepository, configuration, metricsManager);
        this.authorizationRepository = authorizationRepository;
    }

    @Override
    protected GraphPropertyWorkerItem tupleDataToWorkerItem(byte[] data) {
        GraphPropertyMessage message = GraphPropertyMessage.create(data);
        return new GraphPropertyWorkerItem(message, this.getElements(message));
    }

    @Override
    public void process(GraphPropertyWorkerItem workerItem) throws Exception {
        GraphPropertyMessage message = workerItem.getMessage();
        if (message.getProperties() != null && message.getProperties().length > 0) {
            this.safeExecuteHandlePropertiesOnElements(workerItem);
        } else if (message.getPropertyName() != null) {
            this.safeExecuteHandlePropertyOnElements(workerItem);
        } else {
            this.safeExecuteHandleAllEntireElements(workerItem);
        }
    }

    public void prepare(User user) {
        this.prepare(user, new GraphPropertyWorkerInitializer());
    }

    public void prepare(User user, GraphPropertyWorkerInitializer repository) {
        this.setUser(user);
        this.setAuthorizations(this.authorizationRepository.getGraphAuthorizations(user, new String[0]));
        this.prepareWorkers(repository);
        this.getWorkQueueRepository().setGraphPropertyRunner(this);
    }

    public void prepareWorkers(GraphPropertyWorkerInitializer initializer) {
        if (this.prepareWorkersCalled) {
            throw new VisalloException("prepareWorkers should be called only once");
        }
        this.prepareWorkersCalled = true;
        List<TermMentionFilter> termMentionFilters = this.loadTermMentionFilters();
        GraphPropertyWorkerPrepareData workerPrepareData = new GraphPropertyWorkerPrepareData(this.configuration.toMap(), termMentionFilters, this.user, this.authorizations, InjectHelper.getInjector());
        Collection<GraphPropertyWorker> workers = InjectHelper.getInjectedServices(GraphPropertyWorker.class, this.configuration);
        for (GraphPropertyWorker worker : workers) {
            try {
                LOGGER.debug("verifying: %s", worker.getClass().getName());
                VerifyResults verifyResults = worker.verify();
                if (verifyResults != null && verifyResults.getFailures().size() > 0) {
                    LOGGER.error("graph property worker %s had errors verifying", worker.getClass().getName());
                    for (VerifyResults.Failure failure : verifyResults.getFailures()) {
                        LOGGER.error("  %s", failure.getMessage());
                    }
                }
                if (initializer == null) continue;
                initializer.initialize(worker);
            }
            catch (Exception ex) {
                LOGGER.error("Could not verify graph property worker %s", worker.getClass().getName(), ex);
            }
        }
        boolean failedToPrepareAtLeastOneGraphPropertyWorker = false;
        ArrayList wrappers = Lists.newArrayList();
        for (GraphPropertyWorker worker : workers) {
            try {
                LOGGER.debug("preparing: %s", worker.getClass().getName());
                worker.prepare(workerPrepareData);
            }
            catch (Exception ex) {
                LOGGER.error("Could not prepare graph property worker %s", worker.getClass().getName(), ex);
                failedToPrepareAtLeastOneGraphPropertyWorker = true;
            }
            GraphPropertyThreadedWrapper wrapper = new GraphPropertyThreadedWrapper(worker);
            InjectHelper.inject(wrapper);
            wrappers.add(wrapper);
            Thread thread = new Thread(wrapper);
            String workerName = worker.getClass().getName();
            thread.setName("graphPropertyWorker-" + workerName);
            thread.start();
        }
        this.addGraphPropertyThreadedWrappers(wrappers);
        this.graphPropertyWorkers.addAll(workers);
        if (failedToPrepareAtLeastOneGraphPropertyWorker) {
            throw new VisalloException("Failed to initialize at least one graph property worker. See the log for more details.");
        }
    }

    public void addGraphPropertyThreadedWrappers(List<GraphPropertyThreadedWrapper> wrappers) {
        this.workerWrappers.addAll(wrappers);
    }

    public void addGraphPropertyThreadedWrappers(GraphPropertyThreadedWrapper ... wrappers) {
        this.workerWrappers.addAll(Lists.newArrayList((Object[])wrappers));
    }

    private List<TermMentionFilter> loadTermMentionFilters() {
        TermMentionFilterPrepareData termMentionFilterPrepareData = new TermMentionFilterPrepareData(this.configuration.toMap(), this.user, this.authorizations, InjectHelper.getInjector());
        List termMentionFilters = IterableUtils.toList(ServiceLoaderUtil.load(TermMentionFilter.class, this.configuration));
        for (TermMentionFilter termMentionFilter : termMentionFilters) {
            try {
                termMentionFilter.prepare(termMentionFilterPrepareData);
            }
            catch (Exception ex) {
                throw new VisalloException("Could not initialize term mention filter: " + termMentionFilter.getClass().getName(), ex);
            }
        }
        return termMentionFilters;
    }

    private void safeExecuteHandleAllEntireElements(GraphPropertyWorkerItem workerItem) throws Exception {
        for (Element element : workerItem.getElements()) {
            this.safeExecuteHandleEntireElement(element, workerItem.getMessage());
        }
    }

    private void safeExecuteHandleEntireElement(Element element, GraphPropertyMessage message) throws Exception {
        this.safeExecuteHandlePropertyOnElement(element, null, message);
        for (Property property : element.getProperties()) {
            this.safeExecuteHandlePropertyOnElement(element, property, message);
        }
    }

    private ImmutableList<Element> getVerticesFromMessage(GraphPropertyMessage message) {
        ImmutableList.Builder vertices = ImmutableList.builder();
        for (String vertexId : message.getGraphVertexId()) {
            Vertex vertex = message.getStatus() == ElementOrPropertyStatus.DELETION || message.getStatus() == ElementOrPropertyStatus.HIDDEN ? this.graph.getVertex(vertexId, FetchHint.ALL, message.getBeforeActionTimestamp(), this.authorizations) : this.graph.getVertex(vertexId, this.authorizations);
            if (this.doesExist((Element)vertex)) {
                vertices.add((Object)vertex);
                continue;
            }
            LOGGER.warn("Could not find vertex with id %s", vertexId);
        }
        return vertices.build();
    }

    private ImmutableList<Element> getEdgesFromMessage(GraphPropertyMessage message) {
        ImmutableList.Builder edges = ImmutableList.builder();
        for (String edgeId : message.getGraphEdgeId()) {
            Edge edge = message.getStatus() == ElementOrPropertyStatus.DELETION || message.getStatus() == ElementOrPropertyStatus.HIDDEN ? this.graph.getEdge(edgeId, FetchHint.ALL, message.getBeforeActionTimestamp(), this.authorizations) : this.graph.getEdge(edgeId, this.authorizations);
            if (this.doesExist((Element)edge)) {
                edges.add((Object)edge);
                continue;
            }
            LOGGER.warn("Could not find edge with id %s", edgeId);
        }
        return edges.build();
    }

    private boolean doesExist(Element element) {
        return element != null;
    }

    private void safeExecuteHandlePropertiesOnElements(GraphPropertyWorkerItem workerItem) throws Exception {
        GraphPropertyMessage message = workerItem.getMessage();
        for (Element element : workerItem.getElements()) {
            for (GraphPropertyMessage.Property propertyMessage : message.getProperties()) {
                Property property = null;
                String propertyKey = propertyMessage.getPropertyKey();
                String propertyName = propertyMessage.getPropertyName();
                if ((StringUtils.isNotEmpty((String)propertyKey) || StringUtils.isNotEmpty((String)propertyName)) && (property = propertyKey == null ? element.getProperty(propertyName) : element.getProperty(propertyKey, propertyName)) == null) {
                    LOGGER.error("Could not find property [%s]:[%s] on vertex with id %s", propertyKey, propertyName, element.getId());
                    continue;
                }
                this.safeExecuteHandlePropertyOnElement(element, property, message.getWorkspaceId(), message.getVisibilitySource(), message.getPriority(), message.isTraceEnabled(), propertyMessage.getStatus(), propertyMessage.getBeforeActionTimestampOrDefault());
            }
        }
    }

    private void safeExecuteHandlePropertyOnElements(GraphPropertyWorkerItem workerItem) throws Exception {
        GraphPropertyMessage message = workerItem.getMessage();
        for (Element element : workerItem.getElements()) {
            Property property = this.getProperty(element, message);
            if (property != null) {
                this.safeExecuteHandlePropertyOnElement(element, property, message);
                continue;
            }
            LOGGER.error("Could not find property [%s]:[%s] on vertex with id %s", message.getPropertyKey(), message.getPropertyName(), element.getId());
        }
    }

    private Property getProperty(Element element, GraphPropertyMessage message) {
        if (message.getPropertyName() == null) {
            return null;
        }
        Iterable properties = message.getPropertyKey() == null ? element.getProperties(message.getPropertyName()) : element.getProperties(message.getPropertyKey(), message.getPropertyName());
        Property result = null;
        for (Property property : properties) {
            if (message.getWorkspaceId() != null && property.getVisibility().hasAuthorization(message.getWorkspaceId())) {
                result = property;
                continue;
            }
            if (result != null) continue;
            result = property;
        }
        return result;
    }

    private void safeExecuteHandlePropertyOnElement(Element element, Property property, GraphPropertyMessage message) throws Exception {
        this.safeExecuteHandlePropertyOnElement(element, property, message.getWorkspaceId(), message.getVisibilitySource(), message.getPriority(), message.isTraceEnabled(), message.getStatus(), message.getBeforeActionTimestampOrDefault());
    }

    private void safeExecuteHandlePropertyOnElement(Element element, Property property, String workspaceId, String visibilitySource, Priority priority, boolean traceEnabled, ElementOrPropertyStatus status, long beforeActionTimestamp) throws Exception {
        String propertyText = this.getPropertyText(property);
        List<GraphPropertyThreadedWrapper> interestedWorkerWrappers = this.findInterestedWorkers(element, property, status);
        if (interestedWorkerWrappers.size() == 0) {
            LOGGER.debug("Could not find interested workers for %s %s property %s (%s)", new Object[]{element instanceof Vertex ? "vertex" : "edge", element.getId(), propertyText, status});
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
                LOGGER.debug("interested worker for %s %s property %s: %s (%s)", new Object[]{element instanceof Vertex ? "vertex" : "edge", element.getId(), propertyText, interestedWorkerWrapper.getWorker().getClass().getName(), status});
            }
        }
        GraphPropertyWorkData workData = new GraphPropertyWorkData(this.visibilityTranslator, element, property, workspaceId, visibilitySource, priority, traceEnabled, beforeActionTimestamp, status);
        LOGGER.debug("Begin work on element %s property %s", element.getId(), propertyText);
        if (property != null && property.getValue() instanceof StreamingPropertyValue) {
            StreamingPropertyValue spb = (StreamingPropertyValue)property.getValue();
            this.safeExecuteStreamingPropertyValue(interestedWorkerWrappers, workData, spb);
        } else {
            this.safeExecuteNonStreamingProperty(interestedWorkerWrappers, workData);
        }
        this.lastProcessedPropertyTime.set(System.currentTimeMillis());
        this.graph.flush();
        LOGGER.debug("Completed work on %s", propertyText);
    }

    private String getPropertyText(Property property) {
        return property == null ? "[none]" : property.getKey() + ":" + property.getName();
    }

    private void safeExecuteNonStreamingProperty(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers, GraphPropertyWorkData workData) throws Exception {
        for (GraphPropertyThreadedWrapper interestedWorkerWrapper1 : interestedWorkerWrappers) {
            interestedWorkerWrapper1.enqueueWork(null, workData);
        }
        for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
            interestedWorkerWrapper.dequeueResult(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void safeExecuteStreamingPropertyValue(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers, GraphPropertyWorkData workData, StreamingPropertyValue streamingPropertyValue) throws Exception {
        String[] workerNames = this.graphPropertyThreadedWrapperToNames(interestedWorkerWrappers);
        InputStream in = streamingPropertyValue.getInputStream();
        File tempFile = null;
        try {
            boolean requiresLocalFile = this.isLocalFileRequired(interestedWorkerWrappers);
            if (requiresLocalFile) {
                tempFile = this.copyToTempFile(in, workData);
                in = new FileInputStream(tempFile);
            }
            TeeInputStream teeInputStream = new TeeInputStream(in, workerNames);
            for (int i = 0; i < interestedWorkerWrappers.size(); ++i) {
                interestedWorkerWrappers.get(i).enqueueWork(teeInputStream.getTees()[i], workData);
            }
            teeInputStream.loopUntilTeesAreClosed();
            for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
                interestedWorkerWrapper.dequeueResult(false);
            }
            if (tempFile == null || tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tempFile == null || tempFile.delete()) throw throwable;
            LOGGER.warn("Could not delete temp file %s", tempFile.getAbsolutePath());
            throw throwable;
        }
        LOGGER.warn("Could not delete temp file %s", tempFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToTempFile(InputStream in, GraphPropertyWorkData workData) throws IOException {
        String fileExt = null;
        String fileName = (String)VisalloProperties.FILE_NAME.getOnlyPropertyValue(workData.getElement());
        if (fileName != null) {
            fileExt = FilenameUtils.getExtension((String)fileName);
        }
        if (fileExt == null) {
            fileExt = "data";
        }
        File tempFile = File.createTempFile("graphPropertyBolt", fileExt);
        workData.setLocalFile(tempFile);
        try (FileOutputStream tempFileOut = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)tempFileOut);
        }
        finally {
            in.close();
        }
        return tempFile;
    }

    private boolean isLocalFileRequired(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers) {
        for (GraphPropertyThreadedWrapper worker : interestedWorkerWrappers) {
            if (!worker.getWorker().isLocalFileRequired()) continue;
            return true;
        }
        return false;
    }

    private List<GraphPropertyThreadedWrapper> findInterestedWorkers(Element element, Property property, ElementOrPropertyStatus status) {
        Set graphPropertyWorkerWhiteList = IterableUtils.toSet(VisalloProperties.GRAPH_PROPERTY_WORKER_WHITE_LIST.getPropertyValues(element));
        Set graphPropertyWorkerBlackList = IterableUtils.toSet(VisalloProperties.GRAPH_PROPERTY_WORKER_BLACK_LIST.getPropertyValues(element));
        ArrayList<GraphPropertyThreadedWrapper> interestedWorkers = new ArrayList<GraphPropertyThreadedWrapper>();
        for (GraphPropertyThreadedWrapper wrapper : this.workerWrappers) {
            String graphPropertyWorkerName = wrapper.getWorker().getClass().getName();
            if (graphPropertyWorkerWhiteList.size() > 0 && !graphPropertyWorkerWhiteList.contains(graphPropertyWorkerName) || graphPropertyWorkerBlackList.contains(graphPropertyWorkerName)) continue;
            GraphPropertyWorker worker = wrapper.getWorker();
            if (status == ElementOrPropertyStatus.DELETION) {
                this.addDeletedWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (status == ElementOrPropertyStatus.HIDDEN) {
                this.addHiddenWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (status == ElementOrPropertyStatus.UNHIDDEN) {
                this.addUnhiddenWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (!worker.isHandled(element, property)) continue;
            interestedWorkers.add(wrapper);
        }
        return interestedWorkers;
    }

    private void addDeletedWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isDeleteHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private void addHiddenWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isHiddenHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private void addUnhiddenWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isUnhiddenHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private String[] graphPropertyThreadedWrapperToNames(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers) {
        String[] names = new String[interestedWorkerWrappers.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = interestedWorkerWrappers.get(i).getWorker().getClass().getName();
        }
        return names;
    }

    private ImmutableList<Element> getElements(GraphPropertyMessage message) {
        ImmutableList.Builder results = ImmutableList.builder();
        if (message.getGraphVertexId() != null && message.getGraphVertexId().length > 0) {
            results.addAll(this.getVerticesFromMessage(message));
        }
        if (message.getGraphEdgeId() != null && message.getGraphEdgeId().length > 0) {
            results.addAll(this.getEdgesFromMessage(message));
        }
        return results.build();
    }

    public void shutdown() {
        for (GraphPropertyThreadedWrapper wrapper : this.workerWrappers) {
            wrapper.stop();
        }
        super.stop();
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Inject
    public void setWorkQueueNames(WorkQueueNames workQueueNames) {
        this.workQueueNames = workQueueNames;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setVisibilityTranslator(VisibilityTranslator visibilityTranslator) {
        this.visibilityTranslator = visibilityTranslator;
    }

    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    public long getLastProcessedTime() {
        return this.lastProcessedPropertyTime.get();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    protected String getQueueName() {
        return this.workQueueNames.getGraphPropertyQueueName();
    }

    public boolean isStarted() {
        return this.shouldRun();
    }

    public boolean canHandle(Element element, Property property, ElementOrPropertyStatus status) {
        if (!this.isStarted()) {
            return true;
        }
        for (GraphPropertyWorker worker : this.getAllGraphPropertyWorkers()) {
            try {
                if (status == ElementOrPropertyStatus.DELETION && worker.isDeleteHandled(element, property)) {
                    return true;
                }
                if (status == ElementOrPropertyStatus.HIDDEN && worker.isHiddenHandled(element, property)) {
                    return true;
                }
                if (status == ElementOrPropertyStatus.UNHIDDEN && worker.isUnhiddenHandled(element, property)) {
                    return true;
                }
                if (!worker.isHandled(element, property)) continue;
                return true;
            }
            catch (Throwable t) {
                LOGGER.warn("Error checking to see if workers will handle graph property message.  Queueing anyways in case there was just a local error", t);
                return true;
            }
        }
        if (property == null) {
            LOGGER.debug("No interested workers for %s so did not queue it", element.getId());
        } else {
            LOGGER.debug("No interested workers for %s %s %s so did not queue it", element.getId(), property.getKey(), property.getValue());
        }
        return false;
    }

    public boolean canHandle(Element element, String propertyKey, String propertyName, ElementOrPropertyStatus status) {
        if (!this.isStarted()) {
            return true;
        }
        Property property = element.getProperty(propertyKey, propertyName);
        return this.canHandle(element, property, status);
    }

    private Collection<GraphPropertyWorker> getAllGraphPropertyWorkers() {
        return Lists.newArrayList(this.graphPropertyWorkers);
    }

    public static List<StoppableRunnable> startThreaded(int threadCount, final User user) {
        ArrayList<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();
        LOGGER.info("Starting GraphPropertyRunners on %d threads", threadCount);
        for (int i = 0; i < threadCount; ++i) {
            StoppableRunnable stoppable = new StoppableRunnable(){
                private GraphPropertyRunner graphPropertyRunner = null;

                @Override
                public void run() {
                    try {
                        this.graphPropertyRunner = InjectHelper.getInstance(GraphPropertyRunner.class);
                        this.graphPropertyRunner.prepare(user);
                        this.graphPropertyRunner.run();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed running GraphPropertyRunner", ex);
                    }
                }

                @Override
                public void stop() {
                    try {
                        if (this.graphPropertyRunner != null) {
                            LOGGER.debug("Stopping GraphPropertyRunner", new Object[0]);
                            this.graphPropertyRunner.stop();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed stopping GraphPropertyRunner", ex);
                    }
                }
            };
            stoppables.add(stoppable);
            Thread t = new Thread(stoppable);
            t.setName("graph-property-runner-" + t.getId());
            t.setDaemon(true);
            LOGGER.debug("Starting GraphPropertyRunner thread: %s", t.getName());
            t.start();
        }
        return stoppables;
    }
}

