/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.ElementBuilder;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.VisibilityJson;

public class GraphPropertyWorkData {
    private final VisibilityTranslator visibilityTranslator;
    private final Element element;
    private final Property property;
    private final String workspaceId;
    private final String visibilitySource;
    private final Priority priority;
    private final boolean traceEnabled;
    private File localFile;
    private long beforeActionTimestamp;
    private ElementOrPropertyStatus status;

    public GraphPropertyWorkData(VisibilityTranslator visibilityTranslator, Element element, Property property, String workspaceId, String visibilitySource, Priority priority, boolean traceEnabled) {
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        this.visibilityTranslator = visibilityTranslator;
        this.element = element;
        this.property = property;
        this.workspaceId = workspaceId;
        this.visibilitySource = visibilitySource;
        this.priority = priority;
        this.traceEnabled = traceEnabled;
    }

    public GraphPropertyWorkData(VisibilityTranslator visibilityTranslator, Element element, Property property, String workspaceId, String visibilitySource, Priority priority, boolean traceEnabled, long beforeActionTimestamp, ElementOrPropertyStatus status) {
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        this.visibilityTranslator = visibilityTranslator;
        this.element = element;
        this.property = property;
        this.workspaceId = workspaceId;
        this.visibilitySource = visibilitySource;
        this.priority = priority;
        this.beforeActionTimestamp = beforeActionTimestamp;
        this.status = status;
        this.traceEnabled = traceEnabled;
    }

    public Element getElement() {
        return this.element;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public Visibility getVisibility() {
        return this.getElement().getVisibility();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getVisibilitySource() {
        return this.visibilitySource;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getBeforeActionTimestamp() {
        return this.beforeActionTimestamp;
    }

    public ElementOrPropertyStatus getPropertyStatus() {
        return this.status;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public VisibilityJson getVisibilitySourceJson() {
        if (this.getVisibilitySource() == null || this.getVisibilitySource().length() == 0) {
            return new VisibilityJson();
        }
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.setSource(this.getVisibilitySource());
        return visibilityJson;
    }

    @Deprecated
    public VisibilityJson getVisibilityJson() {
        return this.getElementVisibilityJson();
    }

    public VisibilityJson getElementVisibilityJson() {
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(this.getElement());
        if (visibilityJson != null) {
            return visibilityJson;
        }
        return this.getVisibilitySourceJson();
    }

    public VisibilityJson getPropertyVisibilityJson() {
        VisibilityJson propertyVisibilityJson;
        if (this.property != null && (propertyVisibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(this.property)) != null) {
            return propertyVisibilityJson;
        }
        return this.getElementVisibilityJson();
    }

    public Metadata createPropertyMetadata(User user) {
        Metadata metadata = new Metadata();
        VisibilityJson visibilityJson = this.getPropertyVisibilityJson();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        if (visibilityJson != null) {
            VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, defaultVisibility);
        }
        VisalloProperties.MODIFIED_DATE_METADATA.setMetadata(metadata, new Date(), defaultVisibility);
        VisalloProperties.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), defaultVisibility);
        return metadata;
    }

    public void setVisibilityJsonOnElement(ElementBuilder builder) {
        VisibilityJson visibilityJson = this.getElementVisibilityJson();
        if (visibilityJson != null) {
            VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation<?>)builder, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        }
    }

    public void setVisibilityJsonOnElement(Element element, Authorizations authorizations) {
        VisibilityJson visibilityJson = this.getVisibilitySourceJson();
        if (visibilityJson != null) {
            VisalloProperties.VISIBILITY_JSON.setProperty(element, visibilityJson, this.visibilityTranslator.getDefaultVisibility(), authorizations);
        }
    }

    public String toString() {
        return "GraphPropertyWorkData{element=" + this.element + ", property=" + this.property + ", workspaceId='" + this.workspaceId + '\'' + ", priority=" + (Object)((Object)this.priority) + ", traceEnabled=" + this.traceEnabled + ", status=" + (Object)((Object)this.status) + '}';
    }
}

