/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model;

import com.codahale.metrics.Counter;
import java.util.LinkedList;
import java.util.Queue;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.WorkerSpout;
import org.visallo.core.ingest.WorkerTuple;
import org.visallo.core.ingest.graphProperty.WorkerItem;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class WorkerBase<TWorkerItem extends WorkerItem> {
    private final boolean exitOnNextTupleFailure;
    private final Counter queueSizeMetric;
    private final MetricsManager metricsManager;
    private final String queueSizeMetricName;
    private WorkQueueRepository workQueueRepository;
    private volatile boolean shouldRun;
    private final Queue<WorkerItemWrapper> tupleQueue = new LinkedList<WorkerItemWrapper>();
    private final int tupleQueueSize;
    private Thread processThread;

    protected WorkerBase(WorkQueueRepository workQueueRepository, Configuration configuration, MetricsManager metricsManager) {
        this.workQueueRepository = workQueueRepository;
        this.metricsManager = metricsManager;
        this.exitOnNextTupleFailure = configuration.getBoolean(this.getClass().getName() + ".exitOnNextTupleFailure", true);
        this.tupleQueueSize = configuration.getInt(this.getClass().getName() + ".tupleQueueSize", 10);
        this.queueSizeMetricName = metricsManager.createMetricName(this, "counter", "queue-size-" + Thread.currentThread().getId());
        this.queueSizeMetric = metricsManager.counter(this.queueSizeMetricName);
    }

    protected void finalize() throws Throwable {
        this.metricsManager.removeMetric(this.queueSizeMetricName);
        super.finalize();
    }

    public void run() throws Exception {
        VisalloLogger logger = VisalloLoggerFactory.getLogger(this.getClass());
        logger.debug("begin runner", new Object[0]);
        WorkerSpout workerSpout = this.prepareWorkerSpout();
        this.shouldRun = true;
        this.startProcessThread(logger, workerSpout);
        this.pollWorkerSpout(logger, workerSpout);
    }

    private void startProcessThread(VisalloLogger logger, WorkerSpout workerSpout) {
        this.processThread = new Thread(() -> {
            while (this.shouldRun) {
                WorkerItemWrapper workerItemWrapper = null;
                try {
                    Queue<WorkerItemWrapper> queue = this.tupleQueue;
                    synchronized (queue) {
                        while (true) {
                            if (this.shouldRun && this.tupleQueue.size() == 0) {
                                this.tupleQueue.wait();
                                continue;
                            }
                            if (!this.shouldRun) {
                                return;
                            }
                            if (this.tupleQueue.size() > 0) {
                                workerItemWrapper = this.tupleQueue.remove();
                                this.queueSizeMetric.dec();
                                this.tupleQueue.notifyAll();
                            }
                            if (!this.shouldRun || workerItemWrapper != null) break;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new VisalloException("Could not get next workerItem", ex);
                }
                if (!this.shouldRun) {
                    return;
                }
                try {
                    logger.debug("start processing", new Object[0]);
                    long startTime = System.currentTimeMillis();
                    this.process(workerItemWrapper.getWorkerItem());
                    long endTime = System.currentTimeMillis();
                    logger.debug("completed processing in (%dms)", endTime - startTime);
                    workerSpout.ack(workerItemWrapper.getWorkerTuple());
                }
                catch (Throwable ex) {
                    logger.error("Could not process tuple: %s", workerItemWrapper, ex);
                    workerSpout.fail(workerItemWrapper.getWorkerTuple());
                }
            }
        });
        this.processThread.setName(Thread.currentThread().getName() + "-process");
        this.processThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWorkerSpout(VisalloLogger logger, WorkerSpout workerSpout) throws InterruptedException {
        while (this.shouldRun) {
            WorkerItemWrapper workerItemWrapper;
            WorkerTuple tuple = null;
            try {
                tuple = workerSpout.nextTuple();
                if (tuple == null) {
                    workerItemWrapper = null;
                } else {
                    TWorkerItem workerItem = this.tupleDataToWorkerItem(tuple.getData());
                    workerItemWrapper = new WorkerItemWrapper(this, workerItem, tuple);
                }
            }
            catch (InterruptedException ex) {
                if (tuple != null) {
                    workerSpout.fail(tuple);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (tuple != null) {
                    workerSpout.fail(tuple);
                }
                this.handleNextTupleException(logger, ex);
                continue;
            }
            if (workerItemWrapper == null) continue;
            Queue<WorkerItemWrapper> queue = this.tupleQueue;
            synchronized (queue) {
                this.tupleQueue.add(workerItemWrapper);
                this.queueSizeMetric.inc();
                this.tupleQueue.notifyAll();
                while (this.shouldRun && this.tupleQueue.size() >= this.tupleQueueSize) {
                    this.tupleQueue.wait();
                }
            }
        }
    }

    protected void handleNextTupleException(VisalloLogger logger, Exception ex) throws InterruptedException {
        if (this.exitOnNextTupleFailure) {
            throw new VisalloException("Failed to get next tuple", ex);
        }
        logger.error("Failed to get next tuple", ex);
        Thread.sleep(10000L);
    }

    protected abstract void process(TWorkerItem var1) throws Exception;

    protected abstract TWorkerItem tupleDataToWorkerItem(byte[] var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.shouldRun = false;
        Queue<WorkerItemWrapper> queue = this.tupleQueue;
        synchronized (queue) {
            this.tupleQueue.notifyAll();
        }
        try {
            if (this.processThread != null) {
                this.processThread.join(10000L);
            }
        }
        catch (InterruptedException e) {
            throw new VisalloException("Could not stop process thread: " + this.processThread.getName());
        }
    }

    protected WorkerSpout prepareWorkerSpout() {
        WorkerSpout spout = this.workQueueRepository.createWorkerSpout(this.getQueueName());
        spout.open();
        return spout;
    }

    protected abstract String getQueueName();

    protected WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    public boolean shouldRun() {
        return this.shouldRun;
    }

    private static class WorkerItemWrapper {
        private final TWorkerItem workerItem;
        private final WorkerTuple workerTuple;
        final /* synthetic */ WorkerBase this$0;

        public WorkerItemWrapper(TWorkerItem workerItem, WorkerTuple workerTuple) {
            this.this$0 = var1_1;
            this.workerItem = workerItem;
            this.workerTuple = workerTuple;
        }

        public WorkerTuple getWorkerTuple() {
            return this.workerTuple;
        }

        public Object getMessageId() {
            return this.workerTuple.getMessageId();
        }

        public TWorkerItem getWorkerItem() {
            return this.workerItem;
        }

        public String toString() {
            return "WorkerItemWrapper{messageId=" + this.getMessageId() + ", workerItem=" + this.workerItem + '}';
        }
    }
}

