/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.directory;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.DirectoryEntity;
import org.visallo.web.clientapi.model.DirectoryGroup;
import org.visallo.web.clientapi.model.DirectoryPerson;

@Singleton
public class UserRepositoryDirectoryRepository
extends DirectoryRepository {
    private final UserRepository userRepository;

    @Inject
    public UserRepositoryDirectoryRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public List<DirectoryPerson> searchPeople(String search, User user) {
        ArrayList<DirectoryPerson> results = new ArrayList<DirectoryPerson>();
        Iterable<User> users = this.userRepository.find(search);
        for (User u : users) {
            results.add(this.userToDirectoryPerson(u));
        }
        return results;
    }

    private DirectoryPerson userToDirectoryPerson(User u) {
        if (u == null) {
            return null;
        }
        return new DirectoryPerson(u.getUserId(), u.getUsername());
    }

    @Override
    public List<DirectoryGroup> searchGroups(String search, User user) {
        return Collections.emptyList();
    }

    @Override
    public DirectoryEntity findById(String id, User user) {
        return this.userToDirectoryPerson(this.userRepository.findById(id));
    }

    @Override
    public String getDirectoryEntityId(User user) {
        return user.getUserId();
    }

    @Override
    public List<DirectoryPerson> findAllPeopleInGroup(DirectoryGroup group) {
        return Collections.emptyList();
    }
}

