/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.graph;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.graph.ElementUpdateContext;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.VisibilityJson;

public abstract class GraphUpdateContext
implements AutoCloseable {
    private static final int DEFAULT_SAVE_QUEUE_SIZE = 1000;
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final VisibilityTranslator visibilityTranslator;
    private final Priority priority;
    private final User user;
    private final Authorizations authorizations;
    private final Queue<UpdateFuture<? extends Element>> outstandingFutures = new LinkedList<UpdateFuture<? extends Element>>();
    private int saveQueueSize = 1000;
    private boolean pushOnQueue = true;

    protected GraphUpdateContext(Graph graph, WorkQueueRepository workQueueRepository, VisibilityTranslator visibilityTranslator, Priority priority, User user, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)graph, (Object)"graph cannot be null");
        Preconditions.checkNotNull((Object)workQueueRepository, (Object)"workQueueRepository cannot be null");
        Preconditions.checkNotNull((Object)visibilityTranslator, (Object)"visibilityTranslator cannot be null");
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"user cannot be null");
        Preconditions.checkNotNull((Object)authorizations, (Object)"authorizations cannot be null");
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.visibilityTranslator = visibilityTranslator;
        this.priority = priority;
        this.user = user;
        this.authorizations = authorizations;
    }

    @Override
    public void close() {
        this.flushFutures();
    }

    public void flush() {
        this.flushFutures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushFutures() {
        Queue<UpdateFuture<? extends Element>> queue = this.outstandingFutures;
        synchronized (queue) {
            this.saveOutstandingUpdateFutures();
            this.graph.flush();
            if (this.isPushOnQueue()) {
                this.pushOutstandingUpdateFutures();
            }
            this.outstandingFutures.clear();
        }
    }

    private void pushOutstandingUpdateFutures() {
        this.outstandingFutures.forEach(f -> {
            try {
                this.workQueueRepository.pushGraphVisalloPropertyQueue((Element)f.get(), (Iterable<VisalloPropertyUpdate>)f.getElementUpdateContext().getProperties(), this.priority);
            }
            catch (Exception ex) {
                throw new VisalloException("Could not push on queue", ex);
            }
        });
    }

    protected void saveOutstandingUpdateFutures() {
        List futures = this.outstandingFutures.stream().filter(f -> !f.isDone()).collect(Collectors.toList());
        List mutations = futures.stream().map(f -> f.getElementUpdateContext().getMutation()).collect(Collectors.toList());
        Iterable results = this.graph.saveElementMutations(mutations, this.authorizations);
        int i = 0;
        for (Element result : results) {
            UpdateFuture future = (UpdateFuture)futures.get(i);
            future.setElement(result);
            ++i;
        }
    }

    public <T extends Element> UpdateFuture<T> update(T element, Update<T> updateFn) {
        Date modifiedDate = null;
        VisibilityJson visibilityJson = null;
        String conceptType = null;
        return this.update(element, modifiedDate, visibilityJson, conceptType, updateFn);
    }

    public <T extends Element> UpdateFuture<T> update(T element, Date modifiedDate, VisibilityJson visibilityJson, Update<T> updateFn) {
        String conceptType = null;
        return this.update(element, modifiedDate, visibilityJson, conceptType, updateFn);
    }

    public <T extends Element> UpdateFuture<T> update(T element, Date modifiedDate, VisibilityJson visibilityJson, String conceptType, Update<T> updateFn) {
        Preconditions.checkNotNull(element, (Object)"element cannot be null");
        return this.update((ElementMutation<T>)element.prepareMutation(), modifiedDate, visibilityJson, conceptType, updateFn);
    }

    public <T extends Element> UpdateFuture<T> update(ElementMutation<T> m, Update<T> updateFn) {
        Date modifiedDate = null;
        VisibilityJson visibilityJson = null;
        String conceptType = null;
        return this.update(m, modifiedDate, visibilityJson, conceptType, updateFn);
    }

    public <T extends Element> UpdateFuture<T> update(ElementMutation<T> m, Date modifiedDate, VisibilityJson visibilityJson, Update<T> updateFn) {
        String conceptType = null;
        return this.update(m, modifiedDate, visibilityJson, conceptType, updateFn);
    }

    public <T extends Element> UpdateFuture<T> update(ElementMutation<T> m, Date modifiedDate, VisibilityJson visibilityJson, String conceptType, Update<T> updateFn) {
        Preconditions.checkNotNull(m, (Object)"element cannot be null");
        Preconditions.checkNotNull(updateFn, (Object)"updateFn cannot be null");
        ElementUpdateContext<T> elementUpdateContext = new ElementUpdateContext<T>(this.visibilityTranslator, m, this.user);
        if (modifiedDate != null || visibilityJson != null) {
            elementUpdateContext.updateBuiltInProperties(modifiedDate, visibilityJson);
        }
        if (conceptType != null) {
            elementUpdateContext.setConceptType(conceptType);
        }
        try {
            updateFn.update(elementUpdateContext);
        }
        catch (Exception ex) {
            throw new VisalloException("Could not update element", ex);
        }
        UpdateFuture<T> future = new UpdateFuture<T>(elementUpdateContext);
        this.addToOutstandingFutures(future);
        return future;
    }

    public UpdateFuture<Vertex> getOrCreateVertexAndUpdate(String vertexId, Visibility visibility, Update<Vertex> updateFn) {
        return this.getOrCreateVertexAndUpdate(vertexId, null, visibility, updateFn);
    }

    public UpdateFuture<Vertex> getOrCreateVertexAndUpdate(String vertexId, Long timestamp, Visibility visibility, Update<Vertex> updateFn) {
        Vertex existingVertex = vertexId == null ? null : this.graph.getVertex(vertexId, this.getAuthorizations());
        ExistingElementMutation m = existingVertex == null ? this.graph.prepareVertex(vertexId, timestamp, visibility) : existingVertex.prepareMutation();
        return this.update((ElementMutation)m, (Update)updateFn);
    }

    public UpdateFuture<Edge> getOrCreateEdgeAndUpdate(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility, Update<Edge> updateFn) {
        return this.getOrCreateEdgeAndUpdate(edgeId, outVertexId, inVertexId, label, null, visibility, updateFn);
    }

    public UpdateFuture<Edge> getOrCreateEdgeAndUpdate(String edgeId, String outVertexId, String inVertexId, String label, Long timestamp, Visibility visibility, Update<Edge> updateFn) {
        Edge existingEdge = edgeId == null ? null : this.graph.getEdge(edgeId, this.getAuthorizations());
        ExistingEdgeMutation m = existingEdge == null ? this.graph.prepareEdge(edgeId, outVertexId, inVertexId, label, timestamp, visibility) : existingEdge.prepareMutation();
        return this.update((ElementMutation)m, (Update)updateFn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Element> void addToOutstandingFutures(UpdateFuture<T> future) {
        Queue<UpdateFuture<? extends Element>> queue = this.outstandingFutures;
        synchronized (queue) {
            this.outstandingFutures.add(future);
            if (this.outstandingFutures.size() > this.saveQueueSize) {
                this.flushFutures();
            }
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    public User getUser() {
        return this.user;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public int getSaveQueueSize() {
        return this.saveQueueSize;
    }

    public GraphUpdateContext setSaveQueueSize(int saveQueueSize) {
        this.saveQueueSize = saveQueueSize;
        return this;
    }

    public boolean isPushOnQueue() {
        return this.pushOnQueue;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public GraphUpdateContext setPushOnQueue(boolean pushOnQueue) {
        this.pushOnQueue = pushOnQueue;
        return this;
    }

    public class UpdateFuture<T extends Element>
    implements Future<T> {
        private final ElementUpdateContext<T> elementUpdateContext;
        private T element;

        public UpdateFuture(ElementUpdateContext<T> elementUpdateContext) {
            this.elementUpdateContext = elementUpdateContext;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new VisalloException("Not supported");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.element != null;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.element == null) {
                this.element = this.elementUpdateContext.getMutation().save(GraphUpdateContext.this.authorizations);
            }
            return this.element;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        protected ElementUpdateContext<T> getElementUpdateContext() {
            return this.elementUpdateContext;
        }

        protected void setElement(T element) {
            this.element = element;
        }
    }

    public static interface Update<T extends Element> {
        public void update(ElementUpdateContext<T> var1) throws Exception;
    }
}

