/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.visallo.core.model.lock.LeaderListener;
import org.visallo.core.model.lock.Lock;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class LockRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(LockRepository.class);
    protected final Map<String, Object> synchronizationObjects = new HashMap<String, Object>();

    public void lock(String lockName, Runnable runnable) {
        this.lock(lockName, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T lock(String lockName, Callable<T> callable) {
        T t;
        LOGGER.debug("[thread: %s] acquiring lock: %s", Thread.currentThread().getName(), lockName);
        try {
            Object synchronizationObject;
            Object object = synchronizationObject = this.getSynchronizationObject(lockName);
            synchronized (object) {
                LOGGER.debug("[thread: %s] creating lock: %s", Thread.currentThread().getName(), lockName);
                Lock lock = this.createLock(lockName);
                LOGGER.debug("[thread: %s] running lock: %s", Thread.currentThread().getName(), lockName);
                t = lock.run(callable);
            }
        }
        catch (Throwable throwable) {
            LOGGER.debug("[thread: %s] released lock: %s", Thread.currentThread().getName(), lockName);
            throw throwable;
        }
        LOGGER.debug("[thread: %s] released lock: %s", Thread.currentThread().getName(), lockName);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSynchronizationObject(String lockName) {
        Map<String, Object> map = this.synchronizationObjects;
        synchronized (map) {
            Object synchronizationObject = this.synchronizationObjects.get(lockName);
            if (synchronizationObject == null) {
                synchronizationObject = new Object();
                this.synchronizationObjects.put(lockName, synchronizationObject);
            }
            return synchronizationObject;
        }
    }

    public abstract Lock createLock(String var1);

    public abstract void leaderElection(String var1, LeaderListener var2);
}

