/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.lock;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.visallo.core.model.lock.LeaderListener;
import org.visallo.core.model.lock.Lock;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;

@Singleton
public class NonLockingLockRepository
extends LockRepository
implements ShutdownListener {
    private WeakHashMap<Long, Thread> threads = new WeakHashMap();

    @VisibleForTesting
    public NonLockingLockRepository() {
    }

    @Inject
    public NonLockingLockRepository(ShutdownService shutdownService) {
        shutdownService.register(this);
    }

    @Override
    public Lock createLock(String lockName) {
        return new Lock(lockName){

            @Override
            public <T> T run(Callable<T> callable) {
                try {
                    return callable.call();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to run in lock", ex);
                }
            }
        };
    }

    @Override
    public void leaderElection(String lockName, LeaderListener listener) {
        Thread t = new Thread(() -> {
            try {
                listener.isLeader();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        t.setName(NonLockingLockRepository.class.getSimpleName() + "-LeaderElection-" + lockName);
        t.setDaemon(true);
        t.start();
        this.threads.put(t.getId(), t);
    }

    @Override
    public void shutdown() {
        for (Thread thread : this.threads.values()) {
            thread.interrupt();
        }
    }
}

