/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.longRunningProcess;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import org.json.JSONObject;
import org.visallo.core.model.longRunningProcess.LongRunningWorkerPrepareData;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class LongRunningProcessWorker {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(LongRunningProcessWorker.class);
    private MetricsManager metricsManager;
    private Counter totalProcessedCounter;
    private Counter totalErrorCounter;
    private Counter processingCounter;
    private Timer processingTimeTimer;

    public void prepare(LongRunningWorkerPrepareData workerPrepareData) {
        this.totalProcessedCounter = this.getMetricsManager().counter(this, "total-processed");
        this.processingCounter = this.getMetricsManager().counter(this, "processing");
        this.totalErrorCounter = this.getMetricsManager().counter(this, "total-errors");
        this.processingTimeTimer = this.getMetricsManager().timer(this, "processing-time");
    }

    public abstract boolean isHandled(JSONObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(JSONObject longRunningProcessQueueItem) {
        try (Timer.Context t = this.processingTimeTimer.time();){
            this.processingCounter.inc();
            try {
                this.processInternal(longRunningProcessQueueItem);
            }
            finally {
                this.processingCounter.dec();
            }
            this.totalProcessedCounter.inc();
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to complete long running process: " + longRunningProcessQueueItem, ex);
            this.totalErrorCounter.inc();
            throw ex;
        }
    }

    protected abstract void processInternal(JSONObject var1);

    @Inject
    public final void setMetricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }
}

