/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.EnumSet;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphWithSearchIndex;
import org.vertexium.Range;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.Description;
import org.visallo.core.model.Name;
import org.visallo.core.model.longRunningProcess.LongRunningProcessWorker;
import org.visallo.core.model.longRunningProcess.ReindexLongRunningProcessQueueItem;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Name(value="Reindex")
@Description(value="Reindexes the specified elements")
@Singleton
public class ReindexLongRunningProcessWorker
extends LongRunningProcessWorker {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ReindexLongRunningProcessWorker.class);
    private static final EnumSet<FetchHint> FETCH_HINTS = FetchHint.ALL;
    private final Authorizations authorizations;
    private final Graph graph;

    @Inject
    public ReindexLongRunningProcessWorker(Graph graph, UserRepository userRepository, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.authorizations = authorizationRepository.getGraphAuthorizations(userRepository.getSystemUser(), new String[0]);
    }

    @Override
    public boolean isHandled(JSONObject jsonObject) {
        return ReindexLongRunningProcessQueueItem.isHandled(jsonObject);
    }

    @Override
    protected void processInternal(JSONObject longRunningProcessQueueItem) {
        ReindexLongRunningProcessQueueItem queueItem = (ReindexLongRunningProcessQueueItem)ClientApiConverter.toClientApi((String)longRunningProcessQueueItem.toString(), ReindexLongRunningProcessQueueItem.class);
        int batchSize = queueItem.getBatchSize();
        Range range = new Range(queueItem.getStartId(), queueItem.getEndId());
        LOGGER.info("reindex %s %s", range, queueItem.getElementType());
        if (queueItem.getElementType() == ElementType.VERTEX) {
            this.reindexVertices(range, batchSize, this.authorizations);
        } else if (queueItem.getElementType() == ElementType.EDGE) {
            this.reindexEdges(range, batchSize, this.authorizations);
        } else {
            throw new VisalloException("Unhandled element type: " + queueItem.getElementType());
        }
    }

    public void reindexVertices(Range range, int batchSize, Authorizations authorizations) {
        Iterable vertices = this.graph.getVerticesInRange(range, FETCH_HINTS, authorizations);
        this.reindexElements(vertices, batchSize, authorizations);
    }

    public void reindexEdges(Range range, int batchSize, Authorizations authorizations) {
        Iterable edges = this.graph.getEdgesInRange(range, FETCH_HINTS, authorizations);
        this.reindexElements(edges, batchSize, authorizations);
    }

    private void reindexElements(Iterable<? extends Element> elements, int batchSize, Authorizations authorizations) {
        ArrayList<Element> batch = new ArrayList<Element>(batchSize);
        for (Element element : elements) {
            batch.add(element);
            if (batch.size() != batchSize) continue;
            ((GraphWithSearchIndex)this.graph).getSearchIndex().addElements(this.graph, batch, authorizations);
            batch.clear();
        }
        if (batch.size() > 0) {
            ((GraphWithSearchIndex)this.graph).getSearchIndex().addElements(this.graph, batch, authorizations);
            batch.clear();
        }
    }
}

