/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.ExtendedDataTableProperty;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.util.StreamUtil;
import org.visallo.web.clientapi.model.SandboxStatus;

public class Ontology {
    private final String workspaceId;
    private final Map<String, Concept> conceptsByIri;
    private final Map<String, Relationship> relationshipsByIri;
    private final Map<String, ExtendedDataTableProperty> extendedDataTablesByIri;
    private final Map<String, OntologyProperty> propertiesByIri;

    public Ontology(Iterable<Concept> concepts, Iterable<Relationship> relationships, Iterable<ExtendedDataTableProperty> extendedDataTables, Map<String, OntologyProperty> propertiesByIri, String workspaceId) {
        this.workspaceId = workspaceId;
        HashMap propertyMap = new HashMap();
        this.conceptsByIri = Collections.unmodifiableMap(StreamUtil.stream(concepts).collect(Collectors.toMap(Concept::getIRI, concept -> {
            Collection<OntologyProperty> properties = concept.getProperties();
            if (properties != null && properties.size() > 0) {
                properties.forEach(property -> propertyMap.put(property.getIri(), property));
            }
            return concept;
        })));
        this.relationshipsByIri = Collections.unmodifiableMap(StreamUtil.stream(relationships).collect(Collectors.toMap(Relationship::getIRI, relationship -> {
            Collection<OntologyProperty> properties = relationship.getProperties();
            if (properties != null && properties.size() > 0) {
                properties.forEach(property -> propertyMap.put(property.getIri(), property));
            }
            return relationship;
        })));
        this.extendedDataTablesByIri = Collections.unmodifiableMap(StreamUtil.stream(extendedDataTables).collect(Collectors.toMap(ExtendedDataTableProperty::getIri, table -> {
            List<OntologyProperty> properties = StreamUtil.stream(new Iterable[]{table.getTablePropertyIris()}).map(propertiesByIri::get).collect(Collectors.toList());
            properties.forEach(property -> propertyMap.put(property.getIri(), property));
            return table;
        })));
        this.propertiesByIri = Collections.unmodifiableMap(propertyMap);
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public Collection<Concept> getConcepts() {
        return this.conceptsByIri.values();
    }

    public Map<String, Concept> getConceptsByIri() {
        return this.conceptsByIri;
    }

    public Concept getConceptByIri(String iri) {
        return this.conceptsByIri.get(iri);
    }

    public Collection<Relationship> getRelationships() {
        return this.relationshipsByIri.values();
    }

    public Map<String, Relationship> getRelationshipsByIri() {
        return this.relationshipsByIri;
    }

    public Relationship getRelationshipByIri(String iri) {
        return this.relationshipsByIri.get(iri);
    }

    public Collection<OntologyProperty> getProperties() {
        return this.propertiesByIri.values();
    }

    public Map<String, OntologyProperty> getPropertiesByIri() {
        return this.propertiesByIri;
    }

    public OntologyProperty getPropertyByIri(String iri) {
        return this.propertiesByIri.get(iri);
    }

    public Map<String, ExtendedDataTableProperty> getExtendedDataTablesByIri() {
        return this.extendedDataTablesByIri;
    }

    public SandboxStatus getSandboxStatus() {
        SandboxStatus sandboxStatus;
        for (Concept concept : this.getConcepts()) {
            sandboxStatus = concept.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        for (Relationship relationship : this.getRelationships()) {
            sandboxStatus = relationship.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        for (OntologyProperty property : this.getProperties()) {
            sandboxStatus = property.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        return SandboxStatus.PUBLIC;
    }
}

