/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoHash;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoShape;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.ExtendedDataTableProperty;
import org.visallo.core.model.properties.types.BooleanVisalloProperty;
import org.visallo.core.model.properties.types.DateVisalloProperty;
import org.visallo.core.model.properties.types.DoubleVisalloProperty;
import org.visallo.core.model.properties.types.GeoPointVisalloProperty;
import org.visallo.core.model.properties.types.GeoShapeVisalloProperty;
import org.visallo.core.model.properties.types.IntegerVisalloProperty;
import org.visallo.core.model.properties.types.StreamingVisalloProperty;
import org.visallo.core.model.properties.types.StringVisalloProperty;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.PropertyType;
import org.visallo.web.clientapi.model.SandboxStatus;

public abstract class OntologyProperty {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat DATE_TIME_WITH_SECONDS_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final Pattern GEO_LOCATION_FORMAT = Pattern.compile("POINT\\((.*?),(.*?)\\)", 2);
    public static final Pattern GEO_LOCATION_ALTERNATE_FORMAT = Pattern.compile("(.*?),(.*)", 2);

    public String getIri() {
        return this.getTitle();
    }

    public abstract String getId();

    public abstract SandboxStatus getSandboxStatus();

    public abstract String getTitle();

    public abstract String getDisplayName();

    public abstract boolean getUserVisible();

    public abstract boolean getSearchable();

    public abstract boolean getAddable();

    public abstract boolean getSortable();

    public abstract PropertyType getDataType();

    public abstract Double getBoost();

    public abstract Map<String, String> getPossibleValues();

    public abstract String getDisplayType();

    public abstract String getPropertyGroup();

    public abstract String getValidationFormula();

    public abstract String getDisplayFormula();

    public abstract boolean getUpdateable();

    public abstract boolean getDeleteable();

    public abstract ImmutableList<String> getDependentPropertyIris();

    public abstract String[] getIntents();

    public abstract String[] getTextIndexHints();

    public abstract void addTextIndexHints(String var1, Authorizations var2);

    public abstract void addIntent(String var1, Authorizations var2);

    public abstract void removeIntent(String var1, Authorizations var2);

    public abstract List<String> getConceptIris();

    public abstract List<String> getRelationshipIris();

    public abstract Integer getSortPriority();

    public void updateIntents(String[] newIntents, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public abstract void setProperty(String var1, Object var2, User var3, Authorizations var4);

    public static Collection<ClientApiOntology.Property> toClientApiProperties(Iterable<OntologyProperty> properties) {
        ArrayList<ClientApiOntology.Property> results = new ArrayList<ClientApiOntology.Property>();
        for (OntologyProperty property : properties) {
            results.add(property.toClientApi());
        }
        return results;
    }

    public abstract Map<String, String> getMetadata();

    public ClientApiOntology.Property toClientApi() {
        try {
            ClientApiOntology.ExtendedDataTableProperty result;
            if (this instanceof ExtendedDataTableProperty) {
                result = new ClientApiOntology.ExtendedDataTableProperty();
                ExtendedDataTableProperty edtp = (ExtendedDataTableProperty)((Object)this);
                ClientApiOntology.ExtendedDataTableProperty cedtp = result;
                cedtp.setTitleFormula(edtp.getTitleFormula());
                cedtp.setSubtitleFormula(edtp.getSubtitleFormula());
                cedtp.setTimeFormula(edtp.getTimeFormula());
                cedtp.setTablePropertyIris(edtp.getTablePropertyIris());
            } else {
                result = new ClientApiOntology.Property();
            }
            result.setTitle(this.getTitle());
            result.setDisplayName(this.getDisplayName());
            result.setUserVisible(this.getUserVisible());
            result.setSearchable(this.getSearchable());
            result.setAddable(this.getAddable());
            result.setSortable(this.getSortable());
            result.setDataType(this.getDataType());
            result.setDisplayType(this.getDisplayType());
            result.setPropertyGroup(this.getPropertyGroup());
            result.setValidationFormula(this.getValidationFormula());
            result.setDisplayFormula(this.getDisplayFormula());
            result.setDependentPropertyIris(this.getDependentPropertyIris());
            result.setDeleteable(this.getDeleteable());
            result.setUpdateable(this.getUpdateable());
            result.setSandboxStatus(this.getSandboxStatus());
            result.setSortPriority(this.getSortPriority());
            if (this.getPossibleValues() != null) {
                result.getPossibleValues().putAll(this.getPossibleValues());
            }
            if (this.getIntents() != null) {
                result.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            if (this.getTextIndexHints() != null) {
                result.getTextIndexHints().addAll(Arrays.asList(this.getTextIndexHints()));
            }
            for (Map.Entry<String, String> additionalProperty : this.getMetadata().entrySet()) {
                result.getMetadata().put(additionalProperty.getKey(), additionalProperty.getValue());
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convert(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        PropertyType dataType = this.getDataType();
        switch (dataType) {
            case DATE: {
                if (!(value instanceof Date)) break;
                return value;
            }
            case GEO_LOCATION: {
                if (!(value instanceof GeoPoint)) break;
                return value;
            }
            case GEO_SHAPE: {
                if (!(value instanceof GeoShape)) break;
                return value;
            }
            case CURRENCY: {
                if (!(value instanceof BigDecimal)) break;
                return value;
            }
            case DOUBLE: {
                if (!(value instanceof Double)) break;
                return value;
            }
            case INTEGER: {
                if (!(value instanceof Integer)) break;
                return value;
            }
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                return value;
            }
        }
        return this.convertString(value.toString());
    }

    public Object convertString(String valueStr) throws ParseException {
        PropertyType dataType = this.getDataType();
        Object value = valueStr;
        switch (dataType) {
            case DATE: {
                value = OntologyProperty.parseDateTime(valueStr);
                break;
            }
            case GEO_LOCATION: {
                value = OntologyProperty.parseGeoLocation(valueStr);
                break;
            }
            case CURRENCY: {
                value = new BigDecimal(valueStr);
                break;
            }
            case DOUBLE: {
                value = Double.parseDouble(valueStr);
                break;
            }
            case INTEGER: {
                value = Integer.parseInt(valueStr);
                break;
            }
            case BOOLEAN: {
                value = Boolean.parseBoolean(valueStr);
            }
        }
        return value;
    }

    public static Object convert(JSONArray values, PropertyType propertyDataType, int index) throws ParseException {
        switch (propertyDataType) {
            case DIRECTORY_ENTITY: {
                if (values.get(index) instanceof String) {
                    return values.get(index);
                }
                if (values.get(index) instanceof JSONObject) {
                    JSONObject json = values.getJSONObject(index);
                    String id = json.optString("id");
                    Preconditions.checkNotNull((Object)id, (Object)"id is a required field for directory entity json");
                    return id;
                }
                String valueStr = values.getString(index);
                try {
                    JSONObject json = new JSONObject(valueStr);
                    String id = json.optString("id");
                    Preconditions.checkNotNull((Object)id, (Object)"id is a required field for directory entity json");
                    return id;
                }
                catch (JSONException ex) {
                    return valueStr;
                }
            }
            case DATE: {
                String valueStr = values.getString(index);
                return OntologyProperty.parseDateTime(valueStr);
            }
            case GEO_LOCATION: {
                if (values.get(index) instanceof String) {
                    String valueStr = values.getString(index);
                    return new GeoHash(valueStr);
                }
                return new GeoCircle(values.getDouble(index), values.getDouble(index + 1), values.getDouble(index + 2));
            }
            case CURRENCY: {
                return new BigDecimal(values.getString(index));
            }
            case INTEGER: {
                return values.getInt(index);
            }
            case DOUBLE: {
                return values.getDouble(index);
            }
            case BOOLEAN: {
                Object result = values.get(index);
                if ("T".equals(result)) {
                    return true;
                }
                if ("F".equals(result)) {
                    return false;
                }
                return values.getBoolean(index);
            }
        }
        return values.getString(index);
    }

    protected static Object parseGeoLocation(String valueStr) {
        try {
            JSONObject json = new JSONObject(valueStr);
            double latitude = json.getDouble("latitude");
            double longitude = json.getDouble("longitude");
            String altitudeString = json.optString("altitude");
            Double altitude = altitudeString == null || altitudeString.length() == 0 ? null : Double.valueOf(Double.parseDouble(altitudeString));
            String description = json.optString("description");
            return new GeoPoint(latitude, longitude, altitude, description);
        }
        catch (Exception ex) {
            Matcher match = GEO_LOCATION_FORMAT.matcher(valueStr);
            if (match.find()) {
                double latitude = Double.parseDouble(match.group(1).trim());
                double longitude = Double.parseDouble(match.group(2).trim());
                return new GeoPoint(latitude, longitude);
            }
            match = GEO_LOCATION_ALTERNATE_FORMAT.matcher(valueStr);
            if (match.find()) {
                double latitude = Double.parseDouble(match.group(1).trim());
                double longitude = Double.parseDouble(match.group(2).trim());
                return new GeoPoint(latitude, longitude);
            }
            throw new VisalloException("Could not parse location: " + valueStr);
        }
    }

    public boolean hasDependentPropertyIris() {
        return this.getDependentPropertyIris() != null && this.getDependentPropertyIris().size() > 0;
    }

    private static Date parseDateTime(String valueStr) throws ParseException {
        try {
            return DATE_TIME_WITH_SECONDS_FORMAT.parse(valueStr);
        }
        catch (ParseException ex1) {
            try {
                return DATE_TIME_FORMAT.parse(valueStr);
            }
            catch (ParseException ex2) {
                try {
                    return DATE_FORMAT.parse(valueStr);
                }
                catch (ParseException ex3) {
                    return new Date(Long.parseLong(valueStr));
                }
            }
        }
    }

    public VisalloProperty getVisalloProperty() {
        switch (this.getDataType()) {
            case IMAGE: 
            case BINARY: {
                return new StreamingVisalloProperty(this.getIri());
            }
            case BOOLEAN: {
                return new BooleanVisalloProperty(this.getIri());
            }
            case DATE: {
                return new DateVisalloProperty(this.getIri());
            }
            case CURRENCY: 
            case DOUBLE: {
                return new DoubleVisalloProperty(this.getIri());
            }
            case GEO_LOCATION: {
                return new GeoPointVisalloProperty(this.getIri());
            }
            case GEO_SHAPE: {
                return new GeoShapeVisalloProperty(this.getIri());
            }
            case INTEGER: {
                return new IntegerVisalloProperty(this.getIri());
            }
            case DIRECTORY_ENTITY: 
            case STRING: {
                return new StringVisalloProperty(this.getIri());
            }
        }
        throw new VisalloException("Could not get " + VisalloProperty.class.getName() + " for data type " + this.getDataType());
    }

    public String toString() {
        return this.getClass().getName() + "{iri:" + this.getIri() + "}";
    }

    public int hashCode() {
        return this.getIri().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OntologyProperty)) {
            return false;
        }
        String otherIri = ((OntologyProperty)obj).getIri();
        return this.getIri().equals(otherIri);
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        DATE_FORMAT.setTimeZone(utc);
        DATE_TIME_FORMAT.setTimeZone(utc);
        DATE_TIME_WITH_SECONDS_FORMAT.setTimeZone(utc);
    }
}

