/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.vertexium.Authorizations;
import org.vertexium.query.Query;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.Ontology;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiOntology;

public interface OntologyRepository {
    public static final String ENTITY_CONCEPT_IRI = "http://www.w3.org/2002/07/owl#Thing";
    public static final String ROOT_CONCEPT_IRI = "http://visallo.org#root";
    public static final String TYPE_RELATIONSHIP = "relationship";
    public static final String TYPE_CONCEPT = "concept";
    public static final String TYPE_PROPERTY = "property";
    public static final String VISIBILITY_STRING = "ontology";
    public static final String CONFIG_INTENT_CONCEPT_PREFIX = "ontology.intent.concept.";
    public static final String CONFIG_INTENT_RELATIONSHIP_PREFIX = "ontology.intent.relationship.";
    public static final String CONFIG_INTENT_PROPERTY_PREFIX = "ontology.intent.property.";
    public static final String PUBLIC = "public-ontology";
    public static final VisalloVisibility VISIBILITY = new VisalloVisibility("ontology");

    public void clearCache();

    public void clearCache(String var1);

    @Deprecated
    public Iterable<Relationship> getRelationships();

    public Iterable<Relationship> getRelationships(String var1);

    public Iterable<Relationship> getRelationships(Iterable<String> var1, String var2);

    @Deprecated
    public Iterable<OntologyProperty> getProperties();

    public Iterable<OntologyProperty> getProperties(String var1);

    public Iterable<OntologyProperty> getProperties(Iterable<String> var1, String var2);

    @Deprecated
    public String getDisplayNameForLabel(String var1);

    public String getDisplayNameForLabel(String var1, String var2);

    @Deprecated
    public OntologyProperty getPropertyByIRI(String var1);

    public OntologyProperty getPropertyByIRI(String var1, String var2);

    public Iterable<OntologyProperty> getPropertiesByIRI(List<String> var1, String var2);

    @Deprecated
    public OntologyProperty getRequiredPropertyByIRI(String var1);

    public OntologyProperty getRequiredPropertyByIRI(String var1, String var2);

    @Deprecated
    public Relationship getRelationshipByIRI(String var1);

    public Relationship getRelationshipByIRI(String var1, String var2);

    public Iterable<Relationship> getRelationshipsByIRI(List<String> var1, String var2);

    @Deprecated
    public boolean hasRelationshipByIRI(String var1);

    public boolean hasRelationshipByIRI(String var1, String var2);

    @Deprecated
    public Iterable<Concept> getConceptsWithProperties();

    public Iterable<Concept> getConceptsWithProperties(String var1);

    public Concept getRootConcept(String var1);

    @Deprecated
    public Concept getEntityConcept();

    public Concept getEntityConcept(String var1);

    @Deprecated
    public Concept getParentConcept(Concept var1);

    public Concept getParentConcept(Concept var1, String var2);

    public Set<Concept> getAncestorConcepts(Concept var1, String var2);

    public Set<Concept> getConceptAndAncestors(Concept var1, String var2);

    @Deprecated
    public Concept getConceptByIRI(String var1);

    public Concept getConceptByIRI(String var1, String var2);

    public Iterable<Concept> getConceptsByIRI(List<String> var1, String var2);

    @Deprecated
    public Set<Concept> getConceptAndAllChildrenByIri(String var1);

    public Set<Concept> getConceptAndAllChildrenByIri(String var1, String var2);

    @Deprecated
    public Set<Concept> getConceptAndAllChildren(Concept var1);

    public Set<Concept> getConceptAndAllChildren(Concept var1, String var2);

    @Deprecated
    public Set<Relationship> getRelationshipAndAllChildren(Relationship var1);

    public Set<Relationship> getRelationshipAndAllChildren(Relationship var1, String var2);

    public Set<Relationship> getRelationshipAndAllChildrenByIRI(String var1, String var2);

    public Relationship getParentRelationship(Relationship var1, String var2);

    public Set<Relationship> getAncestorRelationships(Relationship var1, String var2);

    public Set<Relationship> getRelationshipAndAncestors(Relationship var1, String var2);

    public Iterable<Concept> getConcepts(Iterable<String> var1, String var2);

    public void deleteConcept(String var1, User var2, String var3);

    public void deleteProperty(String var1, User var2, String var3);

    public void deleteRelationship(String var1, User var2, String var3);

    @Deprecated
    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4, User var5, String var6);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, File var6, User var7, String var8);

    @Deprecated
    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4, boolean var5);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4, boolean var5, User var6, String var7);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, File var6, boolean var7, User var8, String var9);

    @Deprecated
    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4);

    @Deprecated
    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, boolean var5);

    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, boolean var5, User var6, String var7);

    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, String var5, boolean var6, User var7, String var8);

    public void addDomainConceptsToRelationshipType(String var1, List<String> var2, User var3, String var4);

    public void addRangeConceptsToRelationshipType(String var1, List<String> var2, User var3, String var4);

    @Deprecated
    public OntologyProperty getOrCreateProperty(OntologyPropertyDefinition var1);

    public OntologyProperty getOrCreateProperty(OntologyPropertyDefinition var1, User var2, String var3);

    public OWLOntologyManager createOwlOntologyManager(OWLOntologyLoaderConfiguration var1, IRI var2) throws Exception;

    @Deprecated
    public void resolvePropertyIds(JSONArray var1) throws JSONException;

    public void resolvePropertyIds(JSONArray var1, String var2) throws JSONException;

    public void importResourceOwl(Class var1, String var2, String var3, Authorizations var4);

    public void importFile(File var1, IRI var2, Authorizations var3) throws Exception;

    public void importFileData(byte[] var1, IRI var2, File var3, Authorizations var4) throws Exception;

    public void writePackage(File var1, IRI var2, Authorizations var3) throws Exception;

    @Deprecated
    public ClientApiOntology getClientApiObject();

    public ClientApiOntology getClientApiObject(String var1);

    public Ontology getOntology(String var1);

    public String guessDocumentIRIFromPackage(File var1) throws Exception;

    @Deprecated
    public Concept getConceptByIntent(String var1);

    public Concept getConceptByIntent(String var1, String var2);

    @Deprecated
    public String getConceptIRIByIntent(String var1);

    public String getConceptIRIByIntent(String var1, String var2);

    @Deprecated
    public Concept getRequiredConceptByIntent(String var1);

    public Concept getRequiredConceptByIntent(String var1, String var2);

    @Deprecated
    public Concept getRequiredConceptByIRI(String var1);

    public Concept getRequiredConceptByIRI(String var1, String var2);

    @Deprecated
    public String getRequiredConceptIRIByIntent(String var1);

    public String getRequiredConceptIRIByIntent(String var1, String var2);

    @Deprecated
    public Relationship getRelationshipByIntent(String var1);

    public Relationship getRelationshipByIntent(String var1, String var2);

    @Deprecated
    public String getRelationshipIRIByIntent(String var1);

    public String getRelationshipIRIByIntent(String var1, String var2);

    @Deprecated
    public Relationship getRequiredRelationshipByIntent(String var1);

    public Relationship getRequiredRelationshipByIntent(String var1, String var2);

    @Deprecated
    public String getRequiredRelationshipIRIByIntent(String var1);

    public String getRequiredRelationshipIRIByIntent(String var1, String var2);

    @Deprecated
    public OntologyProperty getPropertyByIntent(String var1);

    public OntologyProperty getPropertyByIntent(String var1, String var2);

    @Deprecated
    public String getPropertyIRIByIntent(String var1);

    public String getPropertyIRIByIntent(String var1, String var2);

    @Deprecated
    public <T extends VisalloProperty> T getVisalloPropertyByIntent(String var1, Class<T> var2);

    public <T extends VisalloProperty> T getVisalloPropertyByIntent(String var1, Class<T> var2, String var3);

    @Deprecated
    public <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String var1, Class<T> var2);

    public <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String var1, Class<T> var2, String var3);

    @Deprecated
    public List<OntologyProperty> getPropertiesByIntent(String var1);

    public List<OntologyProperty> getPropertiesByIntent(String var1, String var2);

    @Deprecated
    public OntologyProperty getRequiredPropertyByIntent(String var1);

    public OntologyProperty getRequiredPropertyByIntent(String var1, String var2);

    @Deprecated
    public String getRequiredPropertyIRIByIntent(String var1);

    public String getRequiredPropertyIRIByIntent(String var1, String var2);

    @Deprecated
    public boolean isOntologyDefined(String var1);

    @Deprecated
    public OntologyProperty getDependentPropertyParent(String var1);

    public OntologyProperty getDependentPropertyParent(String var1, String var2);

    @Deprecated
    public void addConceptTypeFilterToQuery(Query var1, String var2, boolean var3);

    public void addConceptTypeFilterToQuery(Query var1, String var2, boolean var3, String var4);

    @Deprecated
    public void addConceptTypeFilterToQuery(Query var1, Collection<ElementTypeFilter> var2);

    public void addConceptTypeFilterToQuery(Query var1, Collection<ElementTypeFilter> var2, String var3);

    @Deprecated
    public void addEdgeLabelFilterToQuery(Query var1, String var2, boolean var3);

    public void addEdgeLabelFilterToQuery(Query var1, String var2, boolean var3, String var4);

    @Deprecated
    public void addEdgeLabelFilterToQuery(Query var1, Collection<ElementTypeFilter> var2);

    public void addEdgeLabelFilterToQuery(Query var1, Collection<ElementTypeFilter> var2, String var3);

    @Deprecated
    public void updatePropertyDependentIris(OntologyProperty var1, Collection<String> var2);

    public void updatePropertyDependentIris(OntologyProperty var1, Collection<String> var2, User var3, String var4);

    @Deprecated
    public void updatePropertyDomainIris(OntologyProperty var1, Set<String> var2);

    public void updatePropertyDomainIris(OntologyProperty var1, Set<String> var2, User var3, String var4);

    public String generateDynamicIri(Class var1, String var2, String var3, String ... var4);

    public void publishConcept(Concept var1, User var2, String var3);

    public void publishRelationship(Relationship var1, User var2, String var3);

    public void publishProperty(OntologyProperty var1, User var2, String var3);

    public static class ElementTypeFilter
    implements ClientApiObject {
        public String iri;
        public boolean includeChildNodes;

        public ElementTypeFilter() {
        }

        public ElementTypeFilter(String iri, boolean includeChildNodes) {
            this.iri = iri;
            this.includeChildNodes = includeChildNodes;
        }
    }
}

