/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.vertexium.Authorizations;
import org.vertexium.DefinePropertyBuilder;
import org.vertexium.Graph;
import org.vertexium.PropertyDefinition;
import org.vertexium.TextIndexHint;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.Contains;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.util.CloseableUtils;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.cache.CacheOptions;
import org.visallo.core.cache.CacheService;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.ExtendedDataTableProperty;
import org.visallo.core.model.ontology.Ontology;
import org.visallo.core.model.ontology.OntologyElement;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.model.properties.types.VisalloPropertyBase;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.core.util.ExecutorServiceUtil;
import org.visallo.core.util.OWLOntologyUtil;
import org.visallo.core.util.StreamUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.PropertyType;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.UserType;
import org.visallo.web.clientapi.model.WorkspaceAccess;

public abstract class OntologyRepositoryBase
implements OntologyRepository {
    public static final String BASE_OWL_IRI = "http://visallo.org";
    public static final String COMMENT_OWL_IRI = "http://visallo.org/comment";
    public static final String RESOURCE_ENTITY_PNG = "entity.png";
    public static final String TOP_OBJECT_PROPERTY_IRI = "http://www.w3.org/2002/07/owl#topObjectProperty";
    public static final int MAX_DISPLAY_NAME = 50;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(OntologyRepositoryBase.class);
    private static final String ONTOLOGY_CACHE_NAME = OntologyRepository.class.getName() + ".ontology";
    private static final String CONFIG_ONTOLOGY_CACHE_MAX_SIZE = OntologyRepository.class.getName() + "ontologyCache.maxSize";
    private static final long CONFIG_ONTOLOGY_CACHE_MAX_SIZE_DEFAULT = 100L;
    private final Configuration configuration;
    private final LockRepository lockRepository;
    private final CacheService cacheService;
    private final CacheOptions ontologyCacheOptions;
    private WorkspaceRepository workspaceRepository;
    private PrivilegeRepository privilegeRepository;

    @Inject
    protected OntologyRepositoryBase(Configuration configuration, LockRepository lockRepository, CacheService cacheService) {
        this.configuration = configuration;
        this.lockRepository = lockRepository;
        this.cacheService = cacheService;
        this.ontologyCacheOptions = new CacheOptions().setMaximumSize(configuration.getLong(CONFIG_ONTOLOGY_CACHE_MAX_SIZE, 100L));
    }

    public void loadOntologies(Configuration config, Authorizations authorizations) throws Exception {
        this.lockRepository.lock("ontology", () -> {
            Concept rootConcept = this.internalGetOrCreateConcept(null, "http://visallo.org#root", "root", null, null, null, false, this.getSystemUser(), "public-ontology");
            Concept entityConcept = this.internalGetOrCreateConcept(rootConcept, "http://www.w3.org/2002/07/owl#Thing", "thing", null, null, null, false, this.getSystemUser(), "public-ontology");
            this.getOrCreateTopObjectPropertyRelationship(authorizations);
            this.clearCache();
            this.addEntityGlyphIcon(entityConcept, authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "base.owl", BASE_OWL_IRI, authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "user.owl", "http://visallo.org/user", authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "termMention.owl", "http://visallo.org/termMention", authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "workspace.owl", "http://visallo.org/workspace", authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "comment.owl", COMMENT_OWL_IRI, authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "search.owl", "http://visallo.org/search", authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "longRunningProcess.owl", "http://visallo.org/longRunningProcess", authorizations);
            this.importResourceOwl(OntologyRepositoryBase.class, "ping.owl", "http://visallo.org/ping", authorizations);
            for (Map.Entry<String, Map<String, String>> owlGroup : config.getMultiValue("repository.ontology.owl").entrySet()) {
                String iri = owlGroup.getValue().get("iri");
                String dir = owlGroup.getValue().get("dir");
                String file = owlGroup.getValue().get("file");
                if (iri == null) {
                    throw new VisalloException("iri is required for group repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir == null && file == null) {
                    throw new VisalloException("dir or file is required for repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir != null && file != null) {
                    throw new VisalloException("you cannot specify both dir and file for repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir != null) {
                    File owlFile = this.findOwlFile(new File(dir));
                    if (owlFile == null) {
                        throw new VisalloResourceNotFoundException("could not find owl file in directory " + new File(dir).getAbsolutePath());
                    }
                    this.importFile(owlFile, IRI.create((String)iri), authorizations);
                    continue;
                }
                this.writePackage(new File(file), IRI.create((String)iri), authorizations);
            }
            return true;
        });
    }

    private Relationship getOrCreateTopObjectPropertyRelationship(Authorizations authorizations) {
        User user = this.getSystemUser();
        Relationship topObjectProperty = this.internalGetOrCreateRelationshipType(null, Collections.emptyList(), Collections.emptyList(), TOP_OBJECT_PROPERTY_IRI, null, false, user, "public-ontology");
        if (topObjectProperty.getUserVisible()) {
            topObjectProperty.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), false, user, authorizations);
        }
        return topObjectProperty;
    }

    @Override
    public void importResourceOwl(Class baseClass, String fileName, String iri, Authorizations authorizations) {
        LOGGER.debug("importResourceOwl %s (iri: %s)", fileName, iri);
        InputStream owlFileIn = baseClass.getResourceAsStream(fileName);
        Preconditions.checkNotNull((Object)owlFileIn, (Object)("Could not load resource " + baseClass.getResource(fileName) + " [" + fileName + "]"));
        try {
            IRI documentIRI = IRI.create((String)iri);
            byte[] inFileData = IOUtils.toByteArray((InputStream)owlFileIn);
            try {
                this.importFileData(inFileData, documentIRI, null, authorizations);
            }
            catch (OWLOntologyAlreadyExistsException ex) {
                LOGGER.warn("Ontology was already defined but not stored: " + fileName + " (iri: " + iri + ")", ex);
                this.storeOntologyFile(new ByteArrayInputStream(inFileData), documentIRI, authorizations);
            }
        }
        catch (Exception ex) {
            throw new VisalloException("Could not import ontology file: " + fileName + " (iri: " + iri + ")", ex);
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)owlFileIn);
        }
    }

    private void addEntityGlyphIcon(Concept entityConcept, Authorizations authorizations) {
        if (entityConcept.getGlyphIcon() != null) {
            LOGGER.debug("entityConcept GlyphIcon already set. skipping addEntityGlyphIcon.", new Object[0]);
            return;
        }
        LOGGER.debug("addEntityGlyphIcon", new Object[0]);
        InputStream entityGlyphIconInputStream = OntologyRepositoryBase.class.getResourceAsStream(RESOURCE_ENTITY_PNG);
        Preconditions.checkNotNull((Object)entityGlyphIconInputStream, (Object)"Could not load resource entity.png");
        try {
            ByteArrayOutputStream imgOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)entityGlyphIconInputStream, (OutputStream)imgOut);
            byte[] rawImg = imgOut.toByteArray();
            this.addEntityGlyphIconToEntityConcept(entityConcept, rawImg, authorizations);
        }
        catch (IOException e) {
            throw new VisalloException("invalid stream for glyph icon");
        }
    }

    protected abstract void addEntityGlyphIconToEntityConcept(Concept var1, byte[] var2, Authorizations var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessDocumentIRIFromPackage(File file) throws IOException, ZipException {
        ZipFile zipped = new ZipFile(file);
        if (zipped.isValidZipFile()) {
            File tempDir = Files.createTempDir();
            try {
                LOGGER.info("Extracting: %s to %s", file.getAbsoluteFile(), tempDir.getAbsolutePath());
                zipped.extractAll(tempDir.getAbsolutePath());
                File owlFile = this.findOwlFile(tempDir);
                String string = this.guessDocumentIRIFromFile(owlFile);
                return string;
            }
            finally {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        if (file.isDirectory()) {
            file = this.findOwlFile(file);
        }
        return this.guessDocumentIRIFromFile(file);
    }

    private String guessDocumentIRIFromFile(File owlFile) throws IOException {
        try (FileInputStream owlFileIn = new FileInputStream(owlFile);){
            String owlContents = IOUtils.toString((InputStream)owlFileIn);
            Pattern iriRegex = Pattern.compile("<owl:Ontology rdf:about=\"(.*?)\">");
            Matcher m = iriRegex.matcher(owlContents);
            if (m.find()) {
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public void importFile(File inFile, IRI documentIRI, Authorizations authorizations) throws Exception {
        Preconditions.checkNotNull((Object)inFile, (Object)"inFile cannot be null");
        if (!inFile.exists()) {
            throw new VisalloException("File " + inFile + " does not exist");
        }
        File inDir = inFile.getParentFile();
        try (FileInputStream inFileIn = new FileInputStream(inFile);){
            LOGGER.debug("importing %s", inFile.getAbsolutePath());
            byte[] inFileData = IOUtils.toByteArray((InputStream)inFileIn);
            this.importFileData(inFileData, documentIRI, inDir, authorizations);
        }
    }

    @Override
    public void importFileData(byte[] inFileData, IRI documentIRI, File inDir, Authorizations authorizations) throws Exception {
        if (!this.hasFileChanged(documentIRI, inFileData)) {
            LOGGER.info("skipping %s, file has not changed", documentIRI);
            return;
        }
        InputStreamReader inFileReader = new InputStreamReader(new ByteArrayInputStream(inFileData));
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        OWLOntologyManager m = this.createOwlOntologyManager(config, documentIRI);
        ReaderDocumentSource documentSource = new ReaderDocumentSource((Reader)inFileReader, documentIRI);
        OWLOntology o = m.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)documentSource, config);
        long totalStartTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        this.importOntologyAnnotationProperties(o, inDir, authorizations);
        this.clearCache();
        long endTime = System.currentTimeMillis();
        long importAnnotationPropertiesTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importOntologyClasses(o, inDir, authorizations);
        this.clearCache();
        endTime = System.currentTimeMillis();
        long importConceptsTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importObjectProperties(o, authorizations);
        this.clearCache();
        endTime = System.currentTimeMillis();
        long importObjectPropertiesTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importInverseOfObjectProperties(o);
        endTime = System.currentTimeMillis();
        long importInverseOfObjectPropertiesTime = endTime - startTime;
        long totalEndTime = System.currentTimeMillis();
        startTime = System.currentTimeMillis();
        this.importDataProperties(o, authorizations);
        endTime = System.currentTimeMillis();
        long importDataPropertiesTime = endTime - startTime;
        LOGGER.debug("import annotation properties time: %dms", importAnnotationPropertiesTime);
        LOGGER.debug("import concepts time: %dms", importConceptsTime);
        LOGGER.debug("import data properties time: %dms", importDataPropertiesTime);
        LOGGER.debug("import object properties time: %dms", importObjectPropertiesTime);
        LOGGER.debug("import inverse of object properties time: %dms", importInverseOfObjectPropertiesTime);
        LOGGER.debug("import total time: %dms", totalEndTime - totalStartTime);
        this.storeOntologyFile(new ByteArrayInputStream(inFileData), documentIRI, authorizations);
        this.clearCache();
    }

    protected boolean hasFileChanged(IRI documentIRI, byte[] inFileData) {
        return true;
    }

    private void importInverseOfObjectProperties(OWLOntology o) {
        for (OWLObjectProperty objectProperty : o.getObjectPropertiesInSignature()) {
            if (!o.isDeclared((OWLEntity)objectProperty, Imports.EXCLUDED)) continue;
            this.importInverseOf(o, objectProperty);
        }
    }

    private void importObjectProperties(OWLOntology o, Authorizations authorizations) {
        for (OWLObjectProperty objectProperty : o.getObjectPropertiesInSignature()) {
            this.importObjectProperty(o, objectProperty, authorizations);
        }
    }

    private void importDataProperties(OWLOntology o, Authorizations authorizations) {
        boolean foundExtendedDataTable = false;
        block0: for (OWLDataProperty dataTypeProperty : o.getDataPropertiesInSignature()) {
            for (OWLDataRange rangeClassExpr : EntitySearcher.getRanges((OWLDataProperty)dataTypeProperty, (OWLOntology)o)) {
                String rangeIri = ((HasIRI)rangeClassExpr).getIRI().toString();
                if (!"http://visallo.org#extendedDataTable".equals(rangeIri)) continue;
                this.importDataProperty(o, dataTypeProperty, authorizations);
                foundExtendedDataTable = true;
                continue block0;
            }
        }
        if (foundExtendedDataTable) {
            this.clearCache();
        }
        for (OWLDataProperty dataTypeProperty : o.getDataPropertiesInSignature()) {
            this.importDataProperty(o, dataTypeProperty, authorizations);
        }
    }

    private void importOntologyAnnotationProperties(OWLOntology o, File inDir, Authorizations authorizations) {
        for (OWLAnnotationProperty annotation : o.getAnnotationPropertiesInSignature()) {
            this.importOntologyAnnotationProperty(o, annotation, inDir, authorizations);
        }
    }

    protected void importOntologyAnnotationProperty(OWLOntology o, OWLAnnotationProperty annotationProperty, File inDir, Authorizations authorizations) {
    }

    @Override
    @Deprecated
    public final void updatePropertyDependentIris(OntologyProperty property, Collection<String> dependentPropertyIris) {
        this.updatePropertyDependentIris(property, dependentPropertyIris, null, "public-ontology");
    }

    @Override
    @Deprecated
    public final void updatePropertyDomainIris(OntologyProperty property, Set<String> domainIris) {
        this.updatePropertyDomainIris(property, domainIris, null, "public-ontology");
    }

    private void importOntologyClasses(OWLOntology o, File inDir, Authorizations authorizations) throws IOException {
        for (OWLClass ontologyClass : o.getClassesInSignature()) {
            this.importOntologyClass(o, ontologyClass, inDir, authorizations);
        }
    }

    @Override
    public OWLOntologyManager createOwlOntologyManager(OWLOntologyLoaderConfiguration config, IRI excludeDocumentIRI) throws Exception {
        OWLOntologyManager m = OWLManager.createOWLOntologyManager();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.loadOntologyFiles(m, config, excludeDocumentIRI);
        return m;
    }

    protected abstract void storeOntologyFile(InputStream var1, IRI var2, Authorizations var3);

    protected abstract List<OWLOntology> loadOntologyFiles(OWLOntologyManager var1, OWLOntologyLoaderConfiguration var2, IRI var3) throws Exception;

    protected Concept importOntologyClass(OWLOntology o, OWLClass ontologyClass, File inDir, Authorizations authorizations) throws IOException {
        String uri = ontologyClass.getIRI().toString();
        if ("http://www.w3.org/2002/07/owl#Thing".equals(uri)) {
            return this.getEntityConcept("public-ontology");
        }
        String label = OWLOntologyUtil.getLabel(o, (OWLEntity)ontologyClass);
        Preconditions.checkNotNull((Object)label, (Object)("label cannot be null or empty: " + uri));
        LOGGER.info("Importing ontology class " + uri + " (label: " + label + ")", new Object[0]);
        boolean isDeclaredInOntology = o.isDeclared((OWLEntity)ontologyClass);
        Concept parent = this.getParentConcept(o, ontologyClass, inDir, authorizations);
        Concept result = this.internalGetOrCreateConcept(parent, uri, label, null, null, inDir, isDeclaredInOntology, this.getSystemUser(), "public-ontology");
        User user = this.getSystemUser();
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)ontologyClass, (OWLOntology)o)) {
            String annotationIri = annotation.getProperty().getIRI().toString();
            OWLLiteral valueLiteral = (OWLLiteral)annotation.getValue();
            String valueString = valueLiteral.getLiteral();
            if (annotationIri.equals(OntologyProperties.INTENT.getPropertyName())) {
                result.addIntent(valueString, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.SEARCHABLE.getPropertyName())) {
                boolean searchable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.SEARCHABLE.getPropertyName(), searchable, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.SORTABLE.getPropertyName())) {
                boolean sortable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.SORTABLE.getPropertyName(), sortable, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.SORT_PRIORITY.getPropertyName())) {
                if (valueString.trim().length() == 0) continue;
                Integer sortPriority = Integer.parseInt(valueString);
                result.setProperty(OntologyProperties.SORT_PRIORITY.getPropertyName(), sortPriority, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.ADDABLE.getPropertyName())) {
                boolean searchable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.ADDABLE.getPropertyName(), searchable, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.USER_VISIBLE.getPropertyName())) {
                boolean userVisible = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), userVisible, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.GLYPH_ICON_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.GLYPH_ICON.getPropertyName(), user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.GLYPH_ICON_SELECTED.getPropertyName(), user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.MAP_GLYPH_ICON_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.MAP_GLYPH_ICON.getPropertyName(), user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName())) {
                if (valueString.trim().length() == 0) continue;
                result.setProperty(OntologyProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName(), valueString.trim(), user, authorizations);
                continue;
            }
            if (annotationIri.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                result.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), valueString, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.UPDATEABLE.getPropertyName())) {
                boolean updateable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.UPDATEABLE.getPropertyName(), updateable, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.DELETEABLE.getPropertyName())) {
                boolean deleteable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.DELETEABLE.getPropertyName(), deleteable, user, authorizations);
                continue;
            }
            result.setProperty(annotationIri, valueString, user, authorizations);
        }
        return result;
    }

    protected void setIconProperty(Concept concept, File inDir, String glyphIconFileName, String propertyKey, User user, Authorizations authorizations) throws IOException {
        if (glyphIconFileName != null) {
            File iconFile = new File(inDir, glyphIconFileName);
            if (!iconFile.exists()) {
                throw new RuntimeException("Could not find icon file: " + iconFile.toString());
            }
            try (FileInputStream iconFileIn = new FileInputStream(iconFile);){
                StreamingPropertyValue value = new StreamingPropertyValue((InputStream)iconFileIn, byte[].class);
                value.searchIndex(false);
                value.store(true);
                concept.setProperty(propertyKey, value, user, authorizations);
            }
        }
    }

    protected Concept getParentConcept(OWLOntology o, OWLClass ontologyClass, File inDir, Authorizations authorizations) throws IOException {
        Collection superClasses = EntitySearcher.getSuperClasses((OWLClass)ontologyClass, (OWLOntology)o);
        if (superClasses.size() == 0) {
            return this.getEntityConcept("public-ontology");
        }
        if (superClasses.size() == 1) {
            OWLClassExpression superClassExpr = (OWLClassExpression)superClasses.iterator().next();
            OWLClass superClass = superClassExpr.asOWLClass();
            String superClassUri = superClass.getIRI().toString();
            Concept parent = this.getConceptByIRI(superClassUri, "public-ontology");
            if (parent != null) {
                return parent;
            }
            parent = this.importOntologyClass(o, superClass, inDir, authorizations);
            if (parent == null) {
                throw new VisalloException("Could not find or create parent: " + superClass);
            }
            return parent;
        }
        throw new VisalloException("Unhandled multiple super classes. Found " + superClasses.size() + ", expected 0 or 1.");
    }

    protected void importDataProperty(OWLOntology o, OWLDataProperty dataTypeProperty, Authorizations authorizations) {
        String propertyIRI = dataTypeProperty.getIRI().toString();
        try {
            String domainClassIri;
            String propertyDisplayName = OWLOntologyUtil.getLabel(o, (OWLEntity)dataTypeProperty);
            PropertyType propertyType = OWLOntologyUtil.getPropertyType(o, dataTypeProperty);
            Preconditions.checkNotNull((Object)propertyType, (Object)("Failed to decode property type of: " + propertyIRI));
            boolean userVisible = OWLOntologyUtil.getUserVisible(o, (OWLEntity)dataTypeProperty);
            boolean searchable = OWLOntologyUtil.getSearchable(o, (OWLEntity)dataTypeProperty);
            boolean addable = OWLOntologyUtil.getAddable(o, (OWLEntity)dataTypeProperty);
            boolean sortable = !propertyType.equals((Object)PropertyType.GEO_LOCATION) && !propertyType.equals((Object)PropertyType.GEO_SHAPE) && OWLOntologyUtil.getSortable(o, (OWLEntity)dataTypeProperty);
            Integer sortPriority = OWLOntologyUtil.getSortPriority(o, (OWLEntity)dataTypeProperty);
            String displayType = OWLOntologyUtil.getDisplayType(o, (OWLEntity)dataTypeProperty);
            String propertyGroup = OWLOntologyUtil.getPropertyGroup(o, (OWLEntity)dataTypeProperty);
            String validationFormula = OWLOntologyUtil.getValidationFormula(o, (OWLEntity)dataTypeProperty);
            String displayFormula = OWLOntologyUtil.getDisplayFormula(o, (OWLEntity)dataTypeProperty);
            ImmutableList<String> dependentPropertyIris = OWLOntologyUtil.getDependentPropertyIris(o, (OWLEntity)dataTypeProperty);
            Double boost = OWLOntologyUtil.getBoost(o, (OWLEntity)dataTypeProperty);
            String[] intents = OWLOntologyUtil.getIntents(o, (OWLEntity)dataTypeProperty);
            boolean deleteable = OWLOntologyUtil.getDeleteable(o, (OWLEntity)dataTypeProperty);
            boolean updateable = OWLOntologyUtil.getUpdateable(o, (OWLEntity)dataTypeProperty);
            User user = this.getSystemUser();
            ArrayList<Concept> domainConcepts = new ArrayList<Concept>();
            for (Object domainClassExpr : EntitySearcher.getDomains((OWLDataProperty)dataTypeProperty, (OWLOntology)o)) {
                OWLClass domainClass = domainClassExpr.asOWLClass();
                domainClassIri = domainClass.getIRI().toString();
                Concept domainConcept = this.getConceptByIRI(domainClassIri, "public-ontology");
                if (domainConcept == null) {
                    LOGGER.error("Could not find class with IRI \"%s\" for data type property \"%s\"", domainClassIri, dataTypeProperty.getIRI());
                    continue;
                }
                LOGGER.info("Adding data property " + propertyIRI + " to class " + domainConcept.getIRI(), new Object[0]);
                domainConcepts.add(domainConcept);
            }
            ArrayList<Relationship> domainRelationships = new ArrayList<Relationship>();
            for (OWLAnnotation domainAnnotation : OWLOntologyUtil.getObjectPropertyDomains(o, dataTypeProperty)) {
                domainClassIri = OWLOntologyUtil.getOWLAnnotationValueAsString(domainAnnotation);
                Relationship domainRelationship = this.getRelationshipByIRI(domainClassIri, "public-ontology");
                if (domainRelationship == null) {
                    LOGGER.error("Could not find relationship with IRI \"%s\" for data type property \"%s\"", domainClassIri, dataTypeProperty.getIRI());
                    continue;
                }
                LOGGER.info("Adding data property " + propertyIRI + " to relationship " + domainRelationship.getIRI(), new Object[0]);
                domainRelationships.add(domainRelationship);
            }
            List<String> extendedDataTableNames = OWLOntologyUtil.getExtendedDataTableNames(o, dataTypeProperty);
            Map<String, String> possibleValues = OWLOntologyUtil.getPossibleValues(o, (OWLEntity)dataTypeProperty);
            Collection<TextIndexHint> textIndexHints = OWLOntologyUtil.getTextIndexHints(o, dataTypeProperty);
            OntologyProperty property = this.addPropertyTo(domainConcepts, domainRelationships, extendedDataTableNames, propertyIRI, propertyDisplayName, propertyType, possibleValues, textIndexHints, userVisible, searchable, addable, sortable, sortPriority, displayType, propertyGroup, boost, validationFormula, displayFormula, dependentPropertyIris, intents, deleteable, updateable, user, "public-ontology");
            property.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), propertyDisplayName, user, authorizations);
            for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)dataTypeProperty, (OWLOntology)o)) {
                String valueString;
                String annotationIri = annotation.getProperty().getIRI().toString();
                String string = valueString = annotation.getValue() instanceof OWLLiteral ? ((OWLLiteral)annotation.getValue()).getLiteral() : annotation.getValue().toString();
                if (annotationIri.equals(OntologyProperties.TITLE_FORMULA.getPropertyName())) {
                    property.setProperty(OntologyProperties.TITLE_FORMULA.getPropertyName(), valueString, user, authorizations);
                    continue;
                }
                if (annotationIri.equals(OntologyProperties.SUBTITLE_FORMULA.getPropertyName())) {
                    property.setProperty(OntologyProperties.SUBTITLE_FORMULA.getPropertyName(), valueString, user, authorizations);
                    continue;
                }
                if (!annotationIri.equals(OntologyProperties.TIME_FORMULA.getPropertyName())) continue;
                property.setProperty(OntologyProperties.TIME_FORMULA.getPropertyName(), valueString, user, authorizations);
            }
        }
        catch (Throwable ex) {
            throw new VisalloException("Failed to load data property: " + propertyIRI, ex);
        }
    }

    @Override
    @Deprecated
    public final OntologyProperty getOrCreateProperty(OntologyPropertyDefinition ontologyPropertyDefinition) {
        return this.getOrCreateProperty(ontologyPropertyDefinition, null, "public-ontology");
    }

    @Override
    public final OntologyProperty getOrCreateProperty(OntologyPropertyDefinition ontologyPropertyDefinition, User user, String workspaceId) {
        this.checkPrivileges(user, workspaceId);
        OntologyProperty property = this.getPropertyByIRI(ontologyPropertyDefinition.getPropertyIri(), workspaceId);
        if (property != null) {
            return property;
        }
        return this.addPropertyTo(ontologyPropertyDefinition.getConcepts(), ontologyPropertyDefinition.getRelationships(), ontologyPropertyDefinition.getExtendedDataTableNames(), ontologyPropertyDefinition.getPropertyIri(), ontologyPropertyDefinition.getDisplayName(), ontologyPropertyDefinition.getDataType(), ontologyPropertyDefinition.getPossibleValues(), ontologyPropertyDefinition.getTextIndexHints(), ontologyPropertyDefinition.isUserVisible(), ontologyPropertyDefinition.isSearchable(), ontologyPropertyDefinition.isAddable(), ontologyPropertyDefinition.isSortable(), ontologyPropertyDefinition.getSortPriority(), ontologyPropertyDefinition.getDisplayType(), ontologyPropertyDefinition.getPropertyGroup(), ontologyPropertyDefinition.getBoost(), ontologyPropertyDefinition.getValidationFormula(), ontologyPropertyDefinition.getDisplayFormula(), ontologyPropertyDefinition.getDependentPropertyIris(), ontologyPropertyDefinition.getIntents(), ontologyPropertyDefinition.getDeleteable(), ontologyPropertyDefinition.getUpdateable(), user, workspaceId);
    }

    protected abstract OntologyProperty addPropertyTo(List<Concept> var1, List<Relationship> var2, List<String> var3, String var4, String var5, PropertyType var6, Map<String, String> var7, Collection<TextIndexHint> var8, boolean var9, boolean var10, boolean var11, boolean var12, Integer var13, String var14, String var15, Double var16, String var17, String var18, ImmutableList<String> var19, String[] var20, boolean var21, boolean var22, User var23, String var24);

    protected Relationship importObjectProperty(OWLOntology o, OWLObjectProperty objectProperty, Authorizations authorizations) {
        String iri = objectProperty.getIRI().toString();
        String label = OWLOntologyUtil.getLabel(o, (OWLEntity)objectProperty);
        Preconditions.checkNotNull((Object)label, (Object)("label cannot be null or empty for " + iri));
        LOGGER.info("Importing ontology object property " + iri + " (label: " + label + ")", new Object[0]);
        boolean isDeclaredInOntology = o.isDeclared((OWLEntity)objectProperty);
        User user = this.getSystemUser();
        Relationship parent = this.getParentObjectProperty(o, objectProperty, authorizations);
        Relationship relationship = this.internalGetOrCreateRelationshipType(parent, this.getDomainsConcepts(o, objectProperty), this.getRangesConcepts(o, objectProperty), iri, null, isDeclaredInOntology, user, "public-ontology");
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)objectProperty, (OWLOntology)o)) {
            String annotationIri = annotation.getProperty().getIRI().toString();
            OWLLiteral valueLiteral = (OWLLiteral)annotation.getValue();
            String valueString = valueLiteral.getLiteral();
            if (annotationIri.equals(OntologyProperties.INTENT.getPropertyName())) {
                relationship.addIntent(valueString, user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.USER_VISIBLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), Boolean.parseBoolean(valueString), user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.DELETEABLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.DELETEABLE.getPropertyName(), Boolean.parseBoolean(valueString), user, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.UPDATEABLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.UPDATEABLE.getPropertyName(), Boolean.parseBoolean(valueString), user, authorizations);
                continue;
            }
            if (annotationIri.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                relationship.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), valueString, user, authorizations);
                continue;
            }
            relationship.setProperty(annotationIri, valueString, user, authorizations);
        }
        return relationship;
    }

    private Relationship getParentObjectProperty(OWLOntology o, OWLObjectProperty objectProperty, Authorizations authorizations) {
        Collection superProperties = EntitySearcher.getSuperProperties((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o);
        if (superProperties.size() == 0) {
            return this.getOrCreateTopObjectPropertyRelationship(authorizations);
        }
        if (superProperties.size() == 1) {
            OWLObjectPropertyExpression superPropertyExpr = (OWLObjectPropertyExpression)superProperties.iterator().next();
            OWLObjectProperty superProperty = superPropertyExpr.asOWLObjectProperty();
            String superPropertyUri = superProperty.getIRI().toString();
            Relationship parent = this.getRelationshipByIRI(superPropertyUri, "public-ontology");
            if (parent != null) {
                return parent;
            }
            parent = this.importObjectProperty(o, superProperty, authorizations);
            if (parent == null) {
                throw new VisalloException("Could not find or create parent: " + superProperty);
            }
            return parent;
        }
        throw new VisalloException("Unhandled multiple super properties. Found " + superProperties.size() + ", expected 0 or 1.");
    }

    protected void importInverseOf(OWLOntology o, OWLObjectProperty objectProperty) {
        String iri = objectProperty.getIRI().toString();
        Relationship fromRelationship = null;
        for (OWLObjectPropertyExpression inverseOf : EntitySearcher.getInverses((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            if (!(inverseOf instanceof OWLObjectProperty)) continue;
            if (fromRelationship == null) {
                fromRelationship = this.getRelationshipByIRI(iri, "public-ontology");
                Preconditions.checkNotNull((Object)fromRelationship, (Object)("could not find from relationship: " + iri));
            }
            OWLObjectProperty inverseOfOWLObjectProperty = (OWLObjectProperty)inverseOf;
            String inverseOfIri = inverseOfOWLObjectProperty.getIRI().toString();
            Relationship inverseOfRelationship = this.getRelationshipByIRI(inverseOfIri, "public-ontology");
            this.getOrCreateInverseOfRelationship(fromRelationship, inverseOfRelationship);
        }
    }

    protected abstract void getOrCreateInverseOfRelationship(Relationship var1, Relationship var2);

    private Iterable<Concept> getRangesConcepts(OWLOntology o, OWLObjectProperty objectProperty) {
        ArrayList<Concept> ranges = new ArrayList<Concept>();
        for (OWLClassExpression rangeClassExpr : EntitySearcher.getRanges((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            OWLClass rangeClass = rangeClassExpr.asOWLClass();
            String rangeClassIri = rangeClass.getIRI().toString();
            Concept ontologyClass = this.getConceptByIRI(rangeClassIri, "public-ontology");
            if (ontologyClass == null) {
                LOGGER.error("Could not find class with IRI \"%s\" for object property \"%s\"", rangeClassIri, objectProperty.getIRI());
                continue;
            }
            ranges.add(ontologyClass);
        }
        return ranges;
    }

    private Iterable<Concept> getDomainsConcepts(OWLOntology o, OWLObjectProperty objectProperty) {
        ArrayList<Concept> domains = new ArrayList<Concept>();
        for (OWLClassExpression domainClassExpr : EntitySearcher.getDomains((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            OWLClass rangeClass = domainClassExpr.asOWLClass();
            String rangeClassIri = rangeClass.getIRI().toString();
            Concept ontologyClass = this.getConceptByIRI(rangeClassIri, "public-ontology");
            if (ontologyClass == null) {
                LOGGER.error("Could not find class with IRI \"%s\" for object property \"%s\"", rangeClassIri, objectProperty.getIRI());
                continue;
            }
            domains.add(ontologyClass);
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePackage(File file, IRI documentIRI, Authorizations authorizations) throws Exception {
        if (!file.exists()) {
            throw new VisalloException("OWL file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new VisalloException("OWL file is not a file: " + file.getAbsolutePath());
        }
        ZipFile zipped = new ZipFile(file);
        if (zipped.isValidZipFile()) {
            File tempDir = Files.createTempDir();
            try {
                LOGGER.info("Extracting: %s to %s", file.getAbsoluteFile(), tempDir.getAbsolutePath());
                zipped.extractAll(tempDir.getAbsolutePath());
                File owlFile = this.findOwlFile(tempDir);
                this.importFile(owlFile, documentIRI, authorizations);
            }
            finally {
                FileUtils.deleteDirectory((File)tempDir);
            }
        } else {
            this.importFile(file, documentIRI, authorizations);
        }
    }

    protected File findOwlFile(File fileOrDir) {
        if (fileOrDir.isFile()) {
            return fileOrDir;
        }
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File child : files) {
            if (child.isDirectory()) {
                File found = this.findOwlFile(child);
                if (found == null) continue;
                return found;
            }
            if (!child.getName().toLowerCase().endsWith(".owl")) continue;
            return child;
        }
        return null;
    }

    @Override
    @Deprecated
    public final Set<Concept> getConceptAndAllChildrenByIri(String conceptIRI) {
        return this.getConceptAndAllChildrenByIri(conceptIRI, "public-ontology");
    }

    @Override
    public Set<Concept> getConceptAndAllChildrenByIri(String conceptIRI, String workspaceId) {
        Concept concept = this.getConceptByIRI(conceptIRI, workspaceId);
        if (concept == null) {
            return null;
        }
        return this.getConceptAndAllChildren(concept, workspaceId);
    }

    @Override
    @Deprecated
    public final Set<Concept> getConceptAndAllChildren(Concept concept) {
        return this.getConceptAndAllChildren(concept, "public-ontology");
    }

    @Override
    public Set<Concept> getConceptAndAllChildren(Concept concept, String workspaceId) {
        List<Concept> childConcepts = this.getChildConcepts(concept, workspaceId);
        HashSet result = Sets.newHashSet((Object[])new Concept[]{concept});
        if (childConcepts.size() > 0) {
            ArrayList<Concept> childrenList = new ArrayList<Concept>();
            for (Concept childConcept : childConcepts) {
                Set<Concept> child = this.getConceptAndAllChildren(childConcept, workspaceId);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    @Override
    public Set<Concept> getAncestorConcepts(Concept concept, String workspaceId) {
        HashSet result = Sets.newHashSet();
        Concept parentConcept = this.getParentConcept(concept, workspaceId);
        while (parentConcept != null) {
            result.add(parentConcept);
            parentConcept = this.getParentConcept(parentConcept, workspaceId);
        }
        return result;
    }

    @Override
    public Set<Concept> getConceptAndAncestors(Concept concept, String workspaceId) {
        HashSet result = Sets.newHashSet((Object[])new Concept[]{concept});
        result.addAll(this.getAncestorConcepts(concept, workspaceId));
        return result;
    }

    protected List<Concept> getChildConcepts(Concept concept) {
        return this.getChildConcepts(concept, "public-ontology");
    }

    protected abstract List<Concept> getChildConcepts(Concept var1, String var2);

    @Override
    @Deprecated
    public final Set<Relationship> getRelationshipAndAllChildren(Relationship relationship) {
        return this.getRelationshipAndAllChildren(relationship, "public-ontology");
    }

    @Override
    public Set<Relationship> getRelationshipAndAllChildrenByIRI(String relationshipIRI, String workspaceId) {
        Relationship relationship = this.getRelationshipByIRI(relationshipIRI, workspaceId);
        return this.getRelationshipAndAllChildren(relationship, workspaceId);
    }

    @Override
    public Set<Relationship> getRelationshipAndAllChildren(Relationship relationship, String workspaceId) {
        List<Relationship> childRelationships = this.getChildRelationships(relationship, workspaceId);
        HashSet result = Sets.newHashSet((Object[])new Relationship[]{relationship});
        if (childRelationships.size() > 0) {
            ArrayList<Relationship> childrenList = new ArrayList<Relationship>();
            for (Relationship childRelationship : childRelationships) {
                Set<Relationship> child = this.getRelationshipAndAllChildren(childRelationship, workspaceId);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    @Override
    public Set<Relationship> getAncestorRelationships(Relationship relationship, String workspaceId) {
        HashSet result = Sets.newHashSet();
        Relationship parentRelationship = this.getParentRelationship(relationship, workspaceId);
        while (parentRelationship != null) {
            result.add(parentRelationship);
            parentRelationship = this.getParentRelationship(parentRelationship, workspaceId);
        }
        return result;
    }

    @Override
    public Set<Relationship> getRelationshipAndAncestors(Relationship relationship, String workspaceId) {
        HashSet result = Sets.newHashSet((Object[])new Relationship[]{relationship});
        result.addAll(this.getAncestorRelationships(relationship, workspaceId));
        return result;
    }

    @Override
    @Deprecated
    public final boolean hasRelationshipByIRI(String relationshipIRI) {
        return this.hasRelationshipByIRI(relationshipIRI, "public-ontology");
    }

    @Override
    public boolean hasRelationshipByIRI(String relationshipIRI, String workspaceId) {
        return this.getRelationshipByIRI(relationshipIRI, workspaceId) != null;
    }

    protected abstract List<Relationship> getChildRelationships(Relationship var1, String var2);

    @Override
    @Deprecated
    public final void resolvePropertyIds(JSONArray filterJson) throws JSONException {
        this.resolvePropertyIds(filterJson, "public-ontology");
    }

    @Override
    public void resolvePropertyIds(JSONArray filterJson, String workspaceId) throws JSONException {
        for (int i = 0; i < filterJson.length(); ++i) {
            JSONObject filter = filterJson.getJSONObject(i);
            if (!filter.has("propertyId") || filter.has("propertyName")) continue;
            String propertyVertexId = filter.getString("propertyId");
            OntologyProperty property = this.getPropertyByIRI(propertyVertexId, workspaceId);
            if (property == null) {
                throw new RuntimeException("Could not find property with id: " + propertyVertexId);
            }
            filter.put("propertyName", (Object)property.getTitle());
            filter.put("propertyDataType", (Object)property.getDataType());
        }
    }

    @Override
    @Deprecated
    public final Concept getConceptByIRI(String conceptIRI) {
        return this.getConceptByIRI(conceptIRI, "public-ontology");
    }

    @Override
    public Concept getConceptByIRI(String conceptIRI, String workspaceId) {
        return (Concept)Iterables.getFirst(this.getConceptsByIRI(Collections.singletonList(conceptIRI), workspaceId), null);
    }

    @Override
    public Iterable<Concept> getConceptsByIRI(List<String> conceptIRIs, String workspaceId) {
        return StreamSupport.stream(this.getConceptsWithProperties(workspaceId).spliterator(), false).filter(concept -> conceptIRIs.contains(concept.getIRI())).collect(Collectors.toSet());
    }

    @Override
    @Deprecated
    public final OntologyProperty getPropertyByIRI(String propertyIRI) {
        return this.getPropertyByIRI(propertyIRI, "public-ontology");
    }

    @Override
    public OntologyProperty getPropertyByIRI(String propertyIRI, String workspaceId) {
        return (OntologyProperty)Iterables.getFirst(this.getPropertiesByIRI(Collections.singletonList(propertyIRI), workspaceId), null);
    }

    @Override
    public Iterable<OntologyProperty> getPropertiesByIRI(List<String> propertyIRIs, String workspaceId) {
        return StreamSupport.stream(this.getProperties(workspaceId).spliterator(), false).filter(property -> propertyIRIs.contains(property.getIri())).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public final OntologyProperty getRequiredPropertyByIRI(String propertyIRI) {
        return this.getRequiredPropertyByIRI(propertyIRI, "public-ontology");
    }

    @Override
    public OntologyProperty getRequiredPropertyByIRI(String propertyIRI, String workspaceId) {
        OntologyProperty property = this.getPropertyByIRI(propertyIRI, workspaceId);
        if (property == null) {
            throw new VisalloException("Could not find property by IRI: " + propertyIRI);
        }
        return property;
    }

    @Override
    @Deprecated
    public final Iterable<Relationship> getRelationships() {
        return this.getRelationships("public-ontology");
    }

    @Override
    @Deprecated
    public final Iterable<OntologyProperty> getProperties() {
        return this.getProperties("public-ontology");
    }

    @Override
    @Deprecated
    public final String getDisplayNameForLabel(String relationshipIRI) {
        return this.getDisplayNameForLabel(relationshipIRI, "public-ontology");
    }

    @Override
    @Deprecated
    public Iterable<Concept> getConceptsWithProperties() {
        return this.getConceptsWithProperties("public-ontology");
    }

    @Override
    @Deprecated
    public final Concept getParentConcept(Concept concept) {
        return this.getParentConcept(concept, "public-ontology");
    }

    @Override
    @Deprecated
    public final Relationship getRelationshipByIRI(String relationshipIRI) {
        return this.getRelationshipByIRI(relationshipIRI, "public-ontology");
    }

    @Override
    public Relationship getRelationshipByIRI(String relationshipIRI, String workspaceId) {
        return (Relationship)Iterables.getFirst(this.getRelationshipsByIRI(Collections.singletonList(relationshipIRI), workspaceId), null);
    }

    @Override
    public Iterable<Relationship> getRelationshipsByIRI(List<String> relationshipIRIs, String workspaceId) {
        return StreamSupport.stream(this.getRelationships(workspaceId).spliterator(), false).filter(relationship -> relationshipIRIs.contains(relationship.getIRI())).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public final Concept getConceptByIntent(String intent) {
        return this.getConceptByIntent(intent, "public-ontology");
    }

    @Override
    public Concept getConceptByIntent(String intent, String workspaceId) {
        String configurationKey = "ontology.intent.concept." + intent;
        String conceptIri = this.getConfiguration().get(configurationKey, null);
        if (conceptIri != null) {
            Concept concept = this.getConceptByIRI(conceptIri, workspaceId);
            if (concept == null) {
                throw new VisalloException("Could not find concept by configuration key: " + configurationKey);
            }
            return concept;
        }
        List<Concept> concepts = this.findLoadedConceptsByIntent(intent, workspaceId);
        if (concepts.size() == 0) {
            return null;
        }
        if (concepts.size() == 1) {
            return concepts.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Concept, String>(concepts){

            protected String convert(Concept o) {
                return o.getIRI();
            }
        });
        throw new VisalloException("Found multiple concepts for intent: " + intent + " (" + iris + ")");
    }

    @Override
    @Deprecated
    public String getConceptIRIByIntent(String intent) {
        return this.getConceptIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getConceptIRIByIntent(String intent, String workspaceId) {
        Concept concept = this.getConceptByIntent(intent, workspaceId);
        if (concept != null) {
            return concept.getIRI();
        }
        return null;
    }

    @Override
    @Deprecated
    public final Concept getRequiredConceptByIntent(String intent) {
        return this.getRequiredConceptByIntent(intent, "public-ontology");
    }

    @Override
    public Concept getRequiredConceptByIntent(String intent, String workspaceId) {
        Concept concept = this.getConceptByIntent(intent, workspaceId);
        if (concept == null) {
            throw new VisalloException("Could not find concept by intent: " + intent);
        }
        return concept;
    }

    @Override
    @Deprecated
    public final String getRequiredConceptIRIByIntent(String intent) {
        return this.getRequiredConceptIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getRequiredConceptIRIByIntent(String intent, String workspaceId) {
        return this.getRequiredConceptByIntent(intent, workspaceId).getIRI();
    }

    @Override
    @Deprecated
    public final Concept getRequiredConceptByIRI(String iri) {
        return this.getRequiredConceptByIRI(iri, "public-ontology");
    }

    @Override
    public Concept getRequiredConceptByIRI(String iri, String workspaceId) {
        Concept concept = this.getConceptByIRI(iri, workspaceId);
        if (concept == null) {
            throw new VisalloException("Could not find concept by IRI: " + iri);
        }
        return concept;
    }

    @Override
    public String generateDynamicIri(Class type, String displayName, String workspaceId, String ... extended) {
        displayName = displayName.trim().replaceAll("\\s+", "_").toLowerCase();
        displayName = displayName.substring(0, Math.min(displayName.length(), 50));
        String typeIri = type.toString() + workspaceId + displayName;
        if (extended != null && extended.length > 0) {
            typeIri = typeIri + Joiner.on((String)"").join((Object[])extended);
        }
        return "http://visallo.org/" + displayName.replaceAll("[^a-zA-Z0-9_]", "") + "#" + Hashing.sha1().hashString((CharSequence)typeIri, Charsets.UTF_8).toString();
    }

    @Override
    public Concept getEntityConcept() {
        return this.getEntityConcept("public-ontology");
    }

    @Override
    @Deprecated
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir) {
        return this.getOrCreateConcept(parent, conceptIRI, displayName, inDir, null, "public-ontology");
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir, User user, String workspaceId) {
        return this.getOrCreateConcept(parent, conceptIRI, displayName, null, null, inDir, user, workspaceId);
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, String glyphIconHref, String color, File inDir, User user, String workspaceId) {
        return this.getOrCreateConcept(parent, conceptIRI, displayName, glyphIconHref, color, inDir, true, user, workspaceId);
    }

    @Override
    @Deprecated
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir, boolean deleteChangeableProperties) {
        return this.getOrCreateConcept(parent, conceptIRI, displayName, inDir, deleteChangeableProperties, null, "public-ontology");
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir, boolean deleteChangeableProperties, User user, String workspaceId) {
        this.checkPrivileges(user, workspaceId);
        return this.internalGetOrCreateConcept(parent, conceptIRI, displayName, null, null, inDir, deleteChangeableProperties, user, workspaceId);
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, String glyphIconHref, String color, File inDir, boolean deleteChangeableProperties, User user, String workspaceId) {
        this.checkPrivileges(user, workspaceId);
        return this.internalGetOrCreateConcept(parent, conceptIRI, displayName, glyphIconHref, color, inDir, deleteChangeableProperties, user, workspaceId);
    }

    protected abstract Concept internalGetOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, File var6, boolean var7, User var8, String var9);

    @Override
    @Deprecated
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipIRI) {
        return this.getOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipIRI, null, true, null, "public-ontology");
    }

    @Override
    @Deprecated
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipIRI, boolean deleteChangeableProperties) {
        return this.getOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipIRI, null, deleteChangeableProperties, null, "public-ontology");
    }

    @Override
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipIRI, boolean isDeclaredInOntology, User user, String workspaceId) {
        return this.getOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipIRI, null, isDeclaredInOntology, user, workspaceId);
    }

    @Override
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipIRI, String displayName, boolean isDeclaredInOntology, User user, String workspaceId) {
        this.checkPrivileges(user, workspaceId);
        if (parent == null && !relationshipIRI.equals(TOP_OBJECT_PROPERTY_IRI)) {
            parent = this.getTopObjectPropertyRelationship(workspaceId);
        }
        return this.internalGetOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipIRI, displayName, isDeclaredInOntology, user, workspaceId);
    }

    protected abstract Relationship internalGetOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, String var5, boolean var6, User var7, String var8);

    @Override
    @Deprecated
    public final Relationship getRelationshipByIntent(String intent) {
        return this.getRelationshipByIntent(intent, "public-ontology");
    }

    @Override
    public Relationship getRelationshipByIntent(String intent, String workspaceId) {
        String configurationKey = "ontology.intent.relationship." + intent;
        String relationshipIri = this.getConfiguration().get(configurationKey, null);
        if (relationshipIri != null) {
            Relationship relationship = this.getRelationshipByIRI(relationshipIri, workspaceId);
            if (relationship == null) {
                throw new VisalloException("Could not find relationship by configuration key: " + configurationKey);
            }
            return relationship;
        }
        List<Relationship> relationships = this.findLoadedRelationshipsByIntent(intent, workspaceId);
        if (relationships.size() == 0) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Relationship, String>(relationships){

            protected String convert(Relationship o) {
                return o.getIRI();
            }
        });
        throw new VisalloException("Found multiple relationships for intent: " + intent + " (" + iris + ")");
    }

    @Override
    @Deprecated
    public final String getRelationshipIRIByIntent(String intent) {
        return this.getRelationshipIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getRelationshipIRIByIntent(String intent, String workspaceId) {
        Relationship relationship = this.getRelationshipByIntent(intent, workspaceId);
        if (relationship != null) {
            return relationship.getIRI();
        }
        return null;
    }

    @Override
    @Deprecated
    public final Relationship getRequiredRelationshipByIntent(String intent) {
        return this.getRequiredRelationshipByIntent(intent, "public-ontology");
    }

    @Override
    public Relationship getRequiredRelationshipByIntent(String intent, String workspaceId) {
        Relationship relationship = this.getRelationshipByIntent(intent, workspaceId);
        if (relationship == null) {
            throw new VisalloException("Could not find relationship by intent: " + intent);
        }
        return relationship;
    }

    @Override
    @Deprecated
    public final String getRequiredRelationshipIRIByIntent(String intent) {
        return this.getRequiredRelationshipIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getRequiredRelationshipIRIByIntent(String intent, String workspaceId) {
        return this.getRequiredRelationshipByIntent(intent, workspaceId).getIRI();
    }

    @Override
    @Deprecated
    public final OntologyProperty getPropertyByIntent(String intent) {
        return this.getPropertyByIntent(intent, "public-ontology");
    }

    @Override
    public OntologyProperty getPropertyByIntent(String intent, String workspaceId) {
        String configurationKey = "ontology.intent.property." + intent;
        String propertyIri = this.getConfiguration().get(configurationKey, null);
        if (propertyIri != null) {
            OntologyProperty property = this.getPropertyByIRI(propertyIri, workspaceId);
            if (property == null) {
                throw new VisalloException("Could not find property by configuration key: " + configurationKey);
            }
            return property;
        }
        List<OntologyProperty> properties = this.getPropertiesByIntent(intent, workspaceId);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return properties.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<OntologyProperty, String>(properties){

            protected String convert(OntologyProperty o) {
                return o.getTitle();
            }
        });
        throw new VisalloException("Found multiple properties for intent: " + intent + " (" + iris + ")");
    }

    @Override
    @Deprecated
    public final String getPropertyIRIByIntent(String intent) {
        return this.getPropertyIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getPropertyIRIByIntent(String intent, String workspaceId) {
        OntologyProperty prop = this.getPropertyByIntent(intent, workspaceId);
        if (prop != null) {
            return prop.getTitle();
        }
        return null;
    }

    @Override
    @Deprecated
    public final OntologyProperty getRequiredPropertyByIntent(String intent) {
        return this.getRequiredPropertyByIntent(intent, "public-ontology");
    }

    @Override
    public OntologyProperty getRequiredPropertyByIntent(String intent, String workspaceId) {
        OntologyProperty property = this.getPropertyByIntent(intent, workspaceId);
        if (property == null) {
            throw new VisalloException("Could not find property by intent: " + intent);
        }
        return property;
    }

    @Override
    @Deprecated
    public final String getRequiredPropertyIRIByIntent(String intent) {
        return this.getRequiredPropertyIRIByIntent(intent, "public-ontology");
    }

    @Override
    public String getRequiredPropertyIRIByIntent(String intent, String workspaceId) {
        return this.getRequiredPropertyByIntent(intent, workspaceId).getTitle();
    }

    @Override
    @Deprecated
    public final OntologyProperty getDependentPropertyParent(String iri) {
        return this.getDependentPropertyParent(iri, "public-ontology");
    }

    @Override
    public OntologyProperty getDependentPropertyParent(String iri, String workspaceId) {
        for (OntologyProperty property : this.getProperties(workspaceId)) {
            if (!property.getDependentPropertyIris().contains((Object)iri)) continue;
            return property;
        }
        return null;
    }

    @Override
    @Deprecated
    public final <T extends VisalloProperty> T getVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType) {
        return this.getVisalloPropertyByIntent(intent, visalloPropertyType, "public-ontology");
    }

    @Override
    public <T extends VisalloProperty> T getVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType, String workspaceId) {
        String propertyIri = this.getPropertyIRIByIntent(intent, workspaceId);
        if (propertyIri == null) {
            LOGGER.warn("No property found for intent: %s", intent);
            return null;
        }
        try {
            Constructor<T> constructor = visalloPropertyType.getConstructor(String.class);
            return (T)((VisalloProperty)constructor.newInstance(propertyIri));
        }
        catch (Exception ex) {
            throw new VisalloException("Could not create property for intent: " + intent + " (propertyIri: " + propertyIri + ")");
        }
    }

    @Override
    @Deprecated
    public final <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType) {
        return this.getRequiredVisalloPropertyByIntent(intent, visalloPropertyType, "public-ontology");
    }

    @Override
    public <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType, String workspaceId) {
        T result = this.getVisalloPropertyByIntent(intent, visalloPropertyType, workspaceId);
        if (result == null) {
            throw new VisalloException("Could not find property by intent: " + intent);
        }
        return result;
    }

    @Override
    @Deprecated
    public final List<OntologyProperty> getPropertiesByIntent(String intent) {
        return this.getPropertiesByIntent(intent, "public-ontology");
    }

    @Override
    public List<OntologyProperty> getPropertiesByIntent(String intent, String workspaceId) {
        ArrayList<OntologyProperty> results = new ArrayList<OntologyProperty>();
        for (OntologyProperty property : this.getProperties(workspaceId)) {
            String[] propertyIntents = property.getIntents();
            if (!Arrays.asList(propertyIntents).contains(intent)) continue;
            results.add(property);
        }
        return results;
    }

    @Override
    @Deprecated
    public final ClientApiOntology getClientApiObject() {
        return this.getClientApiObject("public-ontology");
    }

    @Override
    public ClientApiOntology getClientApiObject(String workspaceId) {
        Ontology ontology = this.getOntology(workspaceId);
        T[] results = ExecutorServiceUtil.runAllAndWait(() -> Concept.toClientApiConcepts(ontology.getConcepts()), () -> OntologyProperty.toClientApiProperties(ontology.getProperties()), () -> Relationship.toClientApiRelationships(ontology.getRelationships()));
        ClientApiOntology clientOntology = new ClientApiOntology();
        clientOntology.addAllConcepts((Collection)results[0]);
        clientOntology.addAllProperties((Collection)results[1]);
        clientOntology.addAllRelationships((Collection)results[2]);
        return clientOntology;
    }

    @Override
    public Ontology getOntology(String workspaceId) {
        if (workspaceId == null) {
            return this.getOntology("public-ontology");
        }
        Ontology ontology = (Ontology)this.cacheService.getIfPresent(ONTOLOGY_CACHE_NAME, workspaceId);
        if (ontology != null) {
            return ontology;
        }
        T[] results = ExecutorServiceUtil.runAllAndWait(() -> this.getConceptsWithProperties(workspaceId), () -> this.getRelationships(workspaceId), () -> this.getProperties(workspaceId));
        Iterable concepts = (Iterable)results[0];
        Iterable relationships = (Iterable)results[1];
        Map<String, OntologyProperty> properties = StreamUtil.stream((Iterable)results[2]).collect(Collectors.toMap(OntologyProperty::getIri, p -> p));
        List<ExtendedDataTableProperty> extendedDataTables = properties.values().stream().filter(p -> p instanceof ExtendedDataTableProperty).map(p -> (ExtendedDataTableProperty)((Object)p)).collect(Collectors.toList());
        ontology = new Ontology(concepts, relationships, extendedDataTables, properties, workspaceId);
        if (!"public-ontology".equals(workspaceId) && ontology.getSandboxStatus() == SandboxStatus.PUBLIC) {
            ontology = this.getOntology("public-ontology");
        }
        this.cacheService.put(ONTOLOGY_CACHE_NAME, workspaceId, ontology, this.ontologyCacheOptions);
        return ontology;
    }

    protected Relationship getTopObjectPropertyRelationship(String workspaceId) {
        return this.getRelationshipByIRI(TOP_OBJECT_PROPERTY_IRI, workspaceId);
    }

    @Override
    public void clearCache() {
        this.cacheService.invalidate(ONTOLOGY_CACHE_NAME);
    }

    @Override
    public void clearCache(String workspaceId) {
        this.cacheService.invalidate(ONTOLOGY_CACHE_NAME, workspaceId);
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    protected void defineRequiredProperties(Graph graph) {
        this.definePropertyOnGraph(graph, VisalloProperties.CONCEPT_TYPE, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, VisalloProperties.MODIFIED_BY, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, VisalloProperties.MODIFIED_DATE, Date.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, VisalloProperties.VISIBILITY_JSON, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.ONTOLOGY_TITLE, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, OntologyProperties.DISPLAY_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, OntologyProperties.INTENT, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, OntologyProperties.TITLE_FORMULA, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.SUBTITLE_FORMULA, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.TIME_FORMULA, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.GLYPH_ICON, byte[].class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.MAP_GLYPH_ICON, byte[].class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.GLYPH_ICON_FILE_NAME, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.DATA_TYPE, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, OntologyProperties.USER_VISIBLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.SEARCHABLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.SORTABLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.SORT_PRIORITY, Integer.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.ADDABLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.DELETEABLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.UPDATEABLE, Boolean.TYPE, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.ONTOLOGY_FILE, byte[].class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.ONTOLOGY_FILE_MD5, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.COLOR, String.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, OntologyProperties.DEPENDENT_PROPERTY_ORDER_PROPERTY_NAME, Integer.class, TextIndexHint.NONE);
    }

    protected void definePropertyOnGraph(Graph graph, VisalloPropertyBase<?, ?> property, Class dataType, Set<TextIndexHint> textIndexHint) {
        this.definePropertyOnGraph(graph, property.getPropertyName(), dataType, textIndexHint, null, false);
    }

    protected void definePropertyOnGraph(Graph graph, String propertyName, Class dataType, Collection<TextIndexHint> textIndexHint, Double boost, boolean sortable) {
        if (!graph.isPropertyDefined(propertyName)) {
            DefinePropertyBuilder builder = graph.defineProperty(propertyName).dataType(dataType).sortable(sortable);
            if (textIndexHint != null) {
                builder.textIndexHint(textIndexHint);
            }
            if (boost != null) {
                if (graph.isFieldBoostSupported()) {
                    builder.boost(boost.doubleValue());
                } else {
                    LOGGER.warn("Field boosting is not support by the graph", new Object[0]);
                }
            }
            builder.define();
        } else {
            Set definedTextHints;
            PropertyDefinition propertyDefinition = graph.getPropertyDefinition(propertyName);
            if (propertyDefinition.getDataType() != dataType) {
                LOGGER.warn("Ontology property type mismatch for property %s! Expected %s but found %s", propertyName, dataType.getName(), propertyDefinition.getDataType().getName());
            }
            Set set = definedTextHints = propertyDefinition.getTextIndexHints() == null ? Collections.EMPTY_SET : propertyDefinition.getTextIndexHints();
            if (!definedTextHints.equals(textIndexHint)) {
                LOGGER.warn("Ontology property text index hints mismatch for property %s! Expected %s but found %s", propertyName, textIndexHint, definedTextHints);
            }
        }
    }

    protected boolean determineSearchable(String propertyIri, PropertyType dataType, Collection<TextIndexHint> textIndexHints, boolean searchable) {
        if (dataType == PropertyType.EXTENDED_DATA_TABLE) {
            return false;
        }
        if (dataType == PropertyType.STRING) {
            Preconditions.checkNotNull(textIndexHints, (Object)"textIndexHints are required for string properties");
            if (searchable && (textIndexHints.isEmpty() || textIndexHints.equals(TextIndexHint.NONE))) {
                searchable = false;
            } else if (!(searchable || textIndexHints.isEmpty() && textIndexHints.equals(TextIndexHint.NONE))) {
                LOGGER.info("textIndexHints was specified for non-UI-searchable string property:: " + propertyIri, new Object[0]);
            }
        }
        return searchable;
    }

    protected abstract Graph getGraph();

    protected abstract void internalDeleteConcept(Concept var1, String var2);

    protected abstract void internalDeleteProperty(OntologyProperty var1, String var2);

    protected abstract void internalDeleteRelationship(Relationship var1, String var2);

    @Override
    public void deleteConcept(String conceptTypeIri, User user, String workspaceId) {
        this.checkDeletePrivileges(user, workspaceId);
        Set<Concept> concepts = this.getConceptAndAllChildrenByIri(conceptTypeIri, workspaceId);
        if (concepts.size() == 1) {
            for (Concept concept : concepts) {
                if (concept.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE)) {
                    for (Relationship relationship : this.getRelationships(workspaceId)) {
                        if (!relationship.getDomainConceptIRIs().contains(conceptTypeIri) && !relationship.getRangeConceptIRIs().contains(conceptTypeIri)) continue;
                        throw new VisalloException("Unable to delete concept that is used in domain/range of relationship");
                    }
                    Graph graph = this.getGraph();
                    Authorizations authorizations = graph.createAuthorizations(new String[]{workspaceId});
                    GraphQuery query = graph.query(authorizations);
                    this.addConceptTypeFilterToQuery((Query)query, concept.getIRI(), false, workspaceId);
                    query.limit(Integer.valueOf(0));
                    long results = query.search().getTotalHits();
                    if (results == 0L) {
                        List removeProperties = concept.getProperties().stream().filter(ontologyProperty -> ontologyProperty.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE) && ontologyProperty.getRelationshipIris().size() == 0 && ontologyProperty.getConceptIris().size() == 1 && ontologyProperty.getConceptIris().get(0).equals(conceptTypeIri)).collect(Collectors.toList());
                        this.internalDeleteConcept(concept, workspaceId);
                        for (OntologyProperty property : removeProperties) {
                            this.internalDeleteProperty(property, workspaceId);
                        }
                        continue;
                    }
                    throw new VisalloException("Unable to delete concept that have vertices assigned to it");
                }
                throw new VisalloException("Unable to delete published concepts");
            }
        } else {
            throw new VisalloException("Unable to delete concept that have children");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteProperty(String propertyIri, User user, String workspaceId) {
        this.checkDeletePrivileges(user, workspaceId);
        OntologyProperty property = this.getPropertyByIRI(propertyIri, workspaceId);
        if (property == null) throw new VisalloResourceNotFoundException("Property not found");
        if (!property.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE)) throw new VisalloException("Unable to delete published properties");
        Graph graph = this.getGraph();
        Authorizations authorizations = graph.createAuthorizations(new String[]{workspaceId});
        GraphQuery query = graph.query(authorizations);
        query.has(propertyIri);
        query.limit(Integer.valueOf(0));
        long results = query.search().getTotalHits();
        if (results != 0L) {
            throw new VisalloException("Unable to delete property that have elements using it");
        }
        this.internalDeleteProperty(property, workspaceId);
    }

    @Override
    public void deleteRelationship(String relationshipIri, User user, String workspaceId) {
        this.checkDeletePrivileges(user, workspaceId);
        Set<Relationship> relationships = this.getRelationshipAndAllChildrenByIRI(relationshipIri, workspaceId);
        if (relationships.size() == 1) {
            for (Relationship relationship : relationships) {
                if (relationship.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE)) {
                    Graph graph = this.getGraph();
                    Authorizations authorizations = graph.createAuthorizations(new String[]{workspaceId});
                    GraphQuery query = graph.query(authorizations);
                    this.addEdgeLabelFilterToQuery((Query)query, relationshipIri, false, workspaceId);
                    query.limit(Integer.valueOf(0));
                    long results = query.search().getTotalHits();
                    if (results == 0L) {
                        List removeProperties = relationship.getProperties().stream().filter(ontologyProperty -> ontologyProperty.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE) && ontologyProperty.getConceptIris().size() == 0 && ontologyProperty.getRelationshipIris().size() == 1 && ontologyProperty.getRelationshipIris().get(0).equals(relationshipIri)).collect(Collectors.toList());
                        this.internalDeleteRelationship(relationship, workspaceId);
                        for (OntologyProperty property : removeProperties) {
                            this.internalDeleteProperty(property, workspaceId);
                        }
                        continue;
                    }
                    throw new VisalloException("Unable to delete relationship that have edges using it");
                }
                throw new VisalloException("Unable to delete published relationships");
            }
        } else {
            throw new VisalloException("Unable to delete relationship that have children");
        }
    }

    @Override
    @Deprecated
    public final void addConceptTypeFilterToQuery(Query query, String conceptTypeIri, boolean includeChildNodes) {
        this.addConceptTypeFilterToQuery(query, conceptTypeIri, includeChildNodes, "public-ontology");
    }

    @Override
    public void addConceptTypeFilterToQuery(Query query, String conceptTypeIri, boolean includeChildNodes, String workspaceId) {
        Preconditions.checkNotNull((Object)conceptTypeIri, (Object)"conceptTypeIri cannot be null");
        ArrayList<OntologyRepository.ElementTypeFilter> filters = new ArrayList<OntologyRepository.ElementTypeFilter>();
        filters.add(new OntologyRepository.ElementTypeFilter(conceptTypeIri, includeChildNodes));
        this.addConceptTypeFilterToQuery(query, filters, workspaceId);
    }

    @Override
    @Deprecated
    public final void addConceptTypeFilterToQuery(Query query, Collection<OntologyRepository.ElementTypeFilter> filters) {
        this.addConceptTypeFilterToQuery(query, filters, "public-ontology");
    }

    @Override
    public void addConceptTypeFilterToQuery(Query query, Collection<OntologyRepository.ElementTypeFilter> filters, String workspaceId) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        Preconditions.checkNotNull(filters, (Object)"filters cannot be null");
        if (filters.isEmpty()) {
            return;
        }
        HashSet<String> conceptIds = new HashSet<String>(filters.size());
        for (OntologyRepository.ElementTypeFilter filter : filters) {
            Concept concept = this.getConceptByIRI(filter.iri, workspaceId);
            Preconditions.checkNotNull((Object)concept, (Object)("Could not find concept with IRI: " + filter.iri));
            conceptIds.add(concept.getIRI());
            if (!filter.includeChildNodes) continue;
            Set<Concept> childConcepts = this.getConceptAndAllChildren(concept, workspaceId);
            conceptIds.addAll(childConcepts.stream().map(Concept::getIRI).collect(Collectors.toSet()));
        }
        query.has(VisalloProperties.CONCEPT_TYPE.getPropertyName(), (Predicate)Contains.IN, conceptIds);
    }

    @Override
    @Deprecated
    public final void addEdgeLabelFilterToQuery(Query query, String edgeLabel, boolean includeChildNodes) {
        this.addEdgeLabelFilterToQuery(query, edgeLabel, includeChildNodes, "public-ontology");
    }

    @Override
    public void addEdgeLabelFilterToQuery(Query query, String edgeLabel, boolean includeChildNodes, String workspaceId) {
        Preconditions.checkNotNull((Object)edgeLabel, (Object)"edgeLabel cannot be null");
        ArrayList<OntologyRepository.ElementTypeFilter> filters = new ArrayList<OntologyRepository.ElementTypeFilter>();
        filters.add(new OntologyRepository.ElementTypeFilter(edgeLabel, includeChildNodes));
        this.addEdgeLabelFilterToQuery(query, filters, workspaceId);
    }

    @Override
    @Deprecated
    public final void addEdgeLabelFilterToQuery(Query query, Collection<OntologyRepository.ElementTypeFilter> filters) {
        this.addEdgeLabelFilterToQuery(query, filters, "public-ontology");
    }

    @Override
    public void addEdgeLabelFilterToQuery(Query query, Collection<OntologyRepository.ElementTypeFilter> filters, String workspaceId) {
        Preconditions.checkNotNull(filters, (Object)"filters cannot be null");
        if (filters.isEmpty()) {
            return;
        }
        HashSet<String> edgeIds = new HashSet<String>(filters.size());
        for (OntologyRepository.ElementTypeFilter filter : filters) {
            Relationship relationship = this.getRelationshipByIRI(filter.iri, workspaceId);
            Preconditions.checkNotNull((Object)relationship, (Object)("Could not find edge with IRI: " + filter.iri));
            edgeIds.add(relationship.getIRI());
            if (!filter.includeChildNodes) continue;
            Set<Relationship> childRelations = this.getRelationshipAndAllChildren(relationship, workspaceId);
            edgeIds.addAll(childRelations.stream().map(Relationship::getIRI).collect(Collectors.toSet()));
        }
        query.hasEdgeLabel(edgeIds);
    }

    @Override
    public final void publishConcept(Concept concept, User user, String workspaceId) {
        this.checkPrivileges(user, null);
        this.internalPublishConcept(concept, user, workspaceId);
    }

    public abstract void internalPublishConcept(Concept var1, User var2, String var3);

    @Override
    public final void publishRelationship(Relationship relationship, User user, String workspaceId) {
        this.checkPrivileges(user, null);
        this.internalPublishRelationship(relationship, user, workspaceId);
    }

    public abstract void internalPublishRelationship(Relationship var1, User var2, String var3);

    @Override
    public void publishProperty(OntologyProperty property, User user, String workspaceId) {
        this.checkPrivileges(user, null);
        this.internalPublishProperty(property, user, workspaceId);
    }

    public abstract void internalPublishProperty(OntologyProperty var1, User var2, String var3);

    protected void checkPrivileges(User user, String workspaceId) {
        if (user != null && user.getUserType() == UserType.SYSTEM) {
            return;
        }
        if (user == null) {
            throw new VisalloAccessDeniedException("You must provide a valid user to perform this action", null, null);
        }
        if (this.isPublic(workspaceId)) {
            if (!this.getPrivilegeRepository().hasPrivilege(user, "ONTOLOGY_PUBLISH")) {
                throw new VisalloAccessDeniedException("User does not have ONTOLOGY_PUBLISH privilege", user, null);
            }
        } else {
            List<WorkspaceUser> users = this.getWorkspaceRepository().findUsersWithAccess(workspaceId, user);
            boolean access = users.stream().anyMatch(workspaceUser -> workspaceUser.getUserId().equals(user.getUserId()) && workspaceUser.getWorkspaceAccess().equals((Object)WorkspaceAccess.WRITE));
            if (!access) {
                throw new VisalloAccessDeniedException("User does not have access to workspace", user, null);
            }
            if (!this.getPrivilegeRepository().hasPrivilege(user, "ONTOLOGY_ADD")) {
                throw new VisalloAccessDeniedException("User does not have ONTOLOGY_ADD privilege", user, null);
            }
        }
    }

    protected void checkDeletePrivileges(User user, String workspaceId) {
        if (user != null && user.getUserType() == UserType.SYSTEM) {
            return;
        }
        if (user == null) {
            throw new VisalloAccessDeniedException("You must provide a valid user to perform this action", null, null);
        }
        if (workspaceId == null) {
            throw new VisalloAccessDeniedException("User does not have access to delete published ontology items", user, null);
        }
        if (!this.getPrivilegeRepository().hasPrivilege(user, "ADMIN")) {
            throw new VisalloAccessDeniedException("User does not have admin privilege", user, null);
        }
    }

    protected List<Concept> findLoadedConceptsByIntent(String intent, String workspaceId) {
        ArrayList<Concept> results = new ArrayList<Concept>();
        for (Concept concept : this.getConceptsWithProperties(workspaceId)) {
            String[] conceptIntents = concept.getIntents();
            if (!Arrays.asList(conceptIntents).contains(intent)) continue;
            results.add(concept);
        }
        return results;
    }

    protected List<Relationship> findLoadedRelationshipsByIntent(String intent, String workspaceId) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship relationship : this.getRelationships(workspaceId)) {
            String[] relationshipIntents = relationship.getIntents();
            if (!Arrays.asList(relationshipIntents).contains(intent)) continue;
            results.add(relationship);
        }
        return results;
    }

    protected User getSystemUser() {
        return new SystemUser();
    }

    protected PrivilegeRepository getPrivilegeRepository() {
        if (this.privilegeRepository == null) {
            this.privilegeRepository = InjectHelper.getInstance(PrivilegeRepository.class);
        }
        return this.privilegeRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        if (this.workspaceRepository == null) {
            this.workspaceRepository = InjectHelper.getInstance(WorkspaceRepository.class);
        }
        return this.workspaceRepository;
    }

    protected abstract void deleteChangeableProperties(OntologyElement var1, Authorizations var2);

    protected abstract void deleteChangeableProperties(OntologyProperty var1, Authorizations var2);

    protected boolean isPublic(String workspaceId) {
        return workspaceId == null || "public-ontology".equals(workspaceId);
    }

    protected void validateRelationship(String relationshipIRI, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts) {
        if (!relationshipIRI.equals(TOP_OBJECT_PROPERTY_IRI) && (IterableUtils.isEmpty(domainConcepts) || IterableUtils.isEmpty(rangeConcepts))) {
            throw new VisalloException(relationshipIRI + " must have at least one domain and range ");
        }
    }
}

