/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.vertexium.Authorizations;
import org.visallo.core.model.ontology.HasOntologyProperties;
import org.visallo.core.model.ontology.OntologyElement;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.SandboxStatus;

public abstract class Relationship
implements OntologyElement,
HasOntologyProperties {
    private final String parentIRI;
    private final List<String> domainConceptIRIs;
    private final List<String> rangeConceptIRIs;
    private final Collection<OntologyProperty> properties;

    protected Relationship(String parentIRI, List<String> domainConceptIRIs, List<String> rangeConceptIRIs, Collection<OntologyProperty> properties) {
        this.parentIRI = parentIRI;
        this.domainConceptIRIs = domainConceptIRIs;
        this.rangeConceptIRIs = rangeConceptIRIs;
        this.properties = properties;
    }

    public abstract String getId();

    public abstract SandboxStatus getSandboxStatus();

    public abstract String getIRI();

    public String getParentIRI() {
        return this.parentIRI;
    }

    public abstract String getTitleFormula();

    public abstract String getSubtitleFormula();

    public abstract String getTimeFormula();

    public abstract String getDisplayName();

    public abstract Iterable<String> getInverseOfIRIs();

    public List<String> getDomainConceptIRIs() {
        return this.domainConceptIRIs;
    }

    public List<String> getRangeConceptIRIs() {
        return this.rangeConceptIRIs;
    }

    @Override
    public abstract boolean getUserVisible();

    @Override
    public abstract boolean getDeleteable();

    @Override
    public abstract boolean getUpdateable();

    public abstract String[] getIntents();

    @Override
    public Collection<OntologyProperty> getProperties() {
        return this.properties;
    }

    public abstract void addIntent(String var1, User var2, Authorizations var3);

    public abstract void removeIntent(String var1, Authorizations var2);

    public void updateIntents(String[] newIntents, User user, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, user, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public abstract void setProperty(String var1, Object var2, User var3, Authorizations var4);

    public abstract void removeProperty(String var1, Authorizations var2);

    public abstract Map<String, String> getMetadata();

    public ClientApiOntology.Relationship toClientApi() {
        try {
            ClientApiOntology.Relationship result = new ClientApiOntology.Relationship();
            result.setParentIri(this.getParentIRI());
            result.setTitle(this.getIRI());
            result.setDisplayName(this.getDisplayName());
            result.setDomainConceptIris(this.getDomainConceptIRIs());
            result.setRangeConceptIris(this.getRangeConceptIRIs());
            result.setUserVisible(Boolean.valueOf(this.getUserVisible()));
            result.setDeleteable(Boolean.valueOf(this.getDeleteable()));
            result.setUpdateable(Boolean.valueOf(this.getUpdateable()));
            result.setTitleFormula(this.getTitleFormula());
            result.setSubtitleFormula(this.getSubtitleFormula());
            result.setTimeFormula(this.getTimeFormula());
            if (this.getIntents() != null) {
                result.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            for (Map.Entry<String, String> additionalProperty : this.getMetadata().entrySet()) {
                result.getMetadata().put(additionalProperty.getKey(), additionalProperty.getValue());
            }
            result.setSandboxStatus(this.getSandboxStatus());
            Iterable<String> inverseOfIRIs = this.getInverseOfIRIs();
            for (String inverseOfIRI : inverseOfIRIs) {
                ClientApiOntology.Relationship.InverseOf inverseOf = new ClientApiOntology.Relationship.InverseOf();
                inverseOf.setIri(inverseOfIRI);
                inverseOf.setPrimaryIri(Relationship.getPrimaryInverseOfIRI(this.getIRI(), inverseOfIRI));
                result.getInverseOfs().add(inverseOf);
            }
            if (this.properties != null) {
                for (OntologyProperty property : this.properties) {
                    result.getProperties().add(property.getTitle());
                }
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPrimaryInverseOfIRI(String iri1, String iri2) {
        if (iri1.compareTo(iri2) > 0) {
            return iri2;
        }
        return iri1;
    }

    public static Collection<ClientApiOntology.Relationship> toClientApiRelationships(Iterable<Relationship> relationships) {
        ArrayList<ClientApiOntology.Relationship> results = new ArrayList<ClientApiOntology.Relationship>();
        for (Relationship vertex : relationships) {
            results.add(vertex.toClientApi());
        }
        return results;
    }

    public String toString() {
        return "Relationship{iri='" + this.getIRI() + '\'' + '}';
    }
}

