/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import java.util.Date;
import org.vertexium.Element;
import org.visallo.core.model.graph.ElementUpdateContext;
import org.visallo.core.model.properties.types.IdentityVisalloProperty;
import org.visallo.core.model.properties.types.PropertyMetadata;

public class DateVisalloProperty
extends IdentityVisalloProperty<Date> {
    public DateVisalloProperty(String key) {
        super(key);
    }

    public <T extends Element> void updatePropertyIfValueIsNewer(ElementUpdateContext<T> ctx, String propertyKey, Date newValue, PropertyMetadata metadata, Long timestamp) {
        if (this.isDateGreater(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata, timestamp);
        }
    }

    public <T extends Element> void updatePropertyIfValueIsNewer(ElementUpdateContext<T> ctx, String propertyKey, Date newValue, PropertyMetadata metadata) {
        if (this.isDateGreater(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata);
        }
    }

    private <T extends Element> boolean isDateGreater(T element, String propertyKey, Date newValue) {
        if (element == null) {
            return true;
        }
        Date existingValue = (Date)this.getPropertyValue(element, propertyKey);
        if (existingValue == null) {
            return true;
        }
        return existingValue.compareTo(newValue) < 0;
    }
}

