/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vertexium.Element;
import org.vertexium.ExtendedDataRow;
import org.vertexium.mutation.ElementMutation;
import org.visallo.core.model.graph.ElementUpdateContext;
import org.visallo.core.model.properties.types.PropertyMetadata;

public abstract class VisalloExtendedData<TRaw, TGraph> {
    private static final String ROW_ID_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final String tableName;
    private final String columnName;

    protected VisalloExtendedData(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public abstract TGraph rawToGraph(TRaw var1);

    public abstract TRaw graphToRaw(Object var1);

    public <T extends Element> void addExtendedData(ElementUpdateContext<T> elemCtx, String row, TRaw newValue, PropertyMetadata propertyMetadata) {
        this.addExtendedData(elemCtx.getMutation(), row, newValue, propertyMetadata);
    }

    public <T extends Element> void addExtendedData(ElementUpdateContext<T> elemCtx, String row, TRaw newValue, PropertyMetadata propertyMetadata, Long timestamp) {
        this.addExtendedData(elemCtx.getMutation(), row, newValue, propertyMetadata, timestamp);
    }

    public <T extends Element> void addExtendedData(ElementMutation<T> m, String row, TRaw newValue, PropertyMetadata propertyMetadata) {
        this.addExtendedData(m, row, newValue, propertyMetadata, null);
    }

    public <T extends Element> void addExtendedData(ElementMutation<T> m, String row, TRaw newValue, PropertyMetadata propertyMetadata, Long timestamp) {
        Preconditions.checkNotNull(newValue, (Object)"null values are not allowed");
        m.addExtendedData(this.tableName, row, this.columnName, this.rawToGraph(newValue), timestamp, propertyMetadata.getPropertyVisibility());
    }

    public static String rowIdFromDate(Date timestamp) {
        return new SimpleDateFormat(ROW_ID_DATE_FORMAT).format(timestamp);
    }

    public TRaw getValue(ExtendedDataRow row) {
        Object value = row.getPropertyValue(this.columnName);
        if (value == null) {
            return null;
        }
        return this.graphToRaw(value);
    }
}

