/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.math3.util.Precision;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.VertexiumObject;
import org.vertexium.VertexiumObjectType;
import org.vertexium.query.Aggregation;
import org.vertexium.query.CalendarFieldAggregation;
import org.vertexium.query.Compare;
import org.vertexium.query.Contains;
import org.vertexium.query.GeoCompare;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.HasExtendedDataFilter;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.SupportsNestedAggregationsAggregation;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TextPredicate;
import org.vertexium.type.GeoShape;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.search.QueryResultsIterableSearchResults;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.model.search.SearchRunner;
import org.visallo.core.trace.Trace;
import org.visallo.core.trace.TraceSpan;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.JSONUtil;
import org.visallo.web.clientapi.model.PropertyType;

public abstract class VertexiumObjectSearchRunnerBase
extends SearchRunner {
    private final Graph graph;
    private final DirectoryRepository directoryRepository;
    private final OntologyRepository ontologyRepository;
    private long defaultSearchResultCount;

    protected VertexiumObjectSearchRunnerBase(OntologyRepository ontologyRepository, Graph graph, Configuration configuration, DirectoryRepository directoryRepository) {
        this.ontologyRepository = ontologyRepository;
        this.graph = graph;
        this.directoryRepository = directoryRepository;
        this.defaultSearchResultCount = configuration.getInt("search.defaultSearchCount", 100).intValue();
    }

    @Override
    public QueryResultsIterableSearchResults run(SearchOptions searchOptions, User user, Authorizations authorizations) {
        Long offset;
        JSONArray filterJson = this.getFilterJson(searchOptions, searchOptions.getWorkspaceId());
        QueryAndData queryAndData = this.getQuery(searchOptions, authorizations);
        this.applyFiltersToQuery(queryAndData, filterJson, user, searchOptions);
        this.applyConceptTypeFilterToQuery(queryAndData, searchOptions);
        this.applyEdgeLabelFilterToQuery(queryAndData, searchOptions);
        this.applySortToQuery(queryAndData, searchOptions);
        this.applyAggregationsToQuery(queryAndData, searchOptions);
        this.applyExtendedDataFilters(queryAndData, searchOptions);
        EnumSet<FetchHint> fetchHints = this.getFetchHints(searchOptions);
        Long size = searchOptions.getOptionalParameter("size", this.defaultSearchResultCount);
        if (size != null) {
            queryAndData.getQuery().limit(size);
        }
        if ((offset = searchOptions.getOptionalParameter("offset", 0L)) != null) {
            queryAndData.getQuery().skip(offset.intValue());
        }
        QueryResultsIterable<? extends VertexiumObject> searchResults = this.getSearchResults(queryAndData, fetchHints);
        return new QueryResultsIterableSearchResults(searchResults, queryAndData, offset, size);
    }

    private EnumSet<FetchHint> getFetchHints(SearchOptions searchOptions) {
        String fetchHintsString = (String)((Object)searchOptions.getOptionalParameter("fetchHints", String.class));
        if (fetchHintsString == null) {
            return ClientApiConverter.SEARCH_FETCH_HINTS;
        }
        return FetchHint.parse((String)fetchHintsString);
    }

    private void applyExtendedDataFilters(QueryAndData queryAndData, SearchOptions searchOptions) {
        Query query = queryAndData.getQuery();
        String[] filterStrings = (String[])searchOptions.getOptionalParameter("extendedDataFilters[]", String[].class);
        if (filterStrings == null || filterStrings.length == 0) {
            return;
        }
        ArrayList<HasExtendedDataFilter> filters = new ArrayList<HasExtendedDataFilter>();
        for (String filterString : filterStrings) {
            JSONObject filterJson = new JSONObject(filterString);
            String elementTypeString = filterJson.optString("elementType");
            ElementType elementType = elementTypeString == null ? null : ElementType.valueOf((String)elementTypeString);
            String elementId = filterJson.optString("elementId");
            String tableName = filterJson.optString("tableName");
            filters.add(new HasExtendedDataFilter(elementType, elementId, tableName));
        }
        query.hasExtendedData(filters);
    }

    private void applyAggregationsToQuery(QueryAndData queryAndData, SearchOptions searchOptions) {
        Query query = queryAndData.getQuery();
        String[] aggregates = (String[])searchOptions.getOptionalParameter("aggregations[]", String[].class);
        if (aggregates == null) {
            return;
        }
        for (String aggregate : aggregates) {
            JSONObject aggregateJson = new JSONObject(aggregate);
            Aggregation aggregation = this.getAggregation(aggregateJson);
            query.addAggregation(aggregation);
        }
    }

    private Aggregation getAggregation(JSONObject aggregateJson) {
        Aggregation aggregation;
        String type;
        String aggregationName = aggregateJson.getString("name");
        switch (type = aggregateJson.getString("type")) {
            case "term": {
                aggregation = this.getTermsAggregation(aggregationName, aggregateJson);
                break;
            }
            case "geohash": {
                aggregation = this.getGeohashAggregation(aggregationName, aggregateJson);
                break;
            }
            case "histogram": {
                aggregation = this.getHistogramAggregation(aggregationName, aggregateJson);
                break;
            }
            case "statistics": {
                aggregation = this.getStatisticsAggregation(aggregationName, aggregateJson);
                break;
            }
            case "calendar": {
                aggregation = this.getCalendarFieldAggregation(aggregationName, aggregateJson);
                break;
            }
            default: {
                throw new VisalloException("Invalid aggregation type: " + type);
            }
        }
        return this.addNestedAggregations(aggregation, aggregateJson);
    }

    private Aggregation addNestedAggregations(Aggregation aggregation, JSONObject aggregateJson) {
        JSONArray nestedAggregates = aggregateJson.optJSONArray("nested");
        if (nestedAggregates != null && nestedAggregates.length() > 0) {
            if (!(aggregation instanceof SupportsNestedAggregationsAggregation)) {
                throw new VisalloException("Aggregation does not support nesting: " + aggregation.getClass().getName());
            }
            for (int i = 0; i < nestedAggregates.length(); ++i) {
                JSONObject nestedAggregateJson = nestedAggregates.getJSONObject(i);
                Aggregation nestedAggregate = this.getAggregation(nestedAggregateJson);
                ((SupportsNestedAggregationsAggregation)aggregation).addNestedAggregation(nestedAggregate);
            }
        }
        return aggregation;
    }

    private Aggregation getTermsAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        TermsAggregation terms = new TermsAggregation(aggregationName, field);
        int size = aggregateJson.optInt("size", 0);
        if (size > 0) {
            terms.setSize(Integer.valueOf(size));
        }
        return terms;
    }

    private Aggregation getGeohashAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        int precision = aggregateJson.getInt("precision");
        return new GeohashAggregation(aggregationName, field, precision);
    }

    private Aggregation getHistogramAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        String interval = aggregateJson.getString("interval");
        Long minDocumentCount = JSONUtil.getOptionalLong(aggregateJson, "minDocumentCount");
        return new HistogramAggregation(aggregationName, field, interval, minDocumentCount);
    }

    private Aggregation getStatisticsAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new StatisticsAggregation(aggregationName, field);
    }

    private Aggregation getCalendarFieldAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        Long minDocumentCount = JSONUtil.getOptionalLong(aggregateJson, "minDocumentCount");
        String timeZoneString = aggregateJson.optString("timeZone");
        TimeZone timeZone = timeZoneString == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneString);
        int calendarField = this.getCalendarField(aggregateJson.getString("calendarField"));
        return new CalendarFieldAggregation(aggregationName, field, minDocumentCount, timeZone, calendarField);
    }

    private int getCalendarField(String calendarField) {
        try {
            Field field = Calendar.class.getDeclaredField(calendarField);
            return field.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new VisalloException("Invalid calendar field: " + calendarField, ex);
        }
    }

    protected void applySortToQuery(QueryAndData queryAndData, SearchOptions searchOptions) {
        JSONArray sortsJson;
        String[] sorts = (String[])searchOptions.getOptionalParameter("sort[]", String[].class);
        if (sorts == null && (sortsJson = (JSONArray)searchOptions.getOptionalParameter("sort", JSONArray.class)) != null) {
            sorts = JSONUtil.toStringList(sortsJson).toArray(new String[sortsJson.length()]);
        }
        if (sorts == null) {
            return;
        }
        String[] stringArray = sorts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String sort;
            String propertyName = sort = stringArray[i];
            SortDirection direction = SortDirection.ASCENDING;
            if (propertyName.toUpperCase().endsWith(":ASCENDING")) {
                direction = SortDirection.ASCENDING;
                propertyName = propertyName.substring(0, propertyName.length() - ":ASCENDING".length());
            } else if (propertyName.toUpperCase().endsWith(":DESCENDING")) {
                direction = SortDirection.DESCENDING;
                propertyName = propertyName.substring(0, propertyName.length() - ":DESCENDING".length());
            }
            queryAndData.getQuery().sort(propertyName, direction);
        }
    }

    protected QueryResultsIterable<? extends VertexiumObject> getSearchResults(QueryAndData queryAndData, EnumSet<FetchHint> fetchHints) {
        try (TraceSpan trace = Trace.start("getSearchResults");){
            QueryResultsIterable queryResultsIterable = queryAndData.getQuery().search(this.getResultType(), fetchHints);
            return queryResultsIterable;
        }
    }

    protected abstract EnumSet<VertexiumObjectType> getResultType();

    protected abstract QueryAndData getQuery(SearchOptions var1, Authorizations var2);

    protected void applyConceptTypeFilterToQuery(QueryAndData queryAndData, SearchOptions searchOptions) {
        Collection<OntologyRepository.ElementTypeFilter> conceptTypeFilters = this.getConceptTypeFilters(searchOptions);
        if (conceptTypeFilters != null) {
            this.ontologyRepository.addConceptTypeFilterToQuery(queryAndData.getQuery(), conceptTypeFilters, searchOptions.getWorkspaceId());
        }
    }

    protected void applyEdgeLabelFilterToQuery(QueryAndData queryAndData, SearchOptions searchOptions) {
        Collection<OntologyRepository.ElementTypeFilter> edgeFilters = this.getEdgeLabelFilters(searchOptions);
        if (edgeFilters != null) {
            this.ontologyRepository.addEdgeLabelFilterToQuery(queryAndData.getQuery(), edgeFilters, searchOptions.getWorkspaceId());
        }
    }

    protected Collection<OntologyRepository.ElementTypeFilter> getEdgeLabelFilters(SearchOptions searchOptions) {
        return this.getElementTypeFilters("edgeLabels", "edgeLabel", searchOptions);
    }

    protected Collection<OntologyRepository.ElementTypeFilter> getConceptTypeFilters(SearchOptions searchOptions) {
        return this.getElementTypeFilters("conceptTypes", "conceptType", searchOptions);
    }

    private Collection<OntologyRepository.ElementTypeFilter> getElementTypeFilters(String parameterName, String legacyParameterName, SearchOptions searchOptions) {
        String typesStr = (String)((Object)searchOptions.getOptionalParameter(parameterName, String.class));
        if (typesStr != null) {
            JSONArray types = new JSONArray(typesStr);
            ArrayList<OntologyRepository.ElementTypeFilter> filters = new ArrayList<OntologyRepository.ElementTypeFilter>(types.length());
            for (int i = 0; i < types.length(); ++i) {
                JSONObject type = types.getJSONObject(i);
                OntologyRepository.ElementTypeFilter filter = (OntologyRepository.ElementTypeFilter)ClientApiConverter.toClientApi((JSONObject)type, OntologyRepository.ElementTypeFilter.class);
                filters.add(filter);
            }
            return filters;
        }
        String elementType = (String)((Object)searchOptions.getOptionalParameter(legacyParameterName, String.class));
        if (elementType != null) {
            Boolean includeChildNodes = (Boolean)((Object)searchOptions.getOptionalParameter("includeChildNodes", Boolean.class));
            return Collections.singleton(new OntologyRepository.ElementTypeFilter(elementType, includeChildNodes));
        }
        return null;
    }

    protected void applyFiltersToQuery(QueryAndData queryAndData, JSONArray filterJson, User user, SearchOptions searchOptions) {
        for (int i = 0; i < filterJson.length(); ++i) {
            JSONObject obj = filterJson.getJSONObject(i);
            if (obj.length() <= 0) continue;
            if (obj.has("propertyName")) {
                this.updateQueryWithPropertyNameFilter(queryAndData.getQuery(), obj, user, searchOptions);
                continue;
            }
            if (obj.has("dataType")) {
                this.updateQueryWithDataTypeFilter(queryAndData.getQuery(), obj, user, searchOptions);
                continue;
            }
            throw new VisalloException("Query filters must have either a propertyName or dataType field. Invalid filter: " + filterJson.toString());
        }
    }

    protected JSONArray getFilterJson(SearchOptions searchOptions, String workspaceId) {
        JSONArray filterJson = searchOptions.getRequiredParameter("filter", JSONArray.class);
        this.ontologyRepository.resolvePropertyIds(filterJson, workspaceId);
        return filterJson;
    }

    private void updateQueryWithDataTypeFilter(Query graphQuery, JSONObject obj, User user, SearchOptions searchOptions) {
        block6: {
            String dataType = obj.getString("dataType");
            String predicateString = obj.optString("predicate");
            PropertyType propertyType = PropertyType.valueOf((String)dataType);
            try {
                if ("has".equals(predicateString)) {
                    graphQuery.has(PropertyType.getTypeClass((PropertyType)propertyType));
                    break block6;
                }
                if ("hasNot".equals(predicateString)) {
                    graphQuery.hasNot(PropertyType.getTypeClass((PropertyType)propertyType));
                    break block6;
                }
                if ("in".equals(predicateString)) {
                    JSONArray values = obj.getJSONArray("values");
                    graphQuery.has(PropertyType.getTypeClass((PropertyType)propertyType), (Predicate)Contains.IN, JSONUtil.toList(values));
                    break block6;
                }
                JSONArray values = obj.getJSONArray("values");
                Object value0 = this.jsonValueToObject(values, propertyType, 0);
                if (PropertyType.GEO_LOCATION.equals((Object)propertyType)) {
                    GeoCompare geoComparePredicate = GeoCompare.valueOf((String)predicateString.toUpperCase());
                    graphQuery.has(GeoShape.class, (Predicate)geoComparePredicate, value0);
                    break block6;
                }
                throw new UnsupportedOperationException("Data type queries are not yet supported for type: " + dataType);
            }
            catch (ParseException ex) {
                throw new VisalloException("Could not update query with filter:\n" + obj.toString(2), ex);
            }
        }
    }

    private void updateQueryWithPropertyNameFilter(Query graphQuery, JSONObject obj, User user, SearchOptions searchOptions) {
        block17: {
            try {
                String predicateString = obj.optString("predicate");
                String propertyName = obj.getString("propertyName");
                if ("has".equals(predicateString)) {
                    graphQuery.has(propertyName);
                    break block17;
                }
                if ("hasNot".equals(predicateString)) {
                    graphQuery.hasNot(propertyName);
                    break block17;
                }
                if ("in".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Contains.IN, JSONUtil.toList(obj.getJSONArray("values")));
                    break block17;
                }
                PropertyType propertyDataType = PropertyType.convert((String)obj.optString("propertyDataType"));
                JSONArray values = obj.getJSONArray("values");
                Object value0 = this.jsonValueToObject(values, propertyDataType, 0);
                if (PropertyType.STRING.equals((Object)propertyDataType) && (predicateString == null || "~".equals(predicateString) || "".equals(predicateString))) {
                    graphQuery.has(propertyName, (Predicate)TextPredicate.CONTAINS, value0);
                    break block17;
                }
                if (PropertyType.DATE.equals((Object)propertyDataType)) {
                    this.applyDateToQuery(graphQuery, obj, predicateString, values, searchOptions);
                    break block17;
                }
                if (PropertyType.BOOLEAN.equals((Object)propertyDataType)) {
                    graphQuery.has(propertyName, (Predicate)Compare.EQUAL, value0);
                    break block17;
                }
                if (PropertyType.GEO_LOCATION.equals((Object)propertyDataType)) {
                    GeoCompare geoComparePredicate = GeoCompare.valueOf((String)predicateString.toUpperCase());
                    graphQuery.has(propertyName, (Predicate)geoComparePredicate, value0);
                    break block17;
                }
                if ("<".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, value0);
                    break block17;
                }
                if (">".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN, value0);
                    break block17;
                }
                if ("range".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, value0);
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, this.jsonValueToObject(values, propertyDataType, 1));
                    break block17;
                }
                if ("=".equals(predicateString) || "equal".equals(predicateString)) {
                    if (PropertyType.DIRECTORY_ENTITY.equals((Object)propertyDataType) && value0 instanceof JSONObject) {
                        this.applyDirectoryEntityJsonObjectEqualityToQuery(graphQuery, propertyName, (JSONObject)value0, user);
                    } else if (PropertyType.DOUBLE.equals((Object)propertyDataType)) {
                        this.applyDoubleEqualityToQuery(graphQuery, obj, value0);
                    } else {
                        graphQuery.has(propertyName, (Predicate)Compare.EQUAL, value0);
                    }
                    break block17;
                }
                throw new VisalloException("unhandled query\n" + obj.toString(2));
            }
            catch (ParseException ex) {
                throw new VisalloException("Could not update query with filter:\n" + obj.toString(2), ex);
            }
        }
    }

    private void applyDirectoryEntityJsonObjectEqualityToQuery(Query graphQuery, String propertyName, JSONObject value0, User user) {
        String directoryEntityId = value0.optString("directoryEntityId", null);
        if (directoryEntityId != null) {
            graphQuery.has(propertyName, (Predicate)Compare.EQUAL, (Object)directoryEntityId);
        } else if (value0.optBoolean("currentUser", false)) {
            directoryEntityId = this.directoryRepository.getDirectoryEntityId(user);
            graphQuery.has(propertyName, (Predicate)Compare.EQUAL, (Object)directoryEntityId);
        } else {
            throw new VisalloException("Invalid directory entity JSONObject filter:\n" + value0.toString(2));
        }
    }

    private void applyDoubleEqualityToQuery(Query graphQuery, JSONObject obj, Object value0) throws ParseException {
        JSONObject metadata;
        String propertyName = obj.getString("propertyName");
        JSONObject jSONObject = metadata = obj.has("metadata") ? obj.getJSONObject("metadata") : null;
        if (metadata != null && metadata.has("http://visallo.org#inputPrecision") && value0 instanceof Double) {
            int inputPrecision;
            double lowerBound;
            double doubleParam = (Double)value0;
            double upperBound = Precision.equals((double)doubleParam, (double)(lowerBound = Precision.round((double)doubleParam, (int)(inputPrecision = Math.max(metadata.getInt("http://visallo.org#inputPrecision"), 0)), (int)1)), (double)Precision.EPSILON) ? lowerBound + Math.pow(10.0, -inputPrecision) : Precision.round((double)doubleParam, (int)inputPrecision, (int)0);
            graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Object)(lowerBound - Precision.EPSILON));
            graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Object)(upperBound + Precision.EPSILON));
        } else {
            graphQuery.has(propertyName, (Predicate)Compare.EQUAL, value0);
        }
    }

    private void applyDateToQuery(Query graphQuery, JSONObject obj, String predicate, JSONArray values, SearchOptions searchOptions) throws ParseException {
        String propertyName = obj.getString("propertyName");
        PropertyType propertyDataType = PropertyType.DATE;
        OntologyProperty property = this.ontologyRepository.getPropertyByIRI(propertyName, searchOptions.getWorkspaceId());
        if (property != null && values.length() > 0) {
            JSONObject fromNow;
            String displayType = property.getDisplayType();
            boolean isDateOnly = displayType != null && displayType.equals("dateOnly");
            boolean isRelative = values.get(0) instanceof JSONObject;
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("UTC"));
            if (isRelative) {
                fromNow = (JSONObject)values.get(0);
                calendar.setTime(new Date());
                this.moveDateToStart(calendar, isDateOnly);
                ((Calendar)calendar).add(fromNow.getInt("unit"), fromNow.getInt("amount"));
            } else {
                Date date0 = (Date)this.jsonValueToObject(values, propertyDataType, 0);
                calendar.setTime(date0);
            }
            if (predicate == null || predicate.equals("equal") || predicate.equals("=")) {
                this.moveDateToStart(calendar, isDateOnly);
                graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Object)calendar.getTime());
                this.moveDateToEnd(calendar, isDateOnly);
                graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Object)calendar.getTime());
            } else if (predicate.equals("range")) {
                if (!isRelative) {
                    this.moveDateToStart(calendar, isDateOnly);
                }
                graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Object)calendar.getTime());
                if (values.get(1) instanceof JSONObject) {
                    fromNow = (JSONObject)values.get(1);
                    calendar.setTime(new Date());
                    this.moveDateToStart(calendar, isDateOnly);
                    ((Calendar)calendar).add(fromNow.getInt("unit"), fromNow.getInt("amount"));
                    this.moveDateToEnd(calendar, isDateOnly);
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Object)calendar.getTime());
                } else {
                    calendar.setTime((Date)this.jsonValueToObject(values, propertyDataType, 1));
                    this.moveDateToEnd(calendar, isDateOnly);
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Object)calendar.getTime());
                }
            } else if (predicate.equals("<")) {
                this.moveDateToStart(calendar, isDateOnly);
                graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Object)calendar.getTime());
            } else if (predicate.equals(">")) {
                this.moveDateToEnd(calendar, isDateOnly);
                graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Object)calendar.getTime());
            }
        }
    }

    private void moveDateToStart(Calendar calendar, boolean dateOnly) {
        if (dateOnly) {
            calendar.set(11, 0);
            calendar.set(12, 0);
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private void moveDateToEnd(Calendar calendar, boolean dateOnly) {
        if (dateOnly) {
            calendar.add(5, 1);
        } else {
            calendar.add(12, 1);
        }
    }

    private Object jsonValueToObject(JSONArray values, PropertyType propertyDataType, int index) throws ParseException {
        if (values.get(index) instanceof JSONObject) {
            return values.get(index);
        }
        return OntologyProperty.convert(values, propertyDataType, index);
    }

    protected OntologyRepository getOntologyRepository() {
        return this.ontologyRepository;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public static class QueryAndData {
        private final Query query;

        public QueryAndData(Query query) {
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }
    }
}

