/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.EdgeInfo;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.query.EmptyResultsGraphQuery;
import org.vertexium.query.Query;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.model.search.VertexiumObjectSearchRunnerBase;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class VertexiumObjectSearchRunnerWithRelatedBase
extends VertexiumObjectSearchRunnerBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexiumObjectSearchRunnerWithRelatedBase.class);

    protected VertexiumObjectSearchRunnerWithRelatedBase(OntologyRepository ontologyRepository, Graph graph, Configuration configuration, DirectoryRepository directoryRepository) {
        super(ontologyRepository, graph, configuration, directoryRepository);
    }

    @Override
    protected VertexiumObjectSearchRunnerBase.QueryAndData getQuery(SearchOptions searchOptions, Authorizations authorizations) {
        JSONArray filterJson = this.getFilterJson(searchOptions, searchOptions.getWorkspaceId());
        String queryStringParam = (String)((Object)searchOptions.getOptionalParameter("q", String.class));
        Object[] relatedToVertexIdsParam = (String[])searchOptions.getOptionalParameter("relatedToVertexIds[]", String[].class);
        String elementExtendedDataParam = (String)((Object)searchOptions.getOptionalParameter("elementExtendedData", String.class));
        ImmutableList relatedToVertexIds = Collections.emptyList();
        ElementExtendedData elementExtendedData = null;
        if (relatedToVertexIdsParam == null && elementExtendedDataParam == null) {
            queryStringParam = searchOptions.getRequiredParameter("q", String.class);
        } else if (elementExtendedDataParam != null) {
            elementExtendedData = ElementExtendedData.fromJsonString(elementExtendedDataParam);
        } else {
            relatedToVertexIds = ImmutableList.copyOf((Object[])relatedToVertexIdsParam);
        }
        if (StringUtils.isBlank((String)queryStringParam)) {
            queryStringParam = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("search %s (relatedToVertexIds: %s, elementExtendedData: %s)\n%s", queryStringParam, Joiner.on((String)",").join((Iterable)relatedToVertexIds), elementExtendedData, filterJson.toString(2));
        }
        Object graphQuery = this.getGraph().query(queryStringParam, authorizations);
        if (elementExtendedData != null) {
            graphQuery = graphQuery.hasExtendedData(elementExtendedData.elementType, elementExtendedData.elementId, elementExtendedData.tableName);
        } else if (!relatedToVertexIds.isEmpty()) {
            String[] edgeLabels = this.getEdgeLabels(searchOptions);
            Set allRelatedIds = relatedToVertexIds.stream().map(vertexId -> {
                Vertex vertex = this.getGraph().getVertex(vertexId, FetchHint.EDGE_REFS, authorizations);
                Preconditions.checkNotNull((Object)vertex, (Object)("Could not find vertex: " + vertexId));
                return vertex;
            }).flatMap(vertex -> {
                Iterable edgeInfos = vertex.getEdgeInfos(Direction.BOTH, edgeLabels, authorizations);
                return StreamSupport.stream(edgeInfos.spliterator(), false).map(EdgeInfo::getVertexId);
            }).collect(Collectors.toSet());
            graphQuery = allRelatedIds.isEmpty() ? new EmptyResultsGraphQuery() : graphQuery.hasId(allRelatedIds);
        }
        return new VertexiumObjectSearchRunnerBase.QueryAndData((Query)graphQuery);
    }

    private String[] getEdgeLabels(SearchOptions searchOptions) {
        Collection<OntologyRepository.ElementTypeFilter> edgeLabelFilters = this.getEdgeLabelFilters(searchOptions);
        if (edgeLabelFilters == null || edgeLabelFilters.isEmpty()) {
            return null;
        }
        return (String[])edgeLabelFilters.stream().flatMap(filter -> {
            if (filter.includeChildNodes) {
                return this.getOntologyRepository().getRelationshipAndAllChildrenByIRI(filter.iri, searchOptions.getWorkspaceId()).stream().map(Relationship::getIRI);
            }
            return Stream.of(filter.iri);
        }).toArray(String[]::new);
    }

    private static class ElementExtendedData {
        public final ElementType elementType;
        public final String elementId;
        public final String tableName;

        private ElementExtendedData(ElementType elementType, String elementId, String tableName) {
            this.elementType = elementType;
            this.elementId = elementId;
            this.tableName = tableName;
        }

        public static ElementExtendedData fromJsonString(String str) {
            JSONObject json = new JSONObject(str);
            ElementType elementType = null;
            String elementTypeString = json.optString("elementType");
            if (!Strings.isNullOrEmpty((String)elementTypeString)) {
                elementType = ElementType.valueOf((String)elementTypeString.toUpperCase());
            }
            String elementId = json.optString("elementId", null);
            String tableName = json.optString("tableName", null);
            return new ElementExtendedData(elementType, elementId, tableName);
        }

        public String toString() {
            return "ElementExtendedData{elementType='" + this.elementType + '\'' + ", elementId='" + this.elementId + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }
    }
}

